/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.bookmark;

import ca.odell.glazedlists.swing.TableComparatorChooser;
import java.util.Optional;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import mediathek.swing.IconUtils;
import mediathek.swing.IconizedCheckBoxMenuItem;
import mediathek.swing.table.ATableColumnSettingsManager;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign2.MaterialDesignE;
import org.kordamp.ikonli.materialdesign2.MaterialDesignN;

public class BookmarkTableColumnSettingsManager<E>
extends ATableColumnSettingsManager {
    protected final TableComparatorChooser<E> comparatorChooser;

    public BookmarkTableColumnSettingsManager(JTable table, String configPrefix, TableComparatorChooser<E> comparatorChooser) {
        super(table, configPrefix);
        this.comparatorChooser = comparatorChooser;
    }

    private JCheckBoxMenuItem createMenuItem(String columnName, boolean visible) {
        JCheckBoxMenuItem item = columnName.equalsIgnoreCase("Gesehen") ? new IconizedCheckBoxMenuItem(IconUtils.of((Ikon)MaterialDesignE.EYE), visible) : (columnName.equalsIgnoreCase("Notiz") ? new IconizedCheckBoxMenuItem(IconUtils.of((Ikon)MaterialDesignN.NOTE), visible) : new JCheckBoxMenuItem(columnName, visible));
        return item;
    }

    @Override
    public void installContextMenu() {
        this.load();
        JPopupMenu popup = new JPopupMenu();
        for (TableColumn col : this.allColumns) {
            String columnName = col.getIdentifier().toString();
            Optional<ATableColumnSettingsManager.ColumnSetting> csOpt = this.lastSettings.stream().filter(s -> s.id.equals(columnName)).findFirst();
            boolean visible = csOpt.map(s -> s.visible).orElse(true);
            JCheckBoxMenuItem item = this.createMenuItem(columnName, visible);
            item.addActionListener(actionEvent -> {
                TableColumnModel m = this.table.getColumnModel();
                csOpt.ifPresent(s -> {
                    s.visible = item.isSelected();
                });
                if (item.isSelected()) {
                    if (!this.isInModel(col)) {
                        m.addColumn(col);
                        int lastIndex = m.getColumnCount() - 1;
                        int target = csOpt.map(s -> s.position).orElse(lastIndex);
                        m.moveColumn(lastIndex, Math.max(0, Math.min(target, lastIndex)));
                    }
                } else if (this.isInModel(col)) {
                    int idx = m.getColumnIndex(columnName);
                    csOpt.ifPresent(s -> {
                        s.position = idx;
                    });
                    m.removeColumn(col);
                }
                this.save();
            });
            popup.add(item);
        }
        popup.addSeparator();
        JMenuItem item = new JMenuItem("Sortierschl\u00fcssel zur\u00fccksetzen");
        item.addActionListener(actionEvent -> this.comparatorChooser.clearComparator());
        popup.add(item);
        this.table.getTableHeader().setComponentPopupMenu(popup);
    }
}

