/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.ttml.parsers;

import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import mediathek.tool.ttml.ITtmlParser;
import mediathek.tool.ttml.StyledString;
import mediathek.tool.ttml.Subtitle;
import mediathek.tool.ttml.TimedTextMarkupLanguageParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlTimedTextMarkupLanguageParser
extends TimedTextMarkupLanguageParser
implements ITtmlParser {
    private static final Logger logger = LogManager.getLogger();
    private final SimpleDateFormat sdfFlash = new SimpleDateFormat("s.S");

    private Date parseFlash(String tStamp) throws ParseException {
        Date da = tStamp.contains(":") ? this.ttmlFormat.parse(tStamp) : this.sdfFlash.parse(tStamp + "00");
        return da;
    }

    private void buildFilmListFlash() throws Exception {
        NodeList subtitleData = this.doc.getElementsByTagName("p");
        for (int i = 0; i < subtitleData.getLength(); ++i) {
            Subtitle subtitle = new Subtitle();
            Node subnode = subtitleData.item(i);
            if (subnode.hasAttributes()) {
                NamedNodeMap attrMap = subnode.getAttributes();
                Node beginNode = attrMap.getNamedItem("begin");
                Node endNode = attrMap.getNamedItem("end");
                if (beginNode != null && endNode != null) {
                    subtitle.setBegin(this.parseFlash(beginNode.getNodeValue()));
                    subtitle.setEnd(this.parseFlash(endNode.getNodeValue()));
                    StyledString textContent = new StyledString(subnode.getTextContent(), this.color, "#000000C2");
                    Node col = attrMap.getNamedItem("tts:color");
                    if (col != null) {
                        textContent.setColor(col.getNodeValue());
                    } else {
                        NodeList childNodes = subnode.getChildNodes();
                        for (int j = 0; j < childNodes.getLength(); ++j) {
                            Node node = childNodes.item(j);
                            if (!node.getNodeName().equalsIgnoreCase("span")) continue;
                            NamedNodeMap attr = node.getAttributes();
                            Node co = attr.getNamedItem("tts:color");
                            textContent.setColor(co.getNodeValue());
                        }
                    }
                    subtitle.getListOfStrings().add(textContent);
                }
            }
            this.subtitleList.add(subtitle);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean parse(Path ttmlFilePath) {
        logger.trace("Parsing TTML file with Flash parser");
        try {
            String s;
            this.doc = this.getDocumentBuilder().parse(ttmlFilePath.toFile());
            NodeList metaData = this.doc.getElementsByTagName("tt");
            NodeList colorNote = this.doc.getElementsByTagName("style");
            if (metaData == null) {
                logger.warn("Missing metadata tag.");
                return false;
            }
            Node node = metaData.item(0);
            if (!node.hasAttributes()) {
                logger.warn("Missing attributes.");
                return false;
            }
            NamedNodeMap attrMap = node.getAttributes();
            Node xmlns = attrMap.getNamedItem("xmlns");
            if (xmlns != null && !(s = xmlns.getNodeValue()).equals("http://www.w3.org/2006/04/ttaf1") && !s.equals("http://www.w3.org/ns/ttml")) {
                logger.warn("Invalid namespace.");
                return false;
            }
            if (colorNote == null) throw new Exception("Unknown File Format");
            if (colorNote.getLength() == 0) {
                this.color = "#FFFFFF";
            } else {
                node = colorNote.item(0);
                if (!node.hasAttributes()) throw new Exception("Unknown File Format");
                attrMap = node.getAttributes();
                Node col = attrMap.getNamedItem("tts:color");
                if (col != null && !col.getNodeValue().isEmpty()) {
                    this.color = col.getNodeValue();
                }
            }
            this.buildFilmListFlash();
            return true;
        }
        catch (Exception ex) {
            logger.error("File: {}", (Object)ttmlFilePath, (Object)ex);
            return false;
        }
    }
}

