/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.tree;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.ref.JsonRef;
import com.github.fge.jsonschema.core.tree.BaseSchemaTree;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.core.tree.key.SchemaKey;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;

@ParametersAreNonnullByDefault
@Immutable
public final class CanonicalSchemaTree
extends BaseSchemaTree {
    public CanonicalSchemaTree(SchemaKey key, JsonNode baseNode) {
        super(key, baseNode, JsonPointer.empty());
    }

    @Deprecated
    public CanonicalSchemaTree(JsonNode baseNode) {
        this(SchemaKey.anonymousKey(), baseNode);
    }

    @Deprecated
    public CanonicalSchemaTree(JsonRef loadingRef, JsonNode baseNode) {
        this(SchemaKey.forJsonRef(loadingRef), baseNode);
    }

    private CanonicalSchemaTree(CanonicalSchemaTree other, JsonPointer newPointer) {
        super(other, newPointer);
    }

    @Override
    public SchemaTree append(JsonPointer pointer) {
        JsonPointer newPointer = this.pointer.append(pointer);
        return new CanonicalSchemaTree(this, newPointer);
    }

    @Override
    public SchemaTree setPointer(JsonPointer pointer) {
        return new CanonicalSchemaTree(this, pointer);
    }

    @Override
    public boolean containsRef(JsonRef ref) {
        return this.key.getLoadingRef().contains(ref);
    }

    @Override
    @Nullable
    public JsonPointer matchingPointer(JsonRef ref) {
        if (!ref.isLegal()) {
            return null;
        }
        JsonPointer ptr = ref.getPointer();
        return ptr.path(this.baseNode).isMissingNode() ? null : ptr;
    }
}

