/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.health;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.cluster.health.ClusterShardHealth;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.routing.IndexRoutingTable;
import org.opensearch.cluster.routing.IndexShardRoutingTable;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@PublicApi(since="1.0.0")
public final class ClusterIndexHealth
implements Iterable<ClusterShardHealth>,
Writeable,
ToXContentFragment {
    private static final String STATUS = "status";
    private static final String NUMBER_OF_SHARDS = "number_of_shards";
    private static final String NUMBER_OF_REPLICAS = "number_of_replicas";
    private static final String ACTIVE_PRIMARY_SHARDS = "active_primary_shards";
    private static final String ACTIVE_SHARDS = "active_shards";
    private static final String RELOCATING_SHARDS = "relocating_shards";
    private static final String INITIALIZING_SHARDS = "initializing_shards";
    private static final String UNASSIGNED_SHARDS = "unassigned_shards";
    private static final String SHARDS = "shards";
    private static final ConstructingObjectParser<ClusterIndexHealth, String> PARSER = new ConstructingObjectParser("cluster_index_health", true, (parsedObjects, index) -> {
        Map<Integer, ClusterShardHealth> shards;
        int i = 0;
        int numberOfShards = (Integer)parsedObjects[i++];
        int numberOfReplicas = (Integer)parsedObjects[i++];
        int activeShards = (Integer)parsedObjects[i++];
        int relocatingShards = (Integer)parsedObjects[i++];
        int initializingShards = (Integer)parsedObjects[i++];
        int unassignedShards = (Integer)parsedObjects[i++];
        int activePrimaryShards = (Integer)parsedObjects[i++];
        String statusStr = (String)parsedObjects[i++];
        ClusterHealthStatus status = ClusterHealthStatus.fromString(statusStr);
        List shardList = (List)parsedObjects[i];
        if (shardList == null || shardList.isEmpty()) {
            shards = Collections.emptyMap();
        } else {
            shards = new HashMap(shardList.size());
            for (ClusterShardHealth shardHealth : shardList) {
                shards.put(shardHealth.getShardId(), shardHealth);
            }
        }
        return new ClusterIndexHealth((String)index, numberOfShards, numberOfReplicas, activeShards, relocatingShards, initializingShards, unassignedShards, activePrimaryShards, status, shards);
    });
    public static final ObjectParser.NamedObjectParser<ClusterShardHealth, String> SHARD_PARSER = (p, indexIgnored, shardId) -> ClusterShardHealth.innerFromXContent(p, Integer.valueOf(shardId));
    private final String index;
    private final int numberOfShards;
    private final int numberOfReplicas;
    private final int activeShards;
    private final int relocatingShards;
    private final int initializingShards;
    private final int unassignedShards;
    private int delayedUnassignedShards;
    private final int activePrimaryShards;
    private final ClusterHealthStatus status;
    private final Map<Integer, ClusterShardHealth> shards;

    public ClusterIndexHealth(IndexMetadata indexMetadata, IndexRoutingTable indexRoutingTable) {
        this.index = indexMetadata.getIndex().getName();
        this.numberOfShards = indexMetadata.getNumberOfShards();
        this.numberOfReplicas = indexMetadata.getNumberOfReplicas();
        this.shards = new HashMap<Integer, ClusterShardHealth>();
        for (IndexShardRoutingTable shardRoutingTable : indexRoutingTable) {
            int shardId = shardRoutingTable.shardId().id();
            this.shards.put(shardId, new ClusterShardHealth(shardId, shardRoutingTable, indexMetadata));
        }
        ClusterHealthStatus computeStatus = ClusterHealthStatus.GREEN;
        int computeActivePrimaryShards = 0;
        int computeActiveShards = 0;
        int computeRelocatingShards = 0;
        int computeInitializingShards = 0;
        int computeUnassignedShards = 0;
        int computeDelayedUnassignedShards = 0;
        for (ClusterShardHealth shardHealth : this.shards.values()) {
            if (shardHealth.isPrimaryActive()) {
                ++computeActivePrimaryShards;
            }
            computeActiveShards += shardHealth.getActiveShards();
            computeRelocatingShards += shardHealth.getRelocatingShards();
            computeInitializingShards += shardHealth.getInitializingShards();
            computeUnassignedShards += shardHealth.getUnassignedShards();
            computeDelayedUnassignedShards += shardHealth.getDelayedUnassignedShards();
            computeStatus = ClusterIndexHealth.getIndexHealthStatus(shardHealth.getStatus(), computeStatus);
        }
        if (this.shards.isEmpty()) {
            computeStatus = ClusterHealthStatus.RED;
        }
        this.status = computeStatus;
        this.activePrimaryShards = computeActivePrimaryShards;
        this.activeShards = computeActiveShards;
        this.relocatingShards = computeRelocatingShards;
        this.initializingShards = computeInitializingShards;
        this.unassignedShards = computeUnassignedShards;
        this.delayedUnassignedShards = computeDelayedUnassignedShards;
    }

    public ClusterIndexHealth(IndexMetadata indexMetadata, IndexRoutingTable indexRoutingTable, ClusterHealthRequest.Level healthLevel) {
        boolean isShardLevelHealthRequired;
        this.index = indexMetadata.getIndex().getName();
        this.numberOfShards = indexMetadata.getNumberOfShards();
        this.numberOfReplicas = indexMetadata.getNumberOfReplicas();
        this.shards = new HashMap<Integer, ClusterShardHealth>();
        ClusterHealthStatus computeStatus = ClusterHealthStatus.GREEN;
        int computeActivePrimaryShards = 0;
        int computeActiveShards = 0;
        int computeRelocatingShards = 0;
        int computeInitializingShards = 0;
        int computeUnassignedShards = 0;
        int computeDelayedUnassignedShards = 0;
        boolean isSearchOnlyClusterBlockEnabled = indexMetadata.getSettings().getAsBoolean(IndexMetadata.INDEX_BLOCKS_SEARCH_ONLY_SETTING.getKey(), false);
        boolean bl = isShardLevelHealthRequired = healthLevel == ClusterHealthRequest.Level.SHARDS;
        if (isShardLevelHealthRequired) {
            for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                int shardId = indexShardRoutingTable.shardId().id();
                ClusterShardHealth shardHealth = new ClusterShardHealth(shardId, indexShardRoutingTable, indexMetadata);
                if (shardHealth.isPrimaryActive()) {
                    ++computeActivePrimaryShards;
                }
                computeActiveShards += shardHealth.getActiveShards();
                computeRelocatingShards += shardHealth.getRelocatingShards();
                computeInitializingShards += shardHealth.getInitializingShards();
                computeUnassignedShards += shardHealth.getUnassignedShards();
                computeDelayedUnassignedShards += shardHealth.getDelayedUnassignedShards();
                computeStatus = ClusterIndexHealth.getIndexHealthStatus(shardHealth.getStatus(), computeStatus);
                this.shards.put(shardId, shardHealth);
            }
        } else {
            for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                int activeShardsPerShardId = 0;
                List<ShardRouting> shardRoutings = indexShardRoutingTable.shards();
                int shardRoutingCountPerShardId = shardRoutings.size();
                for (int index = 0; index < shardRoutingCountPerShardId; ++index) {
                    ShardRouting shardRouting = shardRoutings.get(index);
                    if (shardRouting.active()) {
                        ++computeActiveShards;
                        ++activeShardsPerShardId;
                        if (!shardRouting.relocating()) continue;
                        ++computeRelocatingShards;
                        continue;
                    }
                    if (shardRouting.initializing()) {
                        ++computeInitializingShards;
                        continue;
                    }
                    if (!shardRouting.unassigned()) continue;
                    ++computeUnassignedShards;
                    if (!shardRouting.unassignedInfo().isDelayed()) continue;
                    ++computeDelayedUnassignedShards;
                }
                ShardRouting primaryShard = indexShardRoutingTable.primaryShard();
                if (primaryShard == null) {
                    if (isSearchOnlyClusterBlockEnabled) {
                        computeStatus = ClusterIndexHealth.getIndexHealthStatus(ClusterHealthStatus.GREEN, computeStatus);
                        continue;
                    }
                    computeStatus = ClusterIndexHealth.getIndexHealthStatus(ClusterHealthStatus.RED, computeStatus);
                    continue;
                }
                if (primaryShard.active()) {
                    ++computeActivePrimaryShards;
                }
                ClusterHealthStatus shardHealth = ClusterShardHealth.getShardHealth(primaryShard, activeShardsPerShardId, shardRoutingCountPerShardId, indexMetadata);
                computeStatus = ClusterIndexHealth.getIndexHealthStatus(shardHealth, computeStatus);
            }
        }
        if (indexRoutingTable.shards() != null && indexRoutingTable.shards().isEmpty()) {
            computeStatus = ClusterHealthStatus.RED;
        }
        this.status = computeStatus;
        this.activePrimaryShards = computeActivePrimaryShards;
        this.activeShards = computeActiveShards;
        this.relocatingShards = computeRelocatingShards;
        this.initializingShards = computeInitializingShards;
        this.unassignedShards = computeUnassignedShards;
        this.delayedUnassignedShards = computeDelayedUnassignedShards;
    }

    public static ClusterHealthStatus getIndexHealthStatus(ClusterHealthStatus shardHealth, ClusterHealthStatus computeStatus) {
        switch (shardHealth) {
            case RED: {
                return ClusterHealthStatus.RED;
            }
            case YELLOW: {
                if (computeStatus != ClusterHealthStatus.RED) {
                    return ClusterHealthStatus.YELLOW;
                }
                return ClusterHealthStatus.RED;
            }
        }
        return computeStatus;
    }

    public ClusterIndexHealth(StreamInput in) throws IOException {
        this.index = in.readString();
        this.numberOfShards = in.readVInt();
        this.numberOfReplicas = in.readVInt();
        this.activePrimaryShards = in.readVInt();
        this.activeShards = in.readVInt();
        this.relocatingShards = in.readVInt();
        this.initializingShards = in.readVInt();
        this.unassignedShards = in.readVInt();
        this.status = ClusterHealthStatus.fromValue(in.readByte());
        int size = in.readVInt();
        this.shards = new HashMap<Integer, ClusterShardHealth>(size);
        for (int i = 0; i < size; ++i) {
            ClusterShardHealth shardHealth = new ClusterShardHealth(in);
            this.shards.put(shardHealth.getShardId(), shardHealth);
        }
    }

    ClusterIndexHealth(String index, int numberOfShards, int numberOfReplicas, int activeShards, int relocatingShards, int initializingShards, int unassignedShards, int activePrimaryShards, ClusterHealthStatus status, Map<Integer, ClusterShardHealth> shards) {
        this.index = index;
        this.numberOfShards = numberOfShards;
        this.numberOfReplicas = numberOfReplicas;
        this.activeShards = activeShards;
        this.relocatingShards = relocatingShards;
        this.initializingShards = initializingShards;
        this.unassignedShards = unassignedShards;
        this.activePrimaryShards = activePrimaryShards;
        this.status = status;
        this.shards = shards;
    }

    public String getIndex() {
        return this.index;
    }

    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    public int getNumberOfReplicas() {
        return this.numberOfReplicas;
    }

    public int getActiveShards() {
        return this.activeShards;
    }

    public int getRelocatingShards() {
        return this.relocatingShards;
    }

    public int getActivePrimaryShards() {
        return this.activePrimaryShards;
    }

    public int getInitializingShards() {
        return this.initializingShards;
    }

    public int getUnassignedShards() {
        return this.unassignedShards;
    }

    public int getDelayedUnassignedShards() {
        return this.delayedUnassignedShards;
    }

    public ClusterHealthStatus getStatus() {
        return this.status;
    }

    public Map<Integer, ClusterShardHealth> getShards() {
        return this.shards;
    }

    @Override
    public Iterator<ClusterShardHealth> iterator() {
        return this.shards.values().iterator();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeVInt(this.numberOfShards);
        out.writeVInt(this.numberOfReplicas);
        out.writeVInt(this.activePrimaryShards);
        out.writeVInt(this.activeShards);
        out.writeVInt(this.relocatingShards);
        out.writeVInt(this.initializingShards);
        out.writeVInt(this.unassignedShards);
        out.writeByte(this.status.value());
        out.writeCollection(this.shards.values());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getIndex());
        builder.field(STATUS, this.getStatus().name().toLowerCase(Locale.ROOT));
        builder.field(NUMBER_OF_SHARDS, this.getNumberOfShards());
        builder.field(NUMBER_OF_REPLICAS, this.getNumberOfReplicas());
        builder.field(ACTIVE_PRIMARY_SHARDS, this.getActivePrimaryShards());
        builder.field(ACTIVE_SHARDS, this.getActiveShards());
        builder.field(RELOCATING_SHARDS, this.getRelocatingShards());
        builder.field(INITIALIZING_SHARDS, this.getInitializingShards());
        builder.field(UNASSIGNED_SHARDS, this.getUnassignedShards());
        if (SHARDS.equals(params.param("level", "indices"))) {
            builder.startObject(SHARDS);
            for (ClusterShardHealth shardHealth : this.shards.values()) {
                shardHealth.toXContent(builder, params);
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static ClusterIndexHealth innerFromXContent(XContentParser parser, String index) {
        return (ClusterIndexHealth)PARSER.apply(parser, (Object)index);
    }

    public static ClusterIndexHealth fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)parser);
        String index = parser.currentName();
        ClusterIndexHealth parsed = ClusterIndexHealth.innerFromXContent(parser, index);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        return parsed;
    }

    public String toString() {
        return "ClusterIndexHealth{index='" + this.index + "', numberOfShards=" + this.numberOfShards + ", numberOfReplicas=" + this.numberOfReplicas + ", activeShards=" + this.activeShards + ", relocatingShards=" + this.relocatingShards + ", initializingShards=" + this.initializingShards + ", unassignedShards=" + this.unassignedShards + ", activePrimaryShards=" + this.activePrimaryShards + ", status=" + String.valueOf((Object)this.status) + ", shards.size=" + String.valueOf(this.shards == null ? "null" : Integer.valueOf(this.shards.size())) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterIndexHealth that = (ClusterIndexHealth)o;
        return Objects.equals(this.index, that.index) && this.numberOfShards == that.numberOfShards && this.numberOfReplicas == that.numberOfReplicas && this.activeShards == that.activeShards && this.relocatingShards == that.relocatingShards && this.initializingShards == that.initializingShards && this.unassignedShards == that.unassignedShards && this.activePrimaryShards == that.activePrimaryShards && this.status == that.status && Objects.equals(this.shards, that.shards);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.index, this.numberOfShards, this.numberOfReplicas, this.activeShards, this.relocatingShards, this.initializingShards, this.unassignedShards, this.activePrimaryShards, this.status, this.shards});
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(NUMBER_OF_SHARDS, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(NUMBER_OF_REPLICAS, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(ACTIVE_SHARDS, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(RELOCATING_SHARDS, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(INITIALIZING_SHARDS, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(UNASSIGNED_SHARDS, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(ACTIVE_PRIMARY_SHARDS, new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(STATUS, new String[0]));
        PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), SHARD_PARSER, new ParseField(SHARDS, new String[0]));
    }
}

