/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.blobstore.transfer.stream;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.opensearch.common.blobstore.transfer.stream.OffsetRangeInputStream;

public class OffsetRangeFileInputStream
extends OffsetRangeInputStream {
    private final InputStream inputStream;
    private final FileChannel fileChannel;
    private final long actualSizeToRead;
    private final long limit;
    private long counter = 0L;
    private long markPointer;
    private long markCounter;

    public OffsetRangeFileInputStream(Path path, long size, long position) throws IOException {
        this.fileChannel = FileChannel.open(path, StandardOpenOption.READ);
        this.fileChannel.position(position);
        this.inputStream = Channels.newInputStream(this.fileChannel);
        long totalLength = this.fileChannel.size();
        this.counter = 0L;
        this.limit = size;
        this.actualSizeToRead = totalLength - position > this.limit ? this.limit : totalLength - position;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.fileChannel.position() >= this.fileChannel.size()) {
            return -1;
        }
        if (this.fileChannel.position() + (long)len > this.fileChannel.size()) {
            len = (int)(this.fileChannel.size() - this.fileChannel.position());
        }
        if (this.counter + (long)len > this.limit) {
            len = (int)(this.limit - this.counter);
        }
        if (len <= 0) {
            return -1;
        }
        this.inputStream.read(b, off, len);
        this.counter += (long)len;
        return len;
    }

    @Override
    public int read() throws IOException {
        if (this.counter++ >= this.limit) {
            return -1;
        }
        return this.fileChannel.position() < this.fileChannel.size() ? this.inputStream.read() & 0xFF : -1;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.markPointer = this.fileChannel.position();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.markCounter = this.counter;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.fileChannel.position(this.markPointer);
        this.counter = this.markCounter;
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.fileChannel.position();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

