/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.profile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.search.Query;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.search.internal.ContextIndexSearcher;
import org.opensearch.search.profile.ProfileMetric;
import org.opensearch.search.profile.aggregation.AggregationProfiler;
import org.opensearch.search.profile.aggregation.ConcurrentAggregationProfiler;
import org.opensearch.search.profile.fetch.FetchProfiler;
import org.opensearch.search.profile.query.ConcurrentQueryProfileTree;
import org.opensearch.search.profile.query.ConcurrentQueryProfiler;
import org.opensearch.search.profile.query.InternalQueryProfileTree;
import org.opensearch.search.profile.query.QueryProfiler;

@PublicApi(since="1.0.0")
public final class Profilers {
    private final ContextIndexSearcher searcher;
    private final List<QueryProfiler> queryProfilers;
    private final AggregationProfiler aggProfiler;
    private final FetchProfiler fetchProfiler;
    private final boolean isConcurrentSegmentSearchEnabled;
    private final Function<Query, Collection<Supplier<ProfileMetric>>> customPluginMetrics;

    public Profilers(ContextIndexSearcher searcher, boolean isConcurrentSegmentSearchEnabled) {
        this(searcher, isConcurrentSegmentSearchEnabled, query -> Collections.emptyList());
    }

    public Profilers(ContextIndexSearcher searcher, boolean isConcurrentSegmentSearchEnabled, Function<Query, Collection<Supplier<ProfileMetric>>> customPluginMetrics) {
        this.searcher = searcher;
        this.isConcurrentSegmentSearchEnabled = isConcurrentSegmentSearchEnabled;
        this.queryProfilers = new ArrayList<QueryProfiler>();
        this.aggProfiler = isConcurrentSegmentSearchEnabled ? new ConcurrentAggregationProfiler() : new AggregationProfiler();
        this.fetchProfiler = new FetchProfiler();
        this.customPluginMetrics = customPluginMetrics;
        this.addQueryProfiler();
    }

    public QueryProfiler addQueryProfiler() {
        QueryProfiler profiler = this.isConcurrentSegmentSearchEnabled ? new ConcurrentQueryProfiler(new ConcurrentQueryProfileTree(this.customPluginMetrics), this.customPluginMetrics) : new QueryProfiler(new InternalQueryProfileTree(this.customPluginMetrics));
        this.searcher.setProfiler(profiler);
        this.queryProfilers.add(profiler);
        return profiler;
    }

    public QueryProfiler getCurrentQueryProfiler() {
        return this.queryProfilers.getLast();
    }

    public List<QueryProfiler> getQueryProfilers() {
        return Collections.unmodifiableList(this.queryProfilers);
    }

    public AggregationProfiler getAggregationProfiler() {
        return this.aggProfiler;
    }

    public FetchProfiler getFetchProfiler() {
        return this.fetchProfiler;
    }
}

