/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.query;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.lucene.search.Query;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.query.QueryCollectorArguments;
import org.opensearch.search.query.QueryCollectorContextSpec;
import org.opensearch.search.query.QueryCollectorContextSpecFactory;

public final class QueryCollectorContextSpecRegistry {
    private static final List<QueryCollectorContextSpecFactory> registry = new CopyOnWriteArrayList<QueryCollectorContextSpecFactory>();

    private QueryCollectorContextSpecRegistry() {
    }

    public static List<QueryCollectorContextSpecFactory> getCollectorContextSpecFactories() {
        return registry;
    }

    public static void registerFactory(QueryCollectorContextSpecFactory factory) {
        registry.add(factory);
    }

    public static Optional<QueryCollectorContextSpec> getQueryCollectorContextSpec(SearchContext searchContext, Query query, QueryCollectorArguments queryCollectorArguments) throws IOException {
        for (QueryCollectorContextSpecFactory factory : registry) {
            Optional<QueryCollectorContextSpec> spec = factory.createQueryCollectorContextSpec(searchContext, query, queryCollectorArguments);
            if (spec.isEmpty()) continue;
            return spec;
        }
        return Optional.empty();
    }
}

