/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.response.search;

import java.io.IOException;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.protobufs.HitsMetadata;
import org.opensearch.protobufs.SearchResponse;
import org.opensearch.transport.grpc.proto.response.search.SearchHitsProtoUtils;

public class SearchResponseSectionsProtoUtils {
    private SearchResponseSectionsProtoUtils() {
    }

    protected static void toProto(SearchResponse.Builder builder, SearchResponse response) throws IOException {
        HitsMetadata.Builder hitsBuilder = HitsMetadata.newBuilder();
        SearchHitsProtoUtils.toProto(response.getHits(), hitsBuilder);
        builder.setHits(hitsBuilder.build());
        SearchResponseSectionsProtoUtils.checkUnsupportedFeatures(response);
    }

    private static void checkUnsupportedFeatures(SearchResponse response) {
        if (response.getAggregations() != null) {
            throw new UnsupportedOperationException("aggregation responses are not supported yet");
        }
        if (response.getSuggest() != null) {
            throw new UnsupportedOperationException("suggest responses are not supported yet");
        }
        if (response.getProfileResults() != null && !response.getProfileResults().isEmpty()) {
            throw new UnsupportedOperationException("profile results are not supported yet");
        }
        if (response.getInternalResponse().getSearchExtBuilders() != null && !response.getInternalResponse().getSearchExtBuilders().isEmpty()) {
            throw new UnsupportedOperationException("ext builder responses are not supported yet");
        }
    }
}

