/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.transport;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.ValidationException;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.forecast.indices.ForecastIndexManagement;
import org.opensearch.forecast.model.Forecaster;
import org.opensearch.forecast.settings.ForecastSettings;
import org.opensearch.forecast.transport.ForecastSuggestName;
import org.opensearch.forecast.transport.SuggestForecasterParamAction;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.Name;
import org.opensearch.timeseries.constant.CommonMessages;
import org.opensearch.timeseries.feature.SearchFeatureDao;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.IntervalTimeConfiguration;
import org.opensearch.timeseries.transport.BaseSuggestConfigParamTransportAction;
import org.opensearch.timeseries.transport.SuggestConfigParamRequest;
import org.opensearch.timeseries.transport.SuggestConfigParamResponse;
import org.opensearch.timeseries.util.MultiResponsesDelegateActionListener;
import org.opensearch.timeseries.util.SecurityClientUtil;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class SuggestForecasterParamTransportAction
extends BaseSuggestConfigParamTransportAction {
    public static final Logger logger = LogManager.getLogger(SuggestForecasterParamTransportAction.class);

    @Inject
    public SuggestForecasterParamTransportAction(Client client, SecurityClientUtil clientUtil, ClusterService clusterService, Settings settings, ForecastIndexManagement anomalyDetectionIndices, ActionFilters actionFilters, TransportService transportService, SearchFeatureDao searchFeatureDao) {
        super(SuggestForecasterParamAction.NAME, client, clientUtil, clusterService, settings, actionFilters, transportService, ForecastSettings.FORECAST_FILTER_BY_BACKEND_ROLES, AnalysisType.FORECAST, searchFeatureDao, Name.getListStrs(Arrays.asList(ForecastSuggestName.values())));
    }

    @Override
    public void suggestExecute(SuggestConfigParamRequest request, User user, ThreadContext.StoredContext storedContext, ActionListener<SuggestConfigParamResponse> listener) {
        storedContext.restore();
        Set<? extends Name> params = this.getParametersToSuggest(request.getParam());
        if (params.isEmpty()) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationError("The given suggest type doesn't exist");
            listener.onFailure((Exception)validationException);
            return;
        }
        Config config = request.getConfig();
        int responseSize = params.size();
        if (params.contains(ForecastSuggestName.HISTORY) && params.contains(ForecastSuggestName.INTERVAL)) {
            --responseSize;
        }
        MultiResponsesDelegateActionListener<SuggestConfigParamResponse> delegateListener = new MultiResponsesDelegateActionListener<SuggestConfigParamResponse>(listener, responseSize, CommonMessages.FAIL_SUGGEST_ERR_MSG, false);
        if (params.contains(ForecastSuggestName.HISTORY)) {
            this.suggestHistory(request.getConfig(), user, request.getRequestTimeout(), params.contains(ForecastSuggestName.INTERVAL), delegateListener);
        } else if (params.contains(ForecastSuggestName.INTERVAL)) {
            this.suggestInterval(request.getConfig(), user, request.getRequestTimeout(), (ActionListener<Pair<IntervalTimeConfiguration, Map<String, Object>>>)ActionListener.wrap(intervalEntity -> delegateListener.onResponse(new SuggestConfigParamResponse.Builder().interval((IntervalTimeConfiguration)intervalEntity.getLeft()).build()), delegateListener::onFailure));
        }
        if (params.contains(ForecastSuggestName.HORIZON)) {
            Forecaster forecaster = (Forecaster)config;
            delegateListener.onResponse(new SuggestConfigParamResponse.Builder().horizon(forecaster.suggestHorizon()).build());
        }
        if (params.contains(ForecastSuggestName.WINDOW_DELAY)) {
            this.suggestWindowDelay(request.getConfig(), user, request.getRequestTimeout(), delegateListener);
        }
    }

    @Override
    protected Set<? extends Name> getParametersToSuggest(String typesStr) {
        HashSet<String> typesInRequest = new HashSet<String>(Arrays.asList(typesStr.split(",")));
        return ForecastSuggestName.getNames((Collection<String>)Sets.intersection((Set)this.allSuggestParamStrs, typesInRequest));
    }
}

