/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.task.shard;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.Version;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.persistent.PersistentTaskParams;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0002\"#B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0016J\b\u0010\u0018\u001a\u00020\u0003H\u0016J\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000e\u00a8\u0006$"}, d2={"Lorg/opensearch/replication/task/shard/ShardReplicationParams;", "Lorg/opensearch/persistent/PersistentTaskParams;", "leaderAlias", "", "leaderShardId", "Lorg/opensearch/core/index/shard/ShardId;", "followerShardId", "(Ljava/lang/String;Lorg/opensearch/core/index/shard/ShardId;Lorg/opensearch/core/index/shard/ShardId;)V", "inp", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getFollowerShardId", "()Lorg/opensearch/core/index/shard/ShardId;", "setFollowerShardId", "(Lorg/opensearch/core/index/shard/ShardId;)V", "getLeaderAlias", "()Ljava/lang/String;", "setLeaderAlias", "(Ljava/lang/String;)V", "getLeaderShardId", "setLeaderShardId", "getMinimalSupportedVersion", "Lorg/opensearch/Version;", "getWriteableName", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Builder", "Companion", "opensearch-cross-cluster-replication"})
public final class ShardReplicationParams
implements PersistentTaskParams {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String leaderAlias;
    @NotNull
    private ShardId leaderShardId;
    @NotNull
    private ShardId followerShardId;
    @NotNull
    public static final String NAME = "cluster:indices/shards/replication";
    @NotNull
    private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("cluster:indices/shards/replication", true, ShardReplicationParams::PARSER$lambda$0);

    @NotNull
    public final String getLeaderAlias() {
        return this.leaderAlias;
    }

    public final void setLeaderAlias(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.leaderAlias = string;
    }

    @NotNull
    public final ShardId getLeaderShardId() {
        return this.leaderShardId;
    }

    public final void setLeaderShardId(@NotNull ShardId shardId) {
        Intrinsics.checkNotNullParameter((Object)shardId, (String)"<set-?>");
        this.leaderShardId = shardId;
    }

    @NotNull
    public final ShardId getFollowerShardId() {
        return this.followerShardId;
    }

    public final void setFollowerShardId(@NotNull ShardId shardId) {
        Intrinsics.checkNotNullParameter((Object)shardId, (String)"<set-?>");
        this.followerShardId = shardId;
    }

    public ShardReplicationParams(@NotNull String leaderAlias, @NotNull ShardId leaderShardId, @NotNull ShardId followerShardId) {
        Intrinsics.checkNotNullParameter((Object)leaderAlias, (String)"leaderAlias");
        Intrinsics.checkNotNullParameter((Object)leaderShardId, (String)"leaderShardId");
        Intrinsics.checkNotNullParameter((Object)followerShardId, (String)"followerShardId");
        this.leaderAlias = leaderAlias;
        this.leaderShardId = leaderShardId;
        this.followerShardId = followerShardId;
    }

    public ShardReplicationParams(@NotNull StreamInput inp) {
        Intrinsics.checkNotNullParameter((Object)inp, (String)"inp");
        String string = inp.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        this(string, new ShardId(inp), new ShardId(inp));
    }

    @NotNull
    public String getWriteableName() {
        return NAME;
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @Nullable ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        XContentBuilder xContentBuilder = builder.startObject().field("leader_alias", this.leaderAlias).field("leader_shard", (ToXContent)this.leaderShardId).field("leader_index_uuid", this.leaderShardId.getIndex().getUUID()).field("follower_shard", (ToXContent)this.followerShardId).field("follower_index_uuid", this.followerShardId.getIndex().getUUID()).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"endObject(...)");
        return xContentBuilder;
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.leaderAlias);
        this.leaderShardId.writeTo(out);
        this.followerShardId.writeTo(out);
    }

    @NotNull
    public Version getMinimalSupportedVersion() {
        Version version = Version.V_2_0_0;
        Intrinsics.checkNotNullExpressionValue((Object)version, (String)"V_2_0_0");
        return version;
    }

    @NotNull
    public String toString() {
        String string = Strings.toString((MediaType)((MediaType)XContentType.JSON), (ToXContent)((ToXContent)this));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final Builder PARSER$lambda$0() {
        return new Builder();
    }

    static {
        PARSER.declareString(Builder::leaderAlias, new ParseField("leader_alias", new String[0]));
        PARSER.declareString(Builder::leaderShardId, new ParseField("leader_shard", new String[0]));
        PARSER.declareString(Builder::leaderIndexUUID, new ParseField("leader_index_uuid", new String[0]));
        PARSER.declareString(Builder::followerShardId, new ParseField("follower_shard", new String[0]));
        PARSER.declareString(Builder::followerIndexUUID, new ParseField("follower_index_uuid", new String[0]));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0003\u001a\u00020\u00172\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\t\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0004J\u000e\u0010\u0012\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\b\u00a8\u0006\u0018"}, d2={"Lorg/opensearch/replication/task/shard/ShardReplicationParams$Builder;", "", "()V", "followerIndexUUID", "", "getFollowerIndexUUID", "()Ljava/lang/String;", "setFollowerIndexUUID", "(Ljava/lang/String;)V", "followerShardId", "getFollowerShardId", "setFollowerShardId", "leaderAlias", "getLeaderAlias", "setLeaderAlias", "leaderIndexUUID", "getLeaderIndexUUID", "setLeaderIndexUUID", "leaderShardId", "getLeaderShardId", "setLeaderShardId", "build", "Lorg/opensearch/replication/task/shard/ShardReplicationParams;", "", "opensearch-cross-cluster-replication"})
    public static final class Builder {
        public String leaderAlias;
        public String leaderShardId;
        public String leaderIndexUUID;
        public String followerShardId;
        public String followerIndexUUID;

        @NotNull
        public final String getLeaderAlias() {
            String string = this.leaderAlias;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"leaderAlias");
            return null;
        }

        public final void setLeaderAlias(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.leaderAlias = string;
        }

        @NotNull
        public final String getLeaderShardId() {
            String string = this.leaderShardId;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"leaderShardId");
            return null;
        }

        public final void setLeaderShardId(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.leaderShardId = string;
        }

        @NotNull
        public final String getLeaderIndexUUID() {
            String string = this.leaderIndexUUID;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"leaderIndexUUID");
            return null;
        }

        public final void setLeaderIndexUUID(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.leaderIndexUUID = string;
        }

        @NotNull
        public final String getFollowerShardId() {
            String string = this.followerShardId;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"followerShardId");
            return null;
        }

        public final void setFollowerShardId(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.followerShardId = string;
        }

        @NotNull
        public final String getFollowerIndexUUID() {
            String string = this.followerIndexUUID;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"followerIndexUUID");
            return null;
        }

        public final void setFollowerIndexUUID(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.followerIndexUUID = string;
        }

        public final void leaderAlias(@NotNull String leaderAlias) {
            Intrinsics.checkNotNullParameter((Object)leaderAlias, (String)"leaderAlias");
            this.setLeaderAlias(leaderAlias);
        }

        public final void leaderShardId(@NotNull String leaderShardId) {
            Intrinsics.checkNotNullParameter((Object)leaderShardId, (String)"leaderShardId");
            this.setLeaderShardId(leaderShardId);
        }

        public final void leaderIndexUUID(@NotNull String leaderIndexUUID) {
            Intrinsics.checkNotNullParameter((Object)leaderIndexUUID, (String)"leaderIndexUUID");
            this.setLeaderIndexUUID(leaderIndexUUID);
        }

        public final void followerShardId(@NotNull String followerShardId) {
            Intrinsics.checkNotNullParameter((Object)followerShardId, (String)"followerShardId");
            this.setFollowerShardId(followerShardId);
        }

        public final void followerIndexUUID(@NotNull String followerIndexUUID) {
            Intrinsics.checkNotNullParameter((Object)followerIndexUUID, (String)"followerIndexUUID");
            this.setFollowerIndexUUID(followerIndexUUID);
        }

        @NotNull
        public final ShardReplicationParams build() {
            ShardId leaderShardIdObj = ShardId.fromString((String)this.getLeaderShardId());
            ShardId followerShardIdObj = ShardId.fromString((String)this.getFollowerShardId());
            return new ShardReplicationParams(this.getLeaderAlias(), new ShardId(new Index(leaderShardIdObj.getIndexName(), this.getLeaderIndexUUID()), leaderShardIdObj.getId()), new ShardId(new Index(followerShardIdObj.getIndexName(), this.getFollowerIndexUUID()), followerShardIdObj.getId()));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/opensearch/replication/task/shard/ShardReplicationParams$Companion;", "", "()V", "NAME", "", "PARSER", "Lorg/opensearch/core/xcontent/ObjectParser;", "Lorg/opensearch/replication/task/shard/ShardReplicationParams$Builder;", "Ljava/lang/Void;", "fromXContent", "Lorg/opensearch/replication/task/shard/ShardReplicationParams;", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ShardReplicationParams fromXContent(@NotNull XContentParser parser) throws IOException {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            return ((Builder)PARSER.parse(parser, null)).build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

