"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiForm", {
  enumerable: true,
  get: function get() {
    return _form.EuiForm;
  }
});
exports.OuiForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _call_out = require("../call_out");
var _i18n = require("../i18n");
var _form = require("../../eui_components/form/form");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) { "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); } return f; })(e, t); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ /*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var OuiForm = function OuiForm(_ref) {
  var children = _ref.children,
    className = _ref.className,
    isInvalid = _ref.isInvalid,
    error = _ref.error,
    _ref$component = _ref.component,
    component = _ref$component === void 0 ? 'div' : _ref$component,
    _ref$invalidCallout = _ref.invalidCallout,
    invalidCallout = _ref$invalidCallout === void 0 ? 'above' : _ref$invalidCallout,
    rest = _objectWithoutProperties(_ref, ["children", "className", "isInvalid", "error", "component", "invalidCallout"]);
  var handleFocus = (0, _react.useCallback)(function (node) {
    node === null || node === void 0 ? void 0 : node.focus();
  }, []);
  var classes = (0, _classnames.default)('ouiForm', className);
  var optionalErrors = null;
  if (error) {
    var errorTexts = Array.isArray(error) ? error : [error];
    optionalErrors = /*#__PURE__*/_react.default.createElement("ul", null, errorTexts.map(function (error, index) {
      return /*#__PURE__*/_react.default.createElement("li", {
        className: "ouiForm__error",
        key: index
      }, error);
    }));
  }
  var optionalErrorAlert;
  if (isInvalid && invalidCallout === 'above') {
    optionalErrorAlert = /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
      token: "ouiForm.addressFormErrors",
      default: "Please address the highlighted errors."
    }, function (addressFormErrors) {
      return /*#__PURE__*/_react.default.createElement(_call_out.OuiCallOut, {
        tabIndex: -1,
        ref: handleFocus,
        className: "ouiForm__errors",
        title: addressFormErrors,
        color: "danger",
        role: "alert",
        "aria-live": "assertive"
      }, optionalErrors);
    });
  }
  var Element = component;
  return /*#__PURE__*/_react.default.createElement(Element, _extends({
    className: classes
  }, rest), optionalErrorAlert, children);
};

/* OUI -> EUI Aliases: Build-Time */
exports.OuiForm = OuiForm;
OuiForm.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  /**
       * Which HTML element to render `div` or `form`
       */
  component: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.oneOf(["form"]).isRequired, _propTypes.default.oneOf(["div"])]), _propTypes.default.oneOf(["form", "div"])]),
  isInvalid: _propTypes.default.bool,
  error: _propTypes.default.oneOfType([_propTypes.default.node.isRequired, _propTypes.default.arrayOf(_propTypes.default.node.isRequired).isRequired]),
  /**
       * Where to display the callout with the list of errors
       */
  invalidCallout: _propTypes.default.oneOf(["above", "none"])
};
/* OUI -> EUI Aliases: Build-Time */