"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiFilterSelectItem", {
  enumerable: true,
  get: function get() {
    return _filter_select_item.EuiFilterSelectItem;
  }
});
exports.OuiFilterSelectItem = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _flex = require("../flex");
var _icon = require("../icon");
var _filter_select_item = require("../../eui_components/filter_group/filter_select_item");
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) { "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); } return f; })(e, t); }
function _createSuper(t) { var r = _isNativeReflectConstruct(); return function () { var e, o = (0, _getPrototypeOf2.default)(t); if (r) { var s = (0, _getPrototypeOf2.default)(this).constructor; e = Reflect.construct(o, arguments, s); } else e = o.apply(this, arguments); return (0, _possibleConstructorReturn2.default)(this, e); }; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ /*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var resolveIconAndColor = function resolveIconAndColor(checked) {
  if (!checked) {
    return {
      icon: 'empty'
    };
  }
  return checked === 'on' ? {
    icon: 'check',
    color: 'text'
  } : {
    icon: 'cross',
    color: 'text'
  };
};
var OuiFilterSelectItem = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(OuiFilterSelectItem, _Component);
  var _super = _createSuper(OuiFilterSelectItem);
  function OuiFilterSelectItem() {
    var _this;
    (0, _classCallCheck2.default)(this, OuiFilterSelectItem);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "buttonRef", null);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      hasFocus: false
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "focus", function () {
      if (_this.buttonRef) {
        _this.buttonRef.focus();
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "hasFocus", function () {
      return _this.state.hasFocus;
    });
    return _this;
  }
  (0, _createClass2.default)(OuiFilterSelectItem, [{
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props = this.props,
        children = _this$props.children,
        className = _this$props.className,
        disabled = _this$props.disabled,
        checked = _this$props.checked,
        isFocused = _this$props.isFocused,
        showIcons = _this$props.showIcons,
        rest = (0, _objectWithoutProperties2.default)(_this$props, ["children", "className", "disabled", "checked", "isFocused", "showIcons"]);
      var classes = (0, _classnames.default)('ouiFilterSelectItem', {
        'ouiFilterSelectItem-isFocused': isFocused
      }, className);
      var iconNode;
      if (showIcons) {
        var _resolveIconAndColor = resolveIconAndColor(checked),
          icon = _resolveIconAndColor.icon,
          color = _resolveIconAndColor.color;
        iconNode = /*#__PURE__*/_react.default.createElement(_flex.OuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_icon.OuiIcon, {
          color: color,
          type: icon
        }));
      }
      return /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({
        ref: function ref(_ref) {
          return _this2.buttonRef = _ref;
        },
        role: "option",
        type: "button",
        "aria-selected": isFocused,
        className: classes,
        disabled: disabled,
        "aria-disabled": disabled
      }, rest), /*#__PURE__*/_react.default.createElement(_flex.OuiFlexGroup, {
        alignItems: "center",
        gutterSize: "s",
        component: "span",
        responsive: false
      }, iconNode, /*#__PURE__*/_react.default.createElement(_flex.OuiFlexItem, {
        className: "ouiFilterSelectItem__content",
        component: "span"
      }, children)));
    }
  }]);
  return OuiFilterSelectItem;
}(_react.Component);
/* OUI -> EUI Aliases: Build-Time */
exports.OuiFilterSelectItem = OuiFilterSelectItem;
(0, _defineProperty2.default)(OuiFilterSelectItem, "defaultProps", {
  showIcons: true
});
OuiFilterSelectItem.propTypes = {
  checked: _propTypes.default.oneOf(["on", "off"]),
  showIcons: _propTypes.default.bool,
  isFocused: _propTypes.default.bool,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};
/* OUI -> EUI Aliases: Build-Time */