"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiMutationObserver", {
  enumerable: true,
  get: function get() {
    return _mutation_observer.EuiMutationObserver;
  }
});
exports.useMutationObserver = exports.OuiMutationObserver = void 0;
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = require("react");
var _observer = require("../observer");
var _mutation_observer = require("../../../eui_components/observer/mutation_observer/mutation_observer");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _createSuper(t) { var r = _isNativeReflectConstruct(); return function () { var e, o = (0, _getPrototypeOf2.default)(t); if (r) { var s = (0, _getPrototypeOf2.default)(this).constructor; e = Reflect.construct(o, arguments, s); } else e = o.apply(this, arguments); return (0, _possibleConstructorReturn2.default)(this, e); }; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ /*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var OuiMutationObserver = /*#__PURE__*/function (_OuiObserver) {
  (0, _inherits2.default)(OuiMutationObserver, _OuiObserver);
  var _super = _createSuper(OuiMutationObserver);
  function OuiMutationObserver() {
    var _this;
    (0, _classCallCheck2.default)(this, OuiMutationObserver);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "name", 'OuiMutationObserver');
    // the `onMutation` prop may change while the observer is bound, abstracting
    // it out into a separate function means the current `onMutation` value is used
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onMutation", function (records, observer) {
      _this.props.onMutation(records, observer);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "beginObserve", function () {
      var childNode = _this.childNode;
      _this.observer = makeMutationObserver(childNode, _this.props.observerOptions, _this.onMutation);
    });
    return _this;
  }
  return OuiMutationObserver;
}(_observer.OuiObserver);
exports.OuiMutationObserver = OuiMutationObserver;
var makeMutationObserver = function makeMutationObserver(node, _observerOptions, callback) {
  // IE11 and the MutationObserver polyfill used in Kibana (for Jest) implement
  // an older spec in which specifying `attributeOldValue` or `attributeFilter`
  // without specifying `attributes` results in a `SyntaxError`.
  // The following logic patches the newer spec in which `attributes: true` can be
  // implied when appropriate (`attributeOldValue` or `attributeFilter` is specified).
  var observerOptions = _objectSpread({}, _observerOptions);
  var needsAttributes = observerOptions.hasOwnProperty('attributeOldValue') || observerOptions.hasOwnProperty('attributeFilter');
  if (needsAttributes && !observerOptions.hasOwnProperty('attributes')) {
    observerOptions.attributes = true;
  }
  var observer = new MutationObserver(callback);
  observer.observe(node, observerOptions);
  return observer;
};
var useMutationObserver = function useMutationObserver(container, callback, observerOptions) {
  (0, _react.useEffect)(function () {
    if (container != null) {
      var observer = makeMutationObserver(container, observerOptions, callback);
      return function () {
        return observer.disconnect();
      };
    }
  },
  // ignore changing observerOptions
  // eslint-disable-next-line
  [container, callback]);
};

/* OUI -> EUI Aliases: Build-Time */
/* OUI -> EUI Aliases: Build-Time */
exports.useMutationObserver = useMutationObserver;