"use strict";

var _react = require("@testing-library/react");
var _util = require("util");
require("@testing-library/jest-dom");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

(0, _react.configure)({
  testIdAttribute: 'data-test-subj'
});

// https://github.com/inrupt/solid-client-authn-js/issues/1676#issuecomment-917016646
global.TextEncoder = _util.TextEncoder;
global.TextDecoder = _util.TextDecoder;
window.URL.createObjectURL = () => '';
HTMLCanvasElement.prototype.getContext = () => '';
Element.prototype.scrollIntoView = jest.fn();
window.IntersectionObserver = class IntersectionObserver {
  constructor() {}
  disconnect() {
    return null;
  }
  observe() {
    return null;
  }
  takeRecords() {
    return null;
  }
  unobserve() {
    return null;
  }
};
jest.mock('@elastic/eui/lib/components/form/form_row/make_id', () => () => 'random-id');
jest.mock('@elastic/eui/lib/services/accessibility/html_id_generator', () => ({
  htmlIdGenerator: () => {
    return () => 'random_html_id';
  }
}));
jest.setTimeout(30000);