"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.statsRoute = statsRoute;
var _common = require("../../common");
var _stats_helper = require("../common/stats/stats_helper");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function statsRoute(router, logger) {
  router.get({
    path: `${_common.APP_API}${_common.APP_PATH.STATS}`,
    validate: {}
  }, async (context, request, response) => {
    try {
      const savedObjectsClient = context.core.savedObjects.client;
      const mapsSavedObjects = await (0, _stats_helper.getMapSavedObjects)(savedObjectsClient, _common.PER_PAGE_REQUEST_NUMBER);
      const stats = (0, _stats_helper.getStats)(mapsSavedObjects);
      return response.ok({
        body: stats
      });
    } catch (error) {
      logger.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29tbW9uIiwicmVxdWlyZSIsIl9zdGF0c19oZWxwZXIiLCJzdGF0c1JvdXRlIiwicm91dGVyIiwibG9nZ2VyIiwiZ2V0IiwicGF0aCIsIkFQUF9BUEkiLCJBUFBfUEFUSCIsIlNUQVRTIiwidmFsaWRhdGUiLCJjb250ZXh0IiwicmVxdWVzdCIsInJlc3BvbnNlIiwic2F2ZWRPYmplY3RzQ2xpZW50IiwiY29yZSIsInNhdmVkT2JqZWN0cyIsImNsaWVudCIsIm1hcHNTYXZlZE9iamVjdHMiLCJnZXRNYXBTYXZlZE9iamVjdHMiLCJQRVJfUEFHRV9SRVFVRVNUX05VTUJFUiIsInN0YXRzIiwiZ2V0U3RhdHMiLCJvayIsImJvZHkiLCJlcnJvciIsImN1c3RvbSIsInN0YXR1c0NvZGUiLCJtZXNzYWdlIl0sInNvdXJjZXMiOlsic3RhdHNfcm91dGVyLnRzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qXG4gKiBDb3B5cmlnaHQgT3BlblNlYXJjaCBDb250cmlidXRvcnNcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4gKi9cblxuaW1wb3J0IHsgUmVzcG9uc2VFcnJvciB9IGZyb20gJ0BvcGVuc2VhcmNoLXByb2plY3Qvb3BlbnNlYXJjaC9saWIvZXJyb3JzJztcbmltcG9ydCB7IExvZ2dlciB9IGZyb20gJ0Bvc2QvbG9nZ2luZyc7XG5pbXBvcnQge1xuICBJT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZSxcbiAgSVJvdXRlcixcbiAgU2F2ZWRPYmplY3RzRmluZFJlc3BvbnNlLFxufSBmcm9tICcuLi8uLi8uLi8uLi9zcmMvY29yZS9zZXJ2ZXInO1xuaW1wb3J0IHsgQVBQX0FQSSwgQVBQX1BBVEgsIFBFUl9QQUdFX1JFUVVFU1RfTlVNQkVSIH0gZnJvbSAnLi4vLi4vY29tbW9uJztcbmltcG9ydCB7IGdldE1hcFNhdmVkT2JqZWN0cywgZ2V0U3RhdHMgfSBmcm9tICcuLi9jb21tb24vc3RhdHMvc3RhdHNfaGVscGVyJztcbmltcG9ydCB7IE1hcFNhdmVkT2JqZWN0QXR0cmlidXRlcyB9IGZyb20gJy4uLy4uL2NvbW1vbi9tYXBfc2F2ZWRfb2JqZWN0X2F0dHJpYnV0ZXMnO1xuXG5leHBvcnQgZnVuY3Rpb24gc3RhdHNSb3V0ZShyb3V0ZXI6IElSb3V0ZXIsIGxvZ2dlcjogTG9nZ2VyKSB7XG4gIHJvdXRlci5nZXQoXG4gICAge1xuICAgICAgcGF0aDogYCR7QVBQX0FQSX0ke0FQUF9QQVRILlNUQVRTfWAsXG4gICAgICB2YWxpZGF0ZToge30sXG4gICAgfSxcbiAgICBhc3luYyAoXG4gICAgICBjb250ZXh0LFxuICAgICAgcmVxdWVzdCxcbiAgICAgIHJlc3BvbnNlXG4gICAgKTogUHJvbWlzZTxJT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZTxhbnkgfCBSZXNwb25zZUVycm9yPj4gPT4ge1xuICAgICAgdHJ5IHtcbiAgICAgICAgY29uc3Qgc2F2ZWRPYmplY3RzQ2xpZW50ID0gY29udGV4dC5jb3JlLnNhdmVkT2JqZWN0cy5jbGllbnQ7XG4gICAgICAgIGNvbnN0IG1hcHNTYXZlZE9iamVjdHM6IFNhdmVkT2JqZWN0c0ZpbmRSZXNwb25zZTxNYXBTYXZlZE9iamVjdEF0dHJpYnV0ZXM+ID1cbiAgICAgICAgICBhd2FpdCBnZXRNYXBTYXZlZE9iamVjdHMoc2F2ZWRPYmplY3RzQ2xpZW50LCBQRVJfUEFHRV9SRVFVRVNUX05VTUJFUik7XG4gICAgICAgIGNvbnN0IHN0YXRzID0gZ2V0U3RhdHMobWFwc1NhdmVkT2JqZWN0cyk7XG4gICAgICAgIHJldHVybiByZXNwb25zZS5vayh7XG4gICAgICAgICAgYm9keTogc3RhdHMsXG4gICAgICAgIH0pO1xuICAgICAgfSBjYXRjaCAoZXJyb3IpIHtcbiAgICAgICAgbG9nZ2VyLmVycm9yKGVycm9yKTtcbiAgICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbSh7XG4gICAgICAgICAgc3RhdHVzQ29kZTogZXJyb3Iuc3RhdHVzQ29kZSB8fCA1MDAsXG4gICAgICAgICAgYm9keTogZXJyb3IubWVzc2FnZSxcbiAgICAgICAgfSk7XG4gICAgICB9XG4gICAgfVxuICApO1xufVxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFZQSxJQUFBQSxPQUFBLEdBQUFDLE9BQUE7QUFDQSxJQUFBQyxhQUFBLEdBQUFELE9BQUE7QUFiQTtBQUNBO0FBQ0E7QUFDQTs7QUFhTyxTQUFTRSxVQUFVQSxDQUFDQyxNQUFlLEVBQUVDLE1BQWMsRUFBRTtFQUMxREQsTUFBTSxDQUFDRSxHQUFHLENBQ1I7SUFDRUMsSUFBSSxFQUFHLEdBQUVDLGVBQVEsR0FBRUMsZ0JBQVEsQ0FBQ0MsS0FBTSxFQUFDO0lBQ25DQyxRQUFRLEVBQUUsQ0FBQztFQUNiLENBQUMsRUFDRCxPQUNFQyxPQUFPLEVBQ1BDLE9BQU8sRUFDUEMsUUFBUSxLQUN3RDtJQUNoRSxJQUFJO01BQ0YsTUFBTUMsa0JBQWtCLEdBQUdILE9BQU8sQ0FBQ0ksSUFBSSxDQUFDQyxZQUFZLENBQUNDLE1BQU07TUFDM0QsTUFBTUMsZ0JBQW9FLEdBQ3hFLE1BQU0sSUFBQUMsZ0NBQWtCLEVBQUNMLGtCQUFrQixFQUFFTSwrQkFBdUIsQ0FBQztNQUN2RSxNQUFNQyxLQUFLLEdBQUcsSUFBQUMsc0JBQVEsRUFBQ0osZ0JBQWdCLENBQUM7TUFDeEMsT0FBT0wsUUFBUSxDQUFDVSxFQUFFLENBQUM7UUFDakJDLElBQUksRUFBRUg7TUFDUixDQUFDLENBQUM7SUFDSixDQUFDLENBQUMsT0FBT0ksS0FBSyxFQUFFO01BQ2RyQixNQUFNLENBQUNxQixLQUFLLENBQUNBLEtBQUssQ0FBQztNQUNuQixPQUFPWixRQUFRLENBQUNhLE1BQU0sQ0FBQztRQUNyQkMsVUFBVSxFQUFFRixLQUFLLENBQUNFLFVBQVUsSUFBSSxHQUFHO1FBQ25DSCxJQUFJLEVBQUVDLEtBQUssQ0FBQ0c7TUFDZCxDQUFDLENBQUM7SUFDSjtFQUNGLENBQ0YsQ0FBQztBQUNIIn0=