/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.http;

import java.nio.ByteBuffer;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.http.HttpHeader;
import software.amazon.awssdk.crt.http.HttpRequestBase;
import software.amazon.awssdk.crt.http.HttpRequestBodyStream;
import software.amazon.awssdk.crt.http.HttpVersion;

public class HttpRequest
extends HttpRequestBase {
    public HttpRequest(String method, String encodedPath) {
        this(method, encodedPath, new HttpHeader[0], null);
    }

    public HttpRequest(String method, String encodedPath, HttpHeader[] headers, HttpRequestBodyStream bodyStream) {
        super(headers, bodyStream);
        this.method = method;
        this.encodedPath = encodedPath;
    }

    HttpRequest(ByteBuffer marshalledRequest, HttpRequestBodyStream bodyStream) {
        if (marshalledRequest.remaining() < 12) {
            throw new CrtRuntimeException("Invalid marshalled request object.");
        }
        this.version = HttpVersion.getEnumValueFromInteger(marshalledRequest.getInt());
        int methodLength = marshalledRequest.getInt();
        byte[] methodBlob = new byte[methodLength];
        marshalledRequest.get(methodBlob);
        this.method = new String(methodBlob, UTF8);
        if (marshalledRequest.remaining() < 4) {
            throw new CrtRuntimeException("Invalid marshalled request object.");
        }
        int pathLength = marshalledRequest.getInt();
        byte[] pathBlob = new byte[pathLength];
        marshalledRequest.get(pathBlob);
        this.encodedPath = new String(pathBlob, UTF8);
        this.headers = HttpHeader.loadHeadersListFromMarshalledHeadersBlob(marshalledRequest);
        this.bodyStream = bodyStream;
    }

    public String getMethod() {
        return this.method;
    }

    public String getEncodedPath() {
        return this.encodedPath;
    }

    public void setEncodedPath(String encodedPath) {
        this.encodedPath = encodedPath;
    }
}

