/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.io;

import java.util.HashMap;
import java.util.Map;

public enum TlsHashAlgorithm {
    UNKNOWN(0),
    SHA1(1),
    SHA224(2),
    SHA256(3),
    SHA384(4),
    SHA512(5);

    int nativeValue;
    static Map<Integer, TlsHashAlgorithm> enumMapping;

    static Map<Integer, TlsHashAlgorithm> buildEnumMapping() {
        HashMap<Integer, TlsHashAlgorithm> enumMapping = new HashMap<Integer, TlsHashAlgorithm>();
        for (TlsHashAlgorithm i : TlsHashAlgorithm.values()) {
            enumMapping.put(i.nativeValue, i);
        }
        return enumMapping;
    }

    public static TlsHashAlgorithm getEnumValueFromInteger(int value) {
        TlsHashAlgorithm enumValue = enumMapping.get(value);
        if (enumValue != null) {
            return enumValue;
        }
        throw new RuntimeException("Illegal TlsKeyOperation.TlsHashAlgorithm");
    }

    private TlsHashAlgorithm(int nativeValue) {
        this.nativeValue = nativeValue;
    }

    public int getNativeValue() {
        return this.nativeValue;
    }

    static {
        enumMapping = TlsHashAlgorithm.buildEnumMapping();
    }
}

