/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.compute.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonString;
import com.google.api.client.util.Base64;
import com.google.api.client.util.Data;
import com.google.api.client.util.Key;
import com.google.api.services.compute.model.CustomErrorResponsePolicy;
import com.google.api.services.compute.model.HostRule;
import com.google.api.services.compute.model.HttpHeaderAction;
import com.google.api.services.compute.model.HttpRedirectAction;
import com.google.api.services.compute.model.HttpRouteAction;
import com.google.api.services.compute.model.PathMatcher;
import com.google.api.services.compute.model.UrlMapTest;
import java.math.BigInteger;
import java.util.List;

public final class UrlMap
extends GenericJson {
    @Key
    private String creationTimestamp;
    @Key
    private CustomErrorResponsePolicy defaultCustomErrorResponsePolicy;
    @Key
    private HttpRouteAction defaultRouteAction;
    @Key
    private String defaultService;
    @Key
    private HttpRedirectAction defaultUrlRedirect;
    @Key
    private String description;
    @Key
    private String fingerprint;
    @Key
    private HttpHeaderAction headerAction;
    @Key
    private List<HostRule> hostRules;
    @Key
    @JsonString
    private BigInteger id;
    @Key
    private String kind;
    @Key
    private String name;
    @Key
    private List<PathMatcher> pathMatchers;
    @Key
    private String region;
    @Key
    private String selfLink;
    @Key
    private List<UrlMapTest> tests;

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public UrlMap setCreationTimestamp(String creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
        return this;
    }

    public CustomErrorResponsePolicy getDefaultCustomErrorResponsePolicy() {
        return this.defaultCustomErrorResponsePolicy;
    }

    public UrlMap setDefaultCustomErrorResponsePolicy(CustomErrorResponsePolicy defaultCustomErrorResponsePolicy) {
        this.defaultCustomErrorResponsePolicy = defaultCustomErrorResponsePolicy;
        return this;
    }

    public HttpRouteAction getDefaultRouteAction() {
        return this.defaultRouteAction;
    }

    public UrlMap setDefaultRouteAction(HttpRouteAction defaultRouteAction) {
        this.defaultRouteAction = defaultRouteAction;
        return this;
    }

    public String getDefaultService() {
        return this.defaultService;
    }

    public UrlMap setDefaultService(String defaultService) {
        this.defaultService = defaultService;
        return this;
    }

    public HttpRedirectAction getDefaultUrlRedirect() {
        return this.defaultUrlRedirect;
    }

    public UrlMap setDefaultUrlRedirect(HttpRedirectAction defaultUrlRedirect) {
        this.defaultUrlRedirect = defaultUrlRedirect;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public UrlMap setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public byte[] decodeFingerprint() {
        return Base64.decodeBase64((String)this.fingerprint);
    }

    public UrlMap setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
        return this;
    }

    public UrlMap encodeFingerprint(byte[] fingerprint) {
        this.fingerprint = Base64.encodeBase64URLSafeString((byte[])fingerprint);
        return this;
    }

    public HttpHeaderAction getHeaderAction() {
        return this.headerAction;
    }

    public UrlMap setHeaderAction(HttpHeaderAction headerAction) {
        this.headerAction = headerAction;
        return this;
    }

    public List<HostRule> getHostRules() {
        return this.hostRules;
    }

    public UrlMap setHostRules(List<HostRule> hostRules) {
        this.hostRules = hostRules;
        return this;
    }

    public BigInteger getId() {
        return this.id;
    }

    public UrlMap setId(BigInteger id) {
        this.id = id;
        return this;
    }

    public String getKind() {
        return this.kind;
    }

    public UrlMap setKind(String kind) {
        this.kind = kind;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public UrlMap setName(String name) {
        this.name = name;
        return this;
    }

    public List<PathMatcher> getPathMatchers() {
        return this.pathMatchers;
    }

    public UrlMap setPathMatchers(List<PathMatcher> pathMatchers) {
        this.pathMatchers = pathMatchers;
        return this;
    }

    public String getRegion() {
        return this.region;
    }

    public UrlMap setRegion(String region) {
        this.region = region;
        return this;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public UrlMap setSelfLink(String selfLink) {
        this.selfLink = selfLink;
        return this;
    }

    public List<UrlMapTest> getTests() {
        return this.tests;
    }

    public UrlMap setTests(List<UrlMapTest> tests) {
        this.tests = tests;
        return this;
    }

    public UrlMap set(String fieldName, Object value) {
        return (UrlMap)super.set(fieldName, value);
    }

    public UrlMap clone() {
        return (UrlMap)super.clone();
    }

    static {
        Data.nullOf(HostRule.class);
        Data.nullOf(PathMatcher.class);
    }
}

