/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.transform;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.indices.stats.IndicesStatsAction;
import org.opensearch.action.admin.indices.stats.IndicesStatsRequest;
import org.opensearch.action.admin.indices.stats.IndicesStatsResponse;
import org.opensearch.action.admin.indices.stats.ShardStats;
import org.opensearch.action.bulk.BackoffPolicy;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.TransportSearchAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.ExistsQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.index.seqno.SeqNoStats;
import org.opensearch.indexmanagement.common.model.dimension.Dimension;
import org.opensearch.indexmanagement.transform.TransformSearchService;
import org.opensearch.indexmanagement.transform.exceptions.TransformSearchServiceException;
import org.opensearch.indexmanagement.transform.model.BucketSearchResult;
import org.opensearch.indexmanagement.transform.model.ShardNewDocuments;
import org.opensearch.indexmanagement.transform.model.Transform;
import org.opensearch.indexmanagement.transform.model.TransformSearchResult;
import org.opensearch.indexmanagement.transform.model.TransformStats;
import org.opensearch.indexmanagement.transform.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.transform.settings.TransformSettings;
import org.opensearch.indexmanagement.transform.util.TransformContext;
import org.opensearch.indexmanagement.util.IndexUtils;
import org.opensearch.search.aggregations.AbstractAggregationBuilder;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.opensearch.search.aggregations.metrics.InternalAvg;
import org.opensearch.search.aggregations.metrics.InternalMax;
import org.opensearch.search.aggregations.metrics.InternalMin;
import org.opensearch.search.aggregations.metrics.InternalSum;
import org.opensearch.search.aggregations.metrics.InternalValueCount;
import org.opensearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.opensearch.search.aggregations.metrics.Percentile;
import org.opensearch.search.aggregations.metrics.Percentiles;
import org.opensearch.search.aggregations.metrics.ScriptedMetric;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.transport.RemoteTransportException;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0005\u0018\u0000 /2\u00020\u0001:\u0001/B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\"\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0086@\u00a2\u0006\u0002\u0010\u001bJ<\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00162\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0086@\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002JT\u0010(\u001a\u00020)2\u0006\u0010\u001e\u001a\u00020\u001f2\u0016\b\u0002\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00162\u001c\b\u0002\u0010*\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00010\u0016\u0018\u00010+2\u0006\u0010#\u001a\u00020$H\u0086@\u00a2\u0006\u0002\u0010,J\u0010\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u0018H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0010*\u0004\u0018\u00010\u00120\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0010*\u0004\u0018\u00010\u00140\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/opensearch/indexmanagement/transform/TransformSearchService;", "", "settings", "Lorg/opensearch/common/settings/Settings;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "client", "Lorg/opensearch/transport/client/Client;", "<init>", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/transport/client/Client;)V", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "backoffPolicy", "Lorg/opensearch/action/bulk/BackoffPolicy;", "cancelAfterTimeInterval", "Lorg/opensearch/common/unit/TimeValue;", "getShardsGlobalCheckpoint", "", "Lorg/opensearch/core/index/shard/ShardId;", "", "index", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getShardLevelModifiedBuckets", "Lorg/opensearch/indexmanagement/transform/model/BucketSearchResult;", "transform", "Lorg/opensearch/indexmanagement/transform/model/Transform;", "afterKey", "currentShard", "Lorg/opensearch/indexmanagement/transform/model/ShardNewDocuments;", "transformContext", "Lorg/opensearch/indexmanagement/transform/util/TransformContext;", "(Lorg/opensearch/indexmanagement/transform/model/Transform;Ljava/util/Map;Lorg/opensearch/indexmanagement/transform/model/ShardNewDocuments;Lorg/opensearch/indexmanagement/transform/util/TransformContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "calculateMaxPageSize", "", "executeCompositeSearch", "Lorg/opensearch/indexmanagement/transform/model/TransformSearchResult;", "modifiedBuckets", "", "(Lorg/opensearch/indexmanagement/transform/model/Transform;Ljava/util/Map;Ljava/util/Set;Lorg/opensearch/indexmanagement/transform/util/TransformContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCancelAfterTimeIntervalSeconds", "givenIntervalSeconds", "Companion", "opensearch-index-management"})
public final class TransformSearchService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Settings settings;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Client client;
    private Logger logger;
    private volatile BackoffPolicy backoffPolicy;
    private volatile TimeValue cancelAfterTimeInterval;
    @NotNull
    public static final String failedSearchErrorMessage = "Failed to search data in source indices";
    @NotNull
    public static final String modifiedBucketsErrorMessage = "Failed to get the modified buckets in source indices";
    @NotNull
    public static final String getShardsErrorMessage = "Failed to get the shards in the source indices";

    public TransformSearchService(@NotNull Settings settings, @NotNull ClusterService clusterService, @NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.settings = settings;
        this.clusterService = clusterService;
        this.client = client;
        this.logger = LogManager.getLogger(this.getClass());
        TimeValue timeValue = (TimeValue)TransformSettings.Companion.getTRANSFORM_JOB_SEARCH_BACKOFF_MILLIS().get(this.settings);
        Object object = TransformSettings.Companion.getTRANSFORM_JOB_SEARCH_BACKOFF_COUNT().get(this.settings);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this.backoffPolicy = BackoffPolicy.constantBackoff((TimeValue)timeValue, (int)((Number)object).intValue());
        this.cancelAfterTimeInterval = (TimeValue)TransportSearchAction.SEARCH_CANCEL_AFTER_TIME_INTERVAL_SETTING.get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(TransformSettings.Companion.getTRANSFORM_JOB_SEARCH_BACKOFF_MILLIS(), TransformSettings.Companion.getTRANSFORM_JOB_SEARCH_BACKOFF_COUNT(), (arg_0, arg_1) -> TransformSearchService._init_$lambda$0(this, arg_0, arg_1));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(TransportSearchAction.SEARCH_CANCEL_AFTER_TIME_INTERVAL_SETTING, arg_0 -> TransformSearchService._init_$lambda$1(this, arg_0));
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getShardsGlobalCheckpoint(@NotNull String index, @NotNull Continuation<? super Map<ShardId, Long>> $completion) {
        if (!($completion instanceof getShardsGlobalCheckpoint.1)) ** GOTO lbl-1000
        var7_3 = $completion;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ TransformSearchService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getShardsGlobalCheckpoint(null, (Continuation<? super Map<ShardId, Long>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                retryAttempt = new Ref.IntRef();
                retryAttempt.element = 1;
                v0 = this.backoffPolicy;
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"backoffPolicy");
                v1 = this.logger;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"logger");
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)index);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)retryAttempt);
                $continuation.label = 1;
                v2 = org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt.retry(v0, v1, CollectionsKt.listOf((Object)RestStatus.NOT_FOUND), (Function2)new Function2<TimeValue, Continuation<? super IndicesStatsResponse>, Object>(index, retryAttempt, this, null){
                    Object L$0;
                    int label;
                    final /* synthetic */ String $index;
                    final /* synthetic */ Ref.IntRef $retryAttempt;
                    final /* synthetic */ TransformSearchService this$0;
                    {
                        this.$index = $index;
                        this.$retryAttempt = $retryAttempt;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                String[] stringArray = new String[]{this.$index};
                                IndicesStatsRequest request = ((IndicesStatsRequest)new IndicesStatsRequest().indices(stringArray)).clear();
                                if (this.$retryAttempt.element > 1) {
                                    TransformSearchService.access$getLogger$p(this.this$0).debug(org.opensearch.indexmanagement.transform.TransformSearchService$Companion.access$getShardsRetryMessage(TransformSearchService.Companion, this.$retryAttempt.element));
                                }
                                int n = this.$retryAttempt.element;
                                this.$retryAttempt.element = n + 1;
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)request);
                                this.label = 1;
                                Object object2 = org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)TransformSearchService.access$getClient$p(this.this$0), (arg_0, arg_1) -> getShardsGlobalCheckpoint.searchResponse.1.invokeSuspend$lambda$0(request, arg_0, arg_1), (Continuation)this);
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                IndicesStatsRequest request = (IndicesStatsRequest)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(TimeValue p1, Continuation<? super IndicesStatsResponse> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final Unit invokeSuspend$lambda$0(IndicesStatsRequest $request, Client $this$suspendUntil, ActionListener it) {
                        $this$suspendUntil.execute((ActionType)IndicesStatsAction.INSTANCE, (ActionRequest)$request, it);
                        return Unit.INSTANCE;
                    }
                }, $continuation);
                ** if (v2 != var8_5) goto lbl26
lbl25:
                // 1 sources

                return var8_5;
lbl26:
                // 1 sources

                ** GOTO lbl34
            }
            case 1: {
                retryAttempt = (Ref.IntRef)$continuation.L$1;
                index = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl34:
                    // 2 sources

                    if ((searchResponse = (IndicesStatsResponse)v2).getStatus() == RestStatus.OK) {
                        return TransformSearchService.Companion.convertIndicesStatsResponse(searchResponse);
                    }
                    throw new TransformSearchServiceException("Failed to get the shards in the source indices - " + searchResponse.getStatus(), null, 2, null);
                }
                catch (TransformSearchServiceException e) {
                    throw e;
                }
                catch (RemoteTransportException e) {
                    v3 = ExceptionsHelper.unwrapCause((Throwable)e);
                    Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type java.lang.Exception");
                    unwrappedException = (Exception)v3;
                    throw new TransformSearchServiceException("Failed to get the shards in the source indices", unwrappedException);
                }
                catch (OpenSearchSecurityException e) {
                    throw new TransformSearchServiceException("Failed to get the shards in the source indices - missing required index permissions: " + e.getLocalizedMessage(), e);
                }
                catch (Exception e) {
                    throw new TransformSearchServiceException("Failed to get the shards in the source indices", e);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getShardLevelModifiedBuckets(@NotNull Transform transform, @Nullable Map<String, ? extends Object> afterKey, @NotNull ShardNewDocuments currentShard, @NotNull TransformContext transformContext, @NotNull Continuation<? super BucketSearchResult> $completion) {
        if (!($completion instanceof getShardLevelModifiedBuckets.1)) ** GOTO lbl-1000
        var12_6 = $completion;
        if ((var12_6.label & -2147483648) != 0) {
            var12_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ TransformSearchService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getShardLevelModifiedBuckets(null, null, null, null, (Continuation<? super BucketSearchResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var13_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                retryAttempt = new Ref.IntRef();
                pageSize = new Ref.IntRef();
                pageSize.element = this.calculateMaxPageSize(transform);
                searchStart = Instant.now().getEpochSecond();
                v0 = this.backoffPolicy;
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"backoffPolicy");
                v1 = this.logger;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"logger");
                $continuation.L$0 = transform;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)afterKey);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)currentShard);
                $continuation.L$3 = transformContext;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)retryAttempt);
                $continuation.L$5 = pageSize;
                $continuation.J$0 = searchStart;
                $continuation.label = 1;
                v2 = OpenSearchExtensionsKt.retryTransformSearch$default(v0, v1, transformContext.getTransformLockManager(), null, (Function2)new Function2<TimeValue, Continuation<? super SearchResponse>, Object>(retryAttempt, transformContext, this, pageSize, transform, (Map<String, ? extends Object>)afterKey, currentShard, null){
                    float F$0;
                    Object L$0;
                    int label;
                    final /* synthetic */ Ref.IntRef $retryAttempt;
                    final /* synthetic */ TransformContext $transformContext;
                    final /* synthetic */ TransformSearchService this$0;
                    final /* synthetic */ Ref.IntRef $pageSize;
                    final /* synthetic */ Transform $transform;
                    final /* synthetic */ Map<String, Object> $afterKey;
                    final /* synthetic */ ShardNewDocuments $currentShard;
                    {
                        this.$retryAttempt = $retryAttempt;
                        this.$transformContext = $transformContext;
                        this.this$0 = $receiver;
                        this.$pageSize = $pageSize;
                        this.$transform = $transform;
                        this.$afterKey = $afterKey;
                        this.$currentShard = $currentShard;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                float f = 2.0f;
                                int n = this.$retryAttempt.element;
                                this.$retryAttempt.element = n + 1;
                                float pageSizeDecay = (float)Math.pow(f, n);
                                Long searchRequestTimeoutInSeconds = this.$transformContext.getMaxRequestTimeoutInSeconds();
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)searchRequestTimeoutInSeconds);
                                this.F$0 = pageSizeDecay;
                                this.label = 1;
                                Object object2 = org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)TransformSearchService.access$getClient$p(this.this$0), (arg_0, arg_1) -> getShardLevelModifiedBuckets.searchResponse.1.invokeSuspend$lambda$0(this.$pageSize, this.$transformContext, pageSizeDecay, this.$retryAttempt, this.this$0, this.$transform, searchRequestTimeoutInSeconds, this.$afterKey, this.$currentShard, arg_0, arg_1), (Continuation)this);
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                float pageSizeDecay = this.F$0;
                                Long searchRequestTimeoutInSeconds = (Long)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(TimeValue p1, Continuation<? super SearchResponse> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final Unit invokeSuspend$lambda$0(Ref.IntRef $pageSize, TransformContext $transformContext, float $pageSizeDecay, Ref.IntRef $retryAttempt, TransformSearchService this$0, Transform $transform, Long $searchRequestTimeoutInSeconds, Map $afterKey, ShardNewDocuments $currentShard, Client $this$suspendUntil, ActionListener listener) {
                        Integer n = $transformContext.getLastSuccessfulPageSize();
                        int n2 = $pageSize.element = n != null ? n : Math.max(1, $pageSize.element / (int)$pageSizeDecay);
                        if ($retryAttempt.element > 1) {
                            TransformSearchService.access$getLogger$p(this$0).debug("Attempt [" + ($retryAttempt.element - 1) + "] to get modified buckets for transform [" + $transform.getId() + "]. Attempting again with reduced page size [" + $pageSize.element + "]");
                        }
                        if ($searchRequestTimeoutInSeconds == null) {
                            return Unit.INSTANCE;
                        }
                        SearchRequest request = org.opensearch.indexmanagement.transform.TransformSearchService$Companion.access$getShardLevelBucketsSearchRequest(TransformSearchService.Companion, $transform, $afterKey, $pageSize.element, $currentShard, $searchRequestTimeoutInSeconds);
                        $this$suspendUntil.search(request, listener);
                        return Unit.INSTANCE;
                    }
                }, (Continuation)$continuation, 4, null);
                ** if (v2 != var13_8) goto lbl33
lbl32:
                // 1 sources

                return var13_8;
lbl33:
                // 1 sources

                ** GOTO lbl46
            }
            case 1: {
                searchStart = $continuation.J$0;
                pageSize = (Ref.IntRef)$continuation.L$5;
                retryAttempt = (Ref.IntRef)$continuation.L$4;
                transformContext = (TransformContext)$continuation.L$3;
                currentShard = (ShardNewDocuments)$continuation.L$2;
                afterKey = (Map)$continuation.L$1;
                transform = (Transform)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl46:
                // 2 sources

                searchResponse = (SearchResponse)v2;
                transformContext.setLastSuccessfulPageSize(Boxing.boxInt((int)pageSize.element));
                $continuation.L$0 = transform;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)afterKey);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)currentShard);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)transformContext);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)retryAttempt);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)pageSize);
                $continuation.L$6 = searchResponse;
                $continuation.J$0 = searchStart;
                $continuation.label = 2;
                v3 = transformContext.renewLockForLongSearch(Instant.now().getEpochSecond() - searchStart, (Continuation<? super Unit>)$continuation);
                ** if (v3 != var13_8) goto lbl60
lbl59:
                // 1 sources

                return var13_8;
lbl60:
                // 1 sources

                ** GOTO lbl74
            }
            case 2: {
                searchStart = $continuation.J$0;
                searchResponse = (SearchResponse)$continuation.L$6;
                pageSize = (Ref.IntRef)$continuation.L$5;
                retryAttempt = (Ref.IntRef)$continuation.L$4;
                transformContext = (TransformContext)$continuation.L$3;
                currentShard = (ShardNewDocuments)$continuation.L$2;
                afterKey = (Map)$continuation.L$1;
                transform = (Transform)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl74:
                    // 2 sources

                    return org.opensearch.indexmanagement.transform.TransformSearchService$Companion.access$convertBucketSearchResponse(TransformSearchService.Companion, transform, searchResponse);
                }
                catch (TransformSearchServiceException e) {
                    throw e;
                }
                catch (RemoteTransportException e) {
                    v4 = ExceptionsHelper.unwrapCause((Throwable)e);
                    Intrinsics.checkNotNull((Object)v4, (String)"null cannot be cast to non-null type java.lang.Exception");
                    unwrappedException = (Exception)v4;
                    throw new TransformSearchServiceException("Failed to get the modified buckets in source indices", unwrappedException);
                }
                catch (OpenSearchSecurityException e) {
                    throw new TransformSearchServiceException("Failed to get the modified buckets in source indices - missing required index permissions: " + e.getLocalizedMessage(), e);
                }
                catch (Exception e) {
                    throw new TransformSearchServiceException("Failed to get the modified buckets in source indices", e);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final int calculateMaxPageSize(Transform transform2) {
        return Math.min(transform2.getPageSize(), 1024 / (transform2.getGroups().size() + 1));
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object executeCompositeSearch(@NotNull Transform transform, @Nullable Map<String, ? extends Object> afterKey, @Nullable Set<Map<String, Object>> modifiedBuckets, @NotNull TransformContext transformContext, @NotNull Continuation<? super TransformSearchResult> $completion) {
        if (!($completion instanceof executeCompositeSearch.1)) ** GOTO lbl-1000
        var12_6 = $completion;
        if ((var12_6.label & -2147483648) != 0) {
            var12_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ TransformSearchService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.executeCompositeSearch(null, null, null, null, (Continuation<? super TransformSearchResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var13_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                pageSize = new Ref.IntRef();
                var7_11 = modifiedBuckets;
                pageSize.element = (var7_11 == null || var7_11.isEmpty() != false) != false ? transform.getPageSize() : modifiedBuckets.size();
                retryAttempt = new Ref.IntRef();
                searchStart = Instant.now().getEpochSecond();
                v0 = this.backoffPolicy;
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"backoffPolicy");
                v1 = this.logger;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"logger");
                $continuation.L$0 = transform;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)afterKey);
                $continuation.L$2 = modifiedBuckets;
                $continuation.L$3 = transformContext;
                $continuation.L$4 = pageSize;
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)retryAttempt);
                $continuation.J$0 = searchStart;
                $continuation.label = 1;
                v2 = OpenSearchExtensionsKt.retryTransformSearch$default(v0, v1, transformContext.getTransformLockManager(), null, (Function2)new Function2<TimeValue, Continuation<? super SearchResponse>, Object>(retryAttempt, transformContext, this, pageSize, transform, (Map<String, ? extends Object>)afterKey, (Set<Map<String, Object>>)modifiedBuckets, null){
                    float F$0;
                    Object L$0;
                    int label;
                    final /* synthetic */ Ref.IntRef $retryAttempt;
                    final /* synthetic */ TransformContext $transformContext;
                    final /* synthetic */ TransformSearchService this$0;
                    final /* synthetic */ Ref.IntRef $pageSize;
                    final /* synthetic */ Transform $transform;
                    final /* synthetic */ Map<String, Object> $afterKey;
                    final /* synthetic */ Set<Map<String, Object>> $modifiedBuckets;
                    {
                        this.$retryAttempt = $retryAttempt;
                        this.$transformContext = $transformContext;
                        this.this$0 = $receiver;
                        this.$pageSize = $pageSize;
                        this.$transform = $transform;
                        this.$afterKey = $afterKey;
                        this.$modifiedBuckets = $modifiedBuckets;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                float f = 2.0f;
                                int n = this.$retryAttempt.element;
                                this.$retryAttempt.element = n + 1;
                                float pageSizeDecay = (float)Math.pow(f, n);
                                Ref.ObjectRef searchRequestTimeoutInSeconds = new Ref.ObjectRef();
                                searchRequestTimeoutInSeconds.element = this.$transformContext.getMaxRequestTimeoutInSeconds();
                                if (searchRequestTimeoutInSeconds.element == null) {
                                    searchRequestTimeoutInSeconds.element = Boxing.boxLong((long)TransformSearchService.access$getCancelAfterTimeIntervalSeconds(this.this$0, TransformSearchService.access$getCancelAfterTimeInterval$p(this.this$0).getSeconds()));
                                }
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)searchRequestTimeoutInSeconds);
                                this.F$0 = pageSizeDecay;
                                this.label = 1;
                                Object object2 = org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)TransformSearchService.access$getClient$p(this.this$0), (arg_0, arg_1) -> executeCompositeSearch.searchResponse.1.invokeSuspend$lambda$0(this.$pageSize, this.$transformContext, pageSizeDecay, this.$retryAttempt, this.this$0, this.$transform, this.$afterKey, this.$modifiedBuckets, searchRequestTimeoutInSeconds, arg_0, arg_1), (Continuation)this);
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                float pageSizeDecay = this.F$0;
                                Ref.ObjectRef searchRequestTimeoutInSeconds = (Ref.ObjectRef)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(TimeValue p1, Continuation<? super SearchResponse> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final Unit invokeSuspend$lambda$0(Ref.IntRef $pageSize, TransformContext $transformContext, float $pageSizeDecay, Ref.IntRef $retryAttempt, TransformSearchService this$0, Transform $transform, Map $afterKey, Set $modifiedBuckets, Ref.ObjectRef $searchRequestTimeoutInSeconds, Client $this$suspendUntil, ActionListener listener) {
                        Integer n = $transformContext.getLastSuccessfulPageSize();
                        int n2 = $pageSize.element = n != null ? n : Math.max(1, $pageSize.element / (int)$pageSizeDecay);
                        if ($retryAttempt.element > 1) {
                            TransformSearchService.access$getLogger$p(this$0).debug("Attempt [" + ($retryAttempt.element - 1) + "] of composite search failed for transform [" + $transform.getId() + "]. Attempting again with reduced page size [" + $pageSize.element + "]");
                        }
                        SearchRequest request = TransformSearchService.Companion.getSearchServiceRequest($transform, $afterKey, $pageSize.element, $modifiedBuckets, (Long)$searchRequestTimeoutInSeconds.element);
                        $this$suspendUntil.search(request, listener);
                        return Unit.INSTANCE;
                    }
                }, (Continuation)$continuation, 4, null);
                ** if (v2 != var13_8) goto lbl34
lbl33:
                // 1 sources

                return var13_8;
lbl34:
                // 1 sources

                ** GOTO lbl47
            }
            case 1: {
                searchStart = $continuation.J$0;
                retryAttempt = (Ref.IntRef)$continuation.L$5;
                pageSize = (Ref.IntRef)$continuation.L$4;
                transformContext = (TransformContext)$continuation.L$3;
                modifiedBuckets = (Set)$continuation.L$2;
                afterKey = (Map)$continuation.L$1;
                transform = (Transform)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl47:
                // 2 sources

                searchResponse = (SearchResponse)v2;
                transformContext.setLastSuccessfulPageSize(Boxing.boxInt((int)pageSize.element));
                $continuation.L$0 = transform;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)afterKey);
                $continuation.L$2 = modifiedBuckets;
                $continuation.L$3 = transformContext;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)pageSize);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)retryAttempt);
                $continuation.L$6 = searchResponse;
                $continuation.J$0 = searchStart;
                $continuation.label = 2;
                v3 = transformContext.renewLockForLongSearch(Instant.now().getEpochSecond() - searchStart, (Continuation<? super Unit>)$continuation);
                ** if (v3 != var13_8) goto lbl61
lbl60:
                // 1 sources

                return var13_8;
lbl61:
                // 1 sources

                ** GOTO lbl75
            }
            case 2: {
                searchStart = $continuation.J$0;
                searchResponse = (SearchResponse)$continuation.L$6;
                retryAttempt = (Ref.IntRef)$continuation.L$5;
                pageSize = (Ref.IntRef)$continuation.L$4;
                transformContext = (TransformContext)$continuation.L$3;
                modifiedBuckets = (Set)$continuation.L$2;
                afterKey = (Map)$continuation.L$1;
                transform = (Transform)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl75:
                    // 2 sources

                    return org.opensearch.indexmanagement.transform.TransformSearchService$Companion.convertResponse$default(TransformSearchService.Companion, transform, searchResponse, false, modifiedBuckets, transformContext.getTargetIndexDateFieldMappings(), 4, null);
                }
                catch (TransformSearchServiceException e) {
                    throw e;
                }
                catch (RemoteTransportException e) {
                    v4 = ExceptionsHelper.unwrapCause((Throwable)e);
                    Intrinsics.checkNotNull((Object)v4, (String)"null cannot be cast to non-null type java.lang.Exception");
                    unwrappedException = (Exception)v4;
                    throw new TransformSearchServiceException("Failed to search data in source indices", unwrappedException);
                }
                catch (OpenSearchSecurityException e) {
                    throw new TransformSearchServiceException("Failed to search data in source indices - missing required index permissions: " + e.getLocalizedMessage(), e);
                }
                catch (Exception e) {
                    throw new TransformSearchServiceException("Failed to search data in source indices", e);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object executeCompositeSearch$default(TransformSearchService transformSearchService, Transform transform2, Map map, Set set, TransformContext transformContext, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        if ((n & 4) != 0) {
            set = null;
        }
        return transformSearchService.executeCompositeSearch(transform2, map, set, transformContext, (Continuation<? super TransformSearchResult>)continuation);
    }

    private final long getCancelAfterTimeIntervalSeconds(long givenIntervalSeconds) {
        if (givenIntervalSeconds == -1L) {
            return -1L;
        }
        return Math.max(givenIntervalSeconds, 600L);
    }

    private static final void _init_$lambda$0(TransformSearchService this$0, TimeValue millis, Integer count) {
        Intrinsics.checkNotNull((Object)count);
        this$0.backoffPolicy = BackoffPolicy.constantBackoff((TimeValue)millis, (int)count);
    }

    private static final void _init_$lambda$1(TransformSearchService this$0, TimeValue it) {
        this$0.cancelAfterTimeInterval = it;
    }

    public static final /* synthetic */ Logger access$getLogger$p(TransformSearchService $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Client access$getClient$p(TransformSearchService $this) {
        return $this.client;
    }

    public static final /* synthetic */ long access$getCancelAfterTimeIntervalSeconds(TransformSearchService $this, long givenIntervalSeconds) {
        return $this.getCancelAfterTimeIntervalSeconds(givenIntervalSeconds);
    }

    public static final /* synthetic */ TimeValue access$getCancelAfterTimeInterval$p(TransformSearchService $this) {
        return $this.cancelAfterTimeInterval;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002J]\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0016\b\u0002\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\n2\u001c\b\u0002\u0010\u0014\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0012\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010\u0018J8\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0018\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00120\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J1\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0002\u0010#JG\u0010$\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0016\b\u0002\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010%\u001a\u00020&2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0002\u0010'J\u001f\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u00172\u0006\u0010+\u001a\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010,JR\u0010-\u001a\u00020.2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010/\u001a\u0002002\b\b\u0002\u00101\u001a\u0002022\u001c\b\u0002\u0010\u0014\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0012\u0018\u00010\u00152\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0012J\u0018\u00104\u001a\u0002052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010/\u001a\u000200H\u0002J$\u00106\u001a\u00020\u00012\u0006\u00107\u001a\u0002082\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0012H\u0002J\u001a\u00109\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020\u00170\u00122\u0006\u0010;\u001a\u00020<R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/opensearch/indexmanagement/transform/TransformSearchService$Companion;", "", "<init>", "()V", "failedSearchErrorMessage", "", "modifiedBucketsErrorMessage", "getShardsErrorMessage", "getShardsRetryMessage", "attemptNumber", "", "noTransformGroupErrorMessage", "bucketField", "getSearchServiceRequest", "Lorg/opensearch/action/search/SearchRequest;", "transform", "Lorg/opensearch/indexmanagement/transform/model/Transform;", "afterKey", "", "pageSize", "modifiedBuckets", "", "timeoutInSeconds", "", "(Lorg/opensearch/indexmanagement/transform/model/Transform;Ljava/util/Map;ILjava/util/Set;Ljava/lang/Long;)Lorg/opensearch/action/search/SearchRequest;", "getQueryWithModifiedBuckets", "Lorg/opensearch/index/query/QueryBuilder;", "originalQuery", "groups", "", "Lorg/opensearch/indexmanagement/common/model/dimension/Dimension;", "index", "query", "aggregationBuilder", "Lorg/opensearch/search/aggregations/bucket/composite/CompositeAggregationBuilder;", "(Ljava/lang/String;Lorg/opensearch/index/query/QueryBuilder;Lorg/opensearch/search/aggregations/bucket/composite/CompositeAggregationBuilder;Ljava/lang/Long;)Lorg/opensearch/action/search/SearchRequest;", "getShardLevelBucketsSearchRequest", "currentShard", "Lorg/opensearch/indexmanagement/transform/model/ShardNewDocuments;", "(Lorg/opensearch/indexmanagement/transform/model/Transform;Ljava/util/Map;ILorg/opensearch/indexmanagement/transform/model/ShardNewDocuments;Ljava/lang/Long;)Lorg/opensearch/action/search/SearchRequest;", "getSeqNoRangeQuery", "Lorg/opensearch/index/query/RangeQueryBuilder;", "from", "to", "(Ljava/lang/Long;J)Lorg/opensearch/index/query/RangeQueryBuilder;", "convertResponse", "Lorg/opensearch/indexmanagement/transform/model/TransformSearchResult;", "searchResponse", "Lorg/opensearch/action/search/SearchResponse;", "waterMarkDocuments", "", "targetIndexDateFieldMappings", "convertBucketSearchResponse", "Lorg/opensearch/indexmanagement/transform/model/BucketSearchResult;", "getAggregationValue", "aggregation", "Lorg/opensearch/search/aggregations/Aggregation;", "convertIndicesStatsResponse", "Lorg/opensearch/core/index/shard/ShardId;", "response", "Lorg/opensearch/action/admin/indices/stats/IndicesStatsResponse;", "opensearch-index-management"})
    @SourceDebugExtension(value={"SMAP\nTransformSearchService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransformSearchService.kt\norg/opensearch/indexmanagement/transform/TransformSearchService$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,457:1\n1869#2,2:458\n1869#2:461\n1870#2:464\n1563#2:465\n1634#2,3:466\n774#2:469\n865#2,2:470\n1803#2,3:472\n1869#2:475\n1869#2,2:476\n1869#2,2:478\n1870#2:480\n1563#2:481\n1634#2,3:482\n1869#2,2:485\n1#3:460\n216#4,2:462\n3829#5:487\n4344#5,2:488\n*S KotlinDebug\n*F\n+ 1 TransformSearchService.kt\norg/opensearch/indexmanagement/transform/TransformSearchService$Companion\n*L\n266#1:458,2\n287#1:461\n287#1:464\n350#1:465\n350#1:466,3\n375#1:469\n375#1:470,2\n376#1:472,3\n382#1:475\n387#1:476,2\n390#1:478,2\n382#1:480\n410#1:481\n410#1:482,3\n430#1:485,2\n289#1:462,2\n445#1:487\n445#1:488,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String getShardsRetryMessage(int attemptNumber) {
            return "Attempt [" + attemptNumber + "] to get shard global checkpoint numbers";
        }

        private final String noTransformGroupErrorMessage(String bucketField) {
            return "Failed to find a transform group matching the bucket field [" + bucketField + "]";
        }

        @NotNull
        public final SearchRequest getSearchServiceRequest(@NotNull Transform transform2, @Nullable Map<String, ? extends Object> afterKey, int pageSize, @Nullable Set<Map<String, Object>> modifiedBuckets, @Nullable Long timeoutInSeconds) {
            Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
            List sources = new ArrayList();
            Iterable $this$forEach$iv = transform2.getGroups();
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv) {
                Dimension group = (Dimension)element$iv;
                boolean bl = false;
                CompositeValuesSourceBuilder compositeValuesSourceBuilder = Dimension.toSourceBuilder$default(group, false, 1, null).missingBucket(true);
                Intrinsics.checkNotNullExpressionValue((Object)compositeValuesSourceBuilder, (String)"missingBucket(...)");
                sources.add(compositeValuesSourceBuilder);
            }
            AbstractAggregationBuilder $i$f$forEach22 = new CompositeAggregationBuilder(transform2.getId(), sources).size(pageSize).subAggregations(transform2.getAggregations());
            CompositeAggregationBuilder $this$getSearchServiceRequest_u24lambda_u242 = (CompositeAggregationBuilder)$i$f$forEach22;
            boolean bl = false;
            Map<String, ? extends Object> map = afterKey;
            if (map != null) {
                Map<String, ? extends Object> it = map;
                boolean bl2 = false;
                $this$getSearchServiceRequest_u24lambda_u242.aggregateAfter(it);
            }
            CompositeAggregationBuilder aggregationBuilder = (CompositeAggregationBuilder)$i$f$forEach22;
            QueryBuilder query = modifiedBuckets == null ? transform2.getDataSelectionQuery() : this.getQueryWithModifiedBuckets(transform2.getDataSelectionQuery(), modifiedBuckets, transform2.getGroups());
            String string = transform2.getSourceIndex();
            Intrinsics.checkNotNull((Object)aggregationBuilder);
            return this.getSearchServiceRequest(string, query, aggregationBuilder, timeoutInSeconds);
        }

        public static /* synthetic */ SearchRequest getSearchServiceRequest$default(Companion companion, Transform transform2, Map map, int n, Set set, Long l, int n2, Object object) {
            if ((n2 & 2) != 0) {
                map = null;
            }
            if ((n2 & 8) != 0) {
                set = null;
            }
            if ((n2 & 0x10) != 0) {
                l = null;
            }
            return companion.getSearchServiceRequest(transform2, map, n, set, l);
        }

        private final QueryBuilder getQueryWithModifiedBuckets(QueryBuilder originalQuery, Set<Map<String, Object>> modifiedBuckets, List<? extends Dimension> groups) {
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().must(originalQuery).minimumShouldMatch(1);
            Intrinsics.checkNotNullExpressionValue((Object)boolQueryBuilder, (String)"minimumShouldMatch(...)");
            BoolQueryBuilder query = boolQueryBuilder;
            Iterable $this$forEach$iv = modifiedBuckets;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BoolQueryBuilder bucketQuery;
                Map bucket = (Map)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)QueryBuilders.boolQuery(), (String)"boolQuery(...)");
                Map $this$forEach$iv2 = bucket;
                boolean $i$f$forEach2 = false;
                Iterator iterator = $this$forEach$iv2.entrySet().iterator();
                while (iterator.hasNext()) {
                    BoolQueryBuilder boolQueryBuilder2;
                    ExistsQueryBuilder subQuery;
                    Dimension transformGroup;
                    Object v1;
                    Map.Entry group;
                    block5: {
                        Map.Entry element$iv2;
                        group = element$iv2 = iterator.next();
                        boolean bl2 = false;
                        Iterable iterable = groups;
                        for (Object t : iterable) {
                            Dimension it = (Dimension)t;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it.getTargetField(), group.getKey())) continue;
                            v1 = t;
                            break block5;
                        }
                        v1 = null;
                    }
                    if ((Dimension)v1 == null) {
                        throw new TransformSearchServiceException(Companion.noTransformGroupErrorMessage((String)group.getKey()), null, 2, null);
                    }
                    if (group.getValue() == null) {
                        subQuery = new ExistsQueryBuilder(transformGroup.getSourceField());
                        boolQueryBuilder2 = bucketQuery.mustNot((QueryBuilder)subQuery);
                        continue;
                    }
                    subQuery = transformGroup.toBucketQuery(group.getValue());
                    boolQueryBuilder2 = bucketQuery.filter((QueryBuilder)subQuery);
                }
                query.should((QueryBuilder)bucketQuery);
            }
            return (QueryBuilder)query;
        }

        private final SearchRequest getSearchServiceRequest(String index2, QueryBuilder query, CompositeAggregationBuilder aggregationBuilder, Long timeoutInSeconds) {
            TimeValue timeValue;
            SearchRequest request;
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().trackTotalHits(false).size(0).aggregation((AggregationBuilder)aggregationBuilder).query(query);
            String[] stringArray = new String[]{index2};
            SearchRequest searchRequest = request = new SearchRequest(stringArray).source(searchSourceBuilder).allowPartialSearchResults(false);
            Long l = timeoutInSeconds;
            if (l != null) {
                long l2 = ((Number)l).longValue();
                SearchRequest searchRequest2 = searchRequest;
                boolean bl = false;
                timeValue = new TimeValue(timeoutInSeconds.longValue(), TimeUnit.SECONDS);
                searchRequest = searchRequest2;
            } else {
                timeValue = null;
            }
            searchRequest.setCancelAfterTimeInterval(timeValue);
            Intrinsics.checkNotNull((Object)request);
            return request;
        }

        static /* synthetic */ SearchRequest getSearchServiceRequest$default(Companion companion, String string, QueryBuilder queryBuilder, CompositeAggregationBuilder compositeAggregationBuilder, Long l, int n, Object object) {
            if ((n & 8) != 0) {
                l = null;
            }
            return companion.getSearchServiceRequest(string, queryBuilder, compositeAggregationBuilder, l);
        }

        /*
         * WARNING - void declaration
         */
        private final SearchRequest getShardLevelBucketsSearchRequest(Transform transform2, Map<String, ? extends Object> afterKey, int pageSize, ShardNewDocuments currentShard, Long timeoutInSeconds) {
            CompositeAggregationBuilder compositeAggregationBuilder;
            void $this$mapTo$iv$iv;
            RangeQueryBuilder rangeQuery = this.getSeqNoRangeQuery(currentShard.getFrom(), currentShard.getTo());
            BoolQueryBuilder query = QueryBuilders.boolQuery().filter((QueryBuilder)rangeQuery).must(transform2.getDataSelectionQuery());
            Iterable $this$map$iv = transform2.getGroups();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Dimension dimension = (Dimension)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Dimension.toSourceBuilder$default((Dimension)it, false, 1, null).missingBucket(true));
            }
            List sources = (List)destination$iv$iv;
            CompositeAggregationBuilder $this$getShardLevelBucketsSearchRequest_u24lambda_u249 = compositeAggregationBuilder = new CompositeAggregationBuilder(transform2.getId(), sources).size(pageSize);
            boolean bl = false;
            Map<String, ? extends Object> map = afterKey;
            if (map != null) {
                Map<String, ? extends Object> it = map;
                boolean bl2 = false;
                $this$getShardLevelBucketsSearchRequest_u24lambda_u249.aggregateAfter(it);
            }
            CompositeAggregationBuilder aggregationBuilder = compositeAggregationBuilder;
            String string = currentShard.getShardId().getIndexName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIndexName(...)");
            Intrinsics.checkNotNull((Object)query);
            QueryBuilder queryBuilder = (QueryBuilder)query;
            Intrinsics.checkNotNull((Object)aggregationBuilder);
            compositeAggregationBuilder = this.getSearchServiceRequest(string, queryBuilder, aggregationBuilder, timeoutInSeconds).preference("_shards:" + currentShard.getShardId().getId());
            Intrinsics.checkNotNullExpressionValue((Object)compositeAggregationBuilder, (String)"preference(...)");
            return compositeAggregationBuilder;
        }

        static /* synthetic */ SearchRequest getShardLevelBucketsSearchRequest$default(Companion companion, Transform transform2, Map map, int n, ShardNewDocuments shardNewDocuments, Long l, int n2, Object object) {
            if ((n2 & 2) != 0) {
                map = null;
            }
            return companion.getShardLevelBucketsSearchRequest(transform2, map, n, shardNewDocuments, l);
        }

        private final RangeQueryBuilder getSeqNoRangeQuery(Long from, long to) {
            RangeQueryBuilder rangeQuery = new RangeQueryBuilder("_seq_no");
            if (to >= 0L) {
                rangeQuery.to((Object)to, true);
            }
            if (from != null && from >= 0L) {
                rangeQuery.from((Object)from, false);
            }
            return rangeQuery;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TransformSearchResult convertResponse(@NotNull Transform transform2, @NotNull SearchResponse searchResponse2, boolean waterMarkDocuments, @Nullable Set<Map<String, Object>> modifiedBuckets, @NotNull Map<String, ? extends Object> targetIndexDateFieldMappings) {
            void $this$fold$iv;
            List list;
            Iterable $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
            Intrinsics.checkNotNullParameter((Object)searchResponse2, (String)"searchResponse");
            Intrinsics.checkNotNullParameter(targetIndexDateFieldMappings, (String)"targetIndexDateFieldMappings");
            Aggregation aggregation = searchResponse2.getAggregations().get(transform2.getId());
            Intrinsics.checkNotNull((Object)aggregation, (String)"null cannot be cast to non-null type org.opensearch.search.aggregations.bucket.composite.CompositeAggregation");
            CompositeAggregation aggs = (CompositeAggregation)aggregation;
            if (modifiedBuckets != null) {
                List list2 = aggs.getBuckets();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getBuckets(...)");
                Iterable $this$filter$iv = list2;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Iterator element$iv$iv : $this$filterTo$iv$iv) {
                    CompositeAggregation.Bucket it = (CompositeAggregation.Bucket)element$iv$iv;
                    boolean bl = false;
                    if (!modifiedBuckets.contains(it.getKey())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = aggs.getBuckets();
            }
            List buckets = list;
            Intrinsics.checkNotNull((Object)buckets);
            $this$filterTo$iv$iv = buckets;
            long initial$iv = 0L;
            boolean $i$f$fold = false;
            long accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void bucket;
                CompositeAggregation.Bucket bl = (CompositeAggregation.Bucket)element$iv;
                long sum = accumulator$iv;
                boolean bl2 = false;
                accumulator$iv = sum + bucket.getDocCount();
            }
            long documentsProcessed = accumulator$iv;
            long pagesProcessed = 1L;
            long searchTime = searchResponse2.getTook().getMillis();
            TransformStats stats = new TransformStats(pagesProcessed, documentsProcessed, 0L, 0L, searchTime);
            Map afterKey = aggs.afterKey();
            List docsToIndex = new ArrayList();
            Iterable $this$forEach$iv = buckets;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CompositeAggregation.Bucket aggregatedBucket = (CompositeAggregation.Bucket)element$iv;
                boolean bl = false;
                String id = transform2.getId() + "#" + CollectionsKt.joinToString$default((Iterable)aggregatedBucket.getKey().entrySet(), (CharSequence)":", null, null, (int)0, null, Companion::convertResponse$lambda$15$lambda$12, (int)30, null);
                String hashedId = IndexUtils.Companion.hashToFixedSize(id);
                Map<String, Object> document = transform2.convertToDoc(aggregatedBucket.getDocCount(), waterMarkDocuments);
                Iterable $this$forEach$iv2 = aggregatedBucket.getKey().entrySet();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Map.Entry bucket = (Map.Entry)element$iv2;
                    boolean bl3 = false;
                    document.put((String)bucket.getKey(), bucket.getValue());
                }
                Aggregations aggregations = aggregatedBucket.getAggregations();
                Intrinsics.checkNotNullExpressionValue((Object)aggregations, (String)"getAggregations(...)");
                $this$forEach$iv2 = (Iterable)aggregations;
                $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Aggregation aggregation2 = (Aggregation)element$iv2;
                    boolean bl4 = false;
                    String string = aggregation2.getName();
                    Intrinsics.checkNotNull((Object)aggregation2);
                    document.put(string, Companion.getAggregationValue(aggregation2, targetIndexDateFieldMappings));
                }
                IndexRequest indexRequest = new IndexRequest(transform2.getTargetIndex()).id(hashedId).source(document, (MediaType)XContentType.JSON);
                Intrinsics.checkNotNull((Object)indexRequest);
                docsToIndex.add(indexRequest);
            }
            return new TransformSearchResult(stats, docsToIndex, afterKey);
        }

        public static /* synthetic */ TransformSearchResult convertResponse$default(Companion companion, Transform transform2, SearchResponse searchResponse2, boolean bl, Set set, Map map, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                set = null;
            }
            return companion.convertResponse(transform2, searchResponse2, bl, set, map);
        }

        /*
         * WARNING - void declaration
         */
        private final BucketSearchResult convertBucketSearchResponse(Transform transform2, SearchResponse searchResponse2) {
            void $this$mapTo$iv$iv;
            Aggregation aggregation = searchResponse2.getAggregations().get(transform2.getId());
            Intrinsics.checkNotNull((Object)aggregation, (String)"null cannot be cast to non-null type org.opensearch.search.aggregations.bucket.composite.CompositeAggregation");
            CompositeAggregation aggs = (CompositeAggregation)aggregation;
            List list = aggs.getBuckets();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBuckets(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CompositeAggregation.Bucket bucket = (CompositeAggregation.Bucket)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getKey());
            }
            Set modifiedBuckets = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
            return new BucketSearchResult(modifiedBuckets, aggs.afterKey(), searchResponse2.getTook().getMillis());
        }

        private final Object getAggregationValue(Aggregation aggregation, Map<String, ? extends Object> targetIndexDateFieldMappings) {
            Object object;
            Aggregation aggregation2 = aggregation;
            if (aggregation2 instanceof InternalSum || aggregation2 instanceof InternalMin || aggregation2 instanceof InternalMax || aggregation2 instanceof InternalAvg || aggregation2 instanceof InternalValueCount) {
                Aggregation aggregation3 = aggregation;
                Intrinsics.checkNotNull((Object)aggregation3, (String)"null cannot be cast to non-null type org.opensearch.search.aggregations.metrics.NumericMetricsAggregation.SingleValue");
                NumericMetricsAggregation.SingleValue agg = (NumericMetricsAggregation.SingleValue)aggregation3;
                object = aggregation instanceof InternalValueCount || aggregation instanceof InternalSum || !targetIndexDateFieldMappings.containsKey(agg.getName()) ? (Number)agg.value() : (Number)((long)agg.value());
            } else if (aggregation2 instanceof Percentiles) {
                Map percentiles = new LinkedHashMap();
                Iterable $this$forEach$iv = (Iterable)aggregation;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Percentile percentile = (Percentile)element$iv;
                    boolean bl = false;
                    percentiles.put(String.valueOf(percentile.getPercent()), percentile.getValue());
                }
                object = percentiles;
            } else if (aggregation2 instanceof ScriptedMetric) {
                object = ((ScriptedMetric)aggregation).aggregation();
            } else {
                throw new TransformSearchServiceException("Found aggregation [" + aggregation.getName() + "] of type [" + aggregation.getType() + "] in composite result that is not currently supported", null, 2, null);
            }
            Double d = object;
            Intrinsics.checkNotNull((Object)d);
            return d;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<ShardId, Long> convertIndicesStatsResponse(@NotNull IndicesStatsResponse response2) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
            HashMap shardStats = new HashMap();
            ShardStats[] shardStatsArray = response2.getShards();
            Intrinsics.checkNotNullExpressionValue((Object)shardStatsArray, (String)"getShards(...)");
            Object[] $this$filter$iv = shardStatsArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                ShardStats it = (ShardStats)element$iv$iv;
                boolean bl = false;
                if (!(it.getShardRouting().primary() && it.getShardRouting().active())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List shardsToSearch = (List)destination$iv$iv;
            for (ShardStats shard : shardsToSearch) {
                ShardId shardId = shard.getShardRouting().shardId();
                ShardId shardIDNoUUID = new ShardId(new Index(shardId.getIndex().getName(), "_na_"), shardId.getId());
                Map map = shardStats;
                SeqNoStats seqNoStats = shard.getSeqNoStats();
                Long l = seqNoStats != null ? seqNoStats.getGlobalCheckpoint() : -2L;
                map.put(shardIDNoUUID, l);
            }
            return shardStats;
        }

        private static final CharSequence convertResponse$lambda$15$lambda$12(Map.Entry bucket) {
            Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
            Object v = bucket.getValue();
            return v != null && (v = v.toString()) != null ? (CharSequence)v : (CharSequence)"#ODFE-MAGIC-NULL-MAGIC-ODFE#";
        }

        public static final /* synthetic */ String access$getShardsRetryMessage(Companion $this, int attemptNumber) {
            return $this.getShardsRetryMessage(attemptNumber);
        }

        public static final /* synthetic */ SearchRequest access$getShardLevelBucketsSearchRequest(Companion $this, Transform transform2, Map afterKey, int pageSize, ShardNewDocuments currentShard, Long timeoutInSeconds) {
            return $this.getShardLevelBucketsSearchRequest(transform2, afterKey, pageSize, currentShard, timeoutInSeconds);
        }

        public static final /* synthetic */ BucketSearchResult access$convertBucketSearchResponse(Companion $this, Transform transform2, SearchResponse searchResponse2) {
            return $this.convertBucketSearchResponse(transform2, searchResponse2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

