/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.metadata.filter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tika.config.Field;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.filter.MetadataFilter;

public class ClearByAttachmentTypeMetadataFilter
extends MetadataFilter {
    private final Set<String> types;

    public ClearByAttachmentTypeMetadataFilter() {
        this(new HashSet<String>());
    }

    public ClearByAttachmentTypeMetadataFilter(Set<String> types) {
        this.types = types;
    }

    @Override
    public void filter(Metadata metadata) throws TikaException {
        String type = metadata.get(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE);
        if (type == null) {
            return;
        }
        if (!this.types.contains(type)) {
            return;
        }
        for (String n : metadata.names()) {
            metadata.remove(n);
        }
    }

    @Field
    public void setTypes(List<String> types) throws TikaConfigException {
        for (String t : types) {
            try {
                TikaCoreProperties.EmbeddedResourceType.valueOf(t);
            }
            catch (IllegalArgumentException e) {
                StringBuilder sb = new StringBuilder();
                int i = 0;
                for (TikaCoreProperties.EmbeddedResourceType type : TikaCoreProperties.EmbeddedResourceType.values()) {
                    if (i++ > 0) {
                        sb.append(", ");
                    }
                    sb.append(type.name());
                }
                throw new TikaConfigException("I'm sorry. I regret I don't recognise " + t + ". I do recognize the following (case-sensitive):" + sb.toString());
            }
        }
        this.types.addAll(types);
    }

    public List<String> getTypes() {
        return new ArrayList<String>(this.types);
    }
}

