/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadView;

public class RandomAccessReadBuffer
implements RandomAccessRead {
    public static final int DEFAULT_CHUNK_SIZE_4KB = 4096;
    protected int chunkSize = 4096;
    private final List<ByteBuffer> bufferList;
    protected ByteBuffer currentBuffer;
    protected long pointer = 0L;
    protected int currentBufferPointer = 0;
    protected long size = 0L;
    private int bufferListIndex = 0;
    private int bufferListMaxIndex = 0;
    private final ConcurrentMap<Long, RandomAccessReadBuffer> rarbCopies = new ConcurrentHashMap<Long, RandomAccessReadBuffer>();

    protected RandomAccessReadBuffer() {
        this(4096);
    }

    protected RandomAccessReadBuffer(int definedChunkSize) {
        this.chunkSize = definedChunkSize;
        this.currentBuffer = ByteBuffer.allocate(this.chunkSize);
        this.bufferList = new ArrayList<ByteBuffer>(1);
        this.bufferList.add(this.currentBuffer);
    }

    public RandomAccessReadBuffer(byte[] input) {
        this(ByteBuffer.wrap(input));
    }

    public RandomAccessReadBuffer(ByteBuffer input) {
        this.chunkSize = input.limit();
        this.size = this.chunkSize;
        this.currentBuffer = input;
        this.bufferList = new ArrayList<ByteBuffer>(1);
        this.bufferList.add(this.currentBuffer);
    }

    public RandomAccessReadBuffer(InputStream input) throws IOException {
        this();
        int bytesRead = 0;
        int remainingBytes = this.chunkSize;
        int offset = 0;
        byte[] eofCheck = new byte[1];
        while (remainingBytes > 0 && (bytesRead = input.read(this.currentBuffer.array(), offset, remainingBytes)) > -1) {
            offset += bytesRead;
            this.size += (long)bytesRead;
            if ((remainingBytes -= bytesRead) != 0 || input.read(eofCheck) <= 0) continue;
            this.expandBuffer();
            this.currentBuffer.put(eofCheck);
            offset = 1;
            remainingBytes = this.chunkSize - 1;
            ++this.size;
        }
        this.currentBuffer.limit(offset);
        this.seek(0L);
    }

    private RandomAccessReadBuffer(RandomAccessReadBuffer parent) {
        this.chunkSize = parent.chunkSize;
        this.size = parent.size;
        this.bufferListMaxIndex = parent.bufferListMaxIndex;
        this.bufferList = new ArrayList<ByteBuffer>(parent.bufferList.size());
        for (ByteBuffer buffer : parent.bufferList) {
            ByteBuffer newBuffer = buffer.duplicate();
            newBuffer.rewind();
            this.bufferList.add(newBuffer);
        }
        this.currentBuffer = this.bufferList.get(0);
    }

    @Override
    public void close() throws IOException {
        this.rarbCopies.values().forEach(IOUtils::closeQuietly);
        this.rarbCopies.clear();
        this.currentBuffer = null;
        this.bufferList.clear();
    }

    @Override
    public void seek(long position) throws IOException {
        this.checkClosed();
        if (position < 0L) {
            throw new IOException("Invalid position " + position);
        }
        if (position < this.size) {
            this.pointer = position;
            this.bufferListIndex = this.chunkSize > 0 ? (int)(this.pointer / (long)this.chunkSize) : 0;
            this.currentBufferPointer = this.chunkSize > 0 ? (int)(this.pointer % (long)this.chunkSize) : 0;
            this.currentBuffer = this.bufferList.get(this.bufferListIndex);
        } else {
            this.pointer = this.size;
            this.bufferListIndex = this.bufferListMaxIndex;
            this.currentBuffer = this.bufferList.get(this.bufferListIndex);
            this.currentBufferPointer = this.chunkSize > 0 ? (int)(this.size % (long)this.chunkSize) : 0;
        }
        this.currentBuffer.position(this.currentBufferPointer);
    }

    @Override
    public long getPosition() throws IOException {
        this.checkClosed();
        return this.pointer;
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        if (this.pointer >= this.size) {
            return -1;
        }
        if (this.currentBufferPointer >= this.chunkSize) {
            if (this.bufferListIndex >= this.bufferListMaxIndex) {
                return -1;
            }
            this.currentBuffer = this.bufferList.get(++this.bufferListIndex);
            this.currentBufferPointer = 0;
        }
        ++this.pointer;
        return this.currentBuffer.get(this.currentBufferPointer++) & 0xFF;
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        this.checkClosed();
        int bytesRead = this.readRemainingBytes(b, offset, length);
        if (bytesRead == -1) {
            if (this.available() > 0) {
                bytesRead = 0;
            } else {
                return -1;
            }
        }
        while (bytesRead < length && this.available() > 0) {
            if (this.currentBufferPointer == this.chunkSize) {
                this.nextBuffer();
            }
            bytesRead += this.readRemainingBytes(b, offset + bytesRead, length - bytesRead);
        }
        return bytesRead;
    }

    private int readRemainingBytes(byte[] b, int offset, int length) {
        if (this.pointer >= this.size) {
            return -1;
        }
        int maxLength = (int)Math.min((long)length, this.size - this.pointer);
        int remainingBytes = this.chunkSize - this.currentBufferPointer;
        if (remainingBytes == 0) {
            return -1;
        }
        if (maxLength >= remainingBytes) {
            this.currentBuffer.position(this.currentBufferPointer);
            this.currentBuffer.get(b, offset, remainingBytes);
            this.currentBufferPointer += remainingBytes;
            this.pointer += (long)remainingBytes;
            return remainingBytes;
        }
        this.currentBuffer.position(this.currentBufferPointer);
        this.currentBuffer.get(b, offset, maxLength);
        this.currentBufferPointer += maxLength;
        this.pointer += (long)maxLength;
        return maxLength;
    }

    @Override
    public long length() throws IOException {
        this.checkClosed();
        return this.size;
    }

    protected void expandBuffer() throws IOException {
        if (this.bufferListMaxIndex > this.bufferListIndex) {
            this.nextBuffer();
        } else {
            this.currentBuffer = ByteBuffer.allocate(this.chunkSize);
            this.bufferList.add(this.currentBuffer);
            this.currentBufferPointer = 0;
            ++this.bufferListMaxIndex;
            ++this.bufferListIndex;
        }
    }

    private void nextBuffer() throws IOException {
        if (this.bufferListIndex == this.bufferListMaxIndex) {
            throw new IOException("No more chunks available, end of buffer reached");
        }
        this.currentBufferPointer = 0;
        this.currentBuffer = this.bufferList.get(++this.bufferListIndex);
        this.currentBuffer.rewind();
    }

    protected void checkClosed() throws IOException {
        if (this.currentBuffer == null) {
            throw new IOException("RandomAccessBuffer already closed");
        }
    }

    @Override
    public boolean isClosed() {
        return this.currentBuffer == null;
    }

    @Override
    public boolean isEOF() throws IOException {
        this.checkClosed();
        return this.pointer >= this.size;
    }

    @Override
    public RandomAccessReadView createView(long startPosition, long streamLength) throws IOException {
        Long currentThreadID = Thread.currentThread().getId();
        RandomAccessReadBuffer randomAccessReadBuffer = (RandomAccessReadBuffer)this.rarbCopies.get(currentThreadID);
        if (randomAccessReadBuffer == null || randomAccessReadBuffer.isClosed()) {
            randomAccessReadBuffer = new RandomAccessReadBuffer(this);
            this.rarbCopies.put(currentThreadID, randomAccessReadBuffer);
        }
        return new RandomAccessReadView(randomAccessReadBuffer, startPosition, streamLength);
    }

    public static RandomAccessReadBuffer createBufferFromStream(InputStream inputStream) throws IOException {
        RandomAccessReadBuffer randomAccessRead = null;
        try {
            randomAccessRead = new RandomAccessReadBuffer(inputStream);
        }
        finally {
            inputStream.close();
        }
        return randomAccessRead;
    }

    protected void resetBuffers() {
        this.size = 0L;
        this.pointer = 0L;
        this.currentBuffer = this.bufferList.get(0);
        this.currentBuffer.position(0);
        this.currentBufferPointer = 0;
        this.bufferListIndex = 0;
        this.bufferListMaxIndex = 0;
        this.bufferList.clear();
        this.bufferList.add(this.currentBuffer);
    }
}

