/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.BytesRef;
import org.opensearch.knn.index.codec.util.KNNVectorAsCollectionOfFloatsSerializer;

public class VectorField
extends Field {
    public VectorField(String name, float[] value, IndexableFieldType type) {
        super(name, new BytesRef(), type);
        try {
            KNNVectorAsCollectionOfFloatsSerializer vectorSerializer = KNNVectorAsCollectionOfFloatsSerializer.INSTANCE;
            byte[] floatToByte = vectorSerializer.floatToByteArray(value);
            this.setBytesValue(floatToByte);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public VectorField(String name, byte[] value, IndexableFieldType type) {
        super(name, new BytesRef(), type);
        try {
            this.setBytesValue(value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

