/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.nativeindex.remote;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.metadata.RepositoryMetadata;
import org.opensearch.common.UUIDs;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.index.IndexSettings;
import org.opensearch.knn.common.exception.TerminalIOException;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.codec.nativeindex.NativeIndexBuildStrategy;
import org.opensearch.knn.index.codec.nativeindex.model.BuildIndexParams;
import org.opensearch.knn.index.codec.nativeindex.remote.DefaultVectorRepositoryAccessor;
import org.opensearch.knn.index.codec.nativeindex.remote.RemoteIndexBuildMetrics;
import org.opensearch.knn.index.codec.nativeindex.remote.VectorRepositoryAccessor;
import org.opensearch.knn.index.codec.util.KNNCodecUtil;
import org.opensearch.knn.index.engine.KNNLibraryIndexingContext;
import org.opensearch.knn.index.engine.faiss.FaissHNSWMethod;
import org.opensearch.knn.index.remote.RemoteIndexWaiter;
import org.opensearch.knn.index.remote.RemoteIndexWaiterFactory;
import org.opensearch.knn.index.vectorvalues.KNNVectorValues;
import org.opensearch.knn.index.vectorvalues.QuantizedKNNBinaryVectorValues;
import org.opensearch.remoteindexbuild.client.RemoteIndexClient;
import org.opensearch.remoteindexbuild.client.RemoteIndexClientFactory;
import org.opensearch.remoteindexbuild.model.RemoteBuildRequest;
import org.opensearch.remoteindexbuild.model.RemoteBuildResponse;
import org.opensearch.remoteindexbuild.model.RemoteBuildStatusRequest;
import org.opensearch.remoteindexbuild.model.RemoteBuildStatusResponse;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.repositories.Repository;
import org.opensearch.repositories.RepositoryMissingException;
import org.opensearch.repositories.blobstore.BlobStoreRepository;

@ExperimentalApi
public class RemoteIndexBuildStrategy
implements NativeIndexBuildStrategy {
    @Generated
    private static final Logger log = LogManager.getLogger(RemoteIndexBuildStrategy.class);
    private static final String FLOAT16_VECTOR_TYPE_STRING = "half_float";
    private final Supplier<RepositoriesService> repositoriesServiceSupplier;
    private final NativeIndexBuildStrategy fallbackStrategy;
    private final IndexSettings indexSettings;
    private final KNNLibraryIndexingContext knnLibraryIndexingContext;
    private final RemoteIndexBuildMetrics metrics;

    public RemoteIndexBuildStrategy(Supplier<RepositoriesService> repositoriesServiceSupplier, NativeIndexBuildStrategy fallbackStrategy, IndexSettings indexSettings, KNNLibraryIndexingContext knnLibraryIndexingContext) {
        this.repositoriesServiceSupplier = repositoriesServiceSupplier;
        this.fallbackStrategy = fallbackStrategy;
        this.indexSettings = indexSettings;
        this.knnLibraryIndexingContext = knnLibraryIndexingContext;
        this.metrics = new RemoteIndexBuildMetrics();
    }

    public static boolean shouldBuildIndexRemotely(IndexSettings indexSettings, long vectorBlobLength) {
        if (indexSettings == null) {
            return false;
        }
        if (!((Boolean)indexSettings.getValue(KNNSettings.KNN_INDEX_REMOTE_VECTOR_BUILD_SETTING)).booleanValue()) {
            log.debug("Remote index build is disabled for index: [{}]", (Object)indexSettings.getIndex().getName());
            return false;
        }
        String vectorRepo = (String)KNNSettings.state().getSettingValue(KNNSettings.KNN_REMOTE_VECTOR_REPOSITORY_SETTING.getKey());
        if (vectorRepo == null || vectorRepo.isEmpty()) {
            log.debug("Vector repo is not configured, falling back to local build for index: [{}]", (Object)indexSettings.getIndex().getName());
            return false;
        }
        if (vectorBlobLength < ((ByteSizeValue)indexSettings.getValue(KNNSettings.KNN_INDEX_REMOTE_VECTOR_BUILD_SIZE_MIN_SETTING)).getBytes()) {
            log.debug("Data size [{}] is less than remote index build threshold [{}], falling back to local build for index [{}]", (Object)vectorBlobLength, (Object)((ByteSizeValue)indexSettings.getValue(KNNSettings.KNN_INDEX_REMOTE_VECTOR_BUILD_SIZE_MIN_SETTING)).getBytes(), (Object)indexSettings.getIndex().getName());
            return false;
        }
        ByteSizeValue upperBound = (ByteSizeValue)KNNSettings.state().getSettingValue(KNNSettings.KNN_REMOTE_VECTOR_BUILD_SIZE_MAX_SETTING.getKey());
        if (upperBound.getBytes() > 0L && vectorBlobLength > upperBound.getBytes()) {
            log.debug("Data size [{}] is greater than remote index build upper bound [{}], falling back to local build for index [{}]", (Object)vectorBlobLength, (Object)upperBound.getBytes(), (Object)indexSettings.getIndex().getName());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildAndWriteIndex(BuildIndexParams indexInfo) throws IOException {
        this.metrics.startRemoteIndexBuildMetrics(indexInfo);
        boolean success = false;
        try {
            RepositoryContext repositoryContext = this.getRepositoryContext(indexInfo);
            this.writeToRepository(repositoryContext, indexInfo);
            RemoteIndexClient client = RemoteIndexClientFactory.getRemoteIndexClient((String)KNNSettings.getRemoteBuildServiceEndpoint());
            RemoteBuildResponse remoteBuildResponse = this.submitBuild(repositoryContext, indexInfo, client);
            RemoteBuildStatusResponse remoteBuildStatusResponse = this.awaitIndexBuild(remoteBuildResponse, indexInfo, client);
            this.readFromRepository(indexInfo, repositoryContext, remoteBuildStatusResponse);
            success = true;
            return;
        }
        catch (TerminalIOException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Failed to build index remotely: " + String.valueOf(indexInfo), (Throwable)e);
        }
        finally {
            this.metrics.endRemoteIndexBuildMetrics(success);
        }
        this.fallbackStrategy.buildAndWriteIndex(indexInfo);
    }

    private void writeToRepository(RepositoryContext repositoryContext, BuildIndexParams indexInfo) {
        VectorRepositoryAccessor vectorRepositoryAccessor = repositoryContext.vectorRepositoryAccessor;
        boolean success = false;
        this.metrics.startRepositoryWriteMetrics();
        try {
            vectorRepositoryAccessor.writeToRepository(repositoryContext.blobName, indexInfo.getTotalLiveDocs(), indexInfo.getVectorDataType(), RemoteIndexBuildStrategy.decorateVectorValuesSupplier(indexInfo));
            success = true;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(String.format("Repository write failed for vector field [%s]", indexInfo.getFieldName()), e);
        }
        finally {
            this.metrics.endRepositoryWriteMetrics(success);
        }
    }

    private static Supplier<KNNVectorValues<?>> decorateVectorValuesSupplier(BuildIndexParams indexInfo) {
        if (indexInfo.getVectorDataType() == VectorDataType.BINARY && indexInfo.getQuantizationState() != null) {
            return () -> new QuantizedKNNBinaryVectorValues(indexInfo.getKnnVectorValuesSupplier().get(), indexInfo);
        }
        return indexInfo.getKnnVectorValuesSupplier();
    }

    private RemoteBuildResponse submitBuild(RepositoryContext repositoryContext, BuildIndexParams indexInfo, RemoteIndexClient client) {
        boolean success = false;
        this.metrics.startBuildRequestMetrics();
        try {
            RemoteBuildRequest buildRequest = RemoteIndexBuildStrategy.buildRemoteBuildRequest(this.indexSettings, indexInfo, repositoryContext.blobStoreRepository.getMetadata(), repositoryContext.blobPath.buildAsString() + repositoryContext.blobName, this.knnLibraryIndexingContext.getLibraryParameters());
            RemoteBuildResponse remoteBuildResponse = client.submitVectorBuild(buildRequest);
            success = true;
            RemoteBuildResponse remoteBuildResponse2 = remoteBuildResponse;
            return remoteBuildResponse2;
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Submit vector build failed for vector field [%s]", indexInfo.getFieldName()), e);
        }
        finally {
            this.metrics.endBuildRequestMetrics(success);
        }
    }

    private RemoteBuildStatusResponse awaitIndexBuild(RemoteBuildResponse remoteBuildResponse, BuildIndexParams indexInfo, RemoteIndexClient client) {
        this.metrics.startWaitingMetrics();
        try {
            RemoteBuildStatusResponse remoteBuildStatusResponse;
            RemoteBuildStatusRequest remoteBuildStatusRequest = RemoteBuildStatusRequest.builder().jobId(remoteBuildResponse.getJobId()).build();
            RemoteIndexWaiter waiter = RemoteIndexWaiterFactory.getRemoteIndexWaiter(client);
            RemoteBuildStatusResponse remoteBuildStatusResponse2 = remoteBuildStatusResponse = waiter.awaitVectorBuild(remoteBuildStatusRequest);
            return remoteBuildStatusResponse2;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(String.format("Await index build failed for vector field [%s]", indexInfo.getFieldName()), e);
        }
        finally {
            this.metrics.endWaitingMetrics();
        }
    }

    private void readFromRepository(BuildIndexParams indexInfo, RepositoryContext repositoryContext, RemoteBuildStatusResponse remoteBuildStatusResponse) throws TerminalIOException {
        this.metrics.startRepositoryReadMetrics();
        boolean success = false;
        try {
            repositoryContext.vectorRepositoryAccessor.readFromRepository(remoteBuildStatusResponse.getFileName(), indexInfo.getIndexOutputWithBuffer());
            success = true;
        }
        catch (TerminalIOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Repository read failed for vector field [%s]", indexInfo.getFieldName()), e);
        }
        finally {
            this.metrics.endRepositoryReadMetrics(success);
        }
    }

    private BlobStoreRepository getRepository() throws RepositoryMissingException {
        RepositoriesService repositoriesService = this.repositoriesServiceSupplier.get();
        assert (repositoriesService != null);
        String vectorRepo = (String)KNNSettings.state().getSettingValue(KNNSettings.KNN_REMOTE_VECTOR_REPOSITORY_SETTING.getKey());
        if (vectorRepo == null || vectorRepo.isEmpty()) {
            throw new RepositoryMissingException("Vector repository " + KNNSettings.KNN_REMOTE_VECTOR_REPOSITORY_SETTING.getKey() + " is not registered");
        }
        Repository repository = repositoriesService.repository(vectorRepo);
        assert (repository instanceof BlobStoreRepository) : "Repository should be instance of BlobStoreRepository";
        return (BlobStoreRepository)repository;
    }

    @VisibleForTesting
    RepositoryContext getRepositoryContext(BuildIndexParams indexInfo) throws IOException {
        BlobStoreRepository repository = this.getRepository();
        BlobPath blobPath = repository.basePath().add(this.indexSettings.getUUID() + "_vectors");
        String blobName = UUIDs.base64UUID() + "_" + indexInfo.getFieldName() + "_" + indexInfo.getSegmentWriteState().segmentInfo.name;
        DefaultVectorRepositoryAccessor vectorRepositoryAccessor = new DefaultVectorRepositoryAccessor(repository.blobStore().blobContainer(blobPath));
        return new RepositoryContext(repository, blobPath, vectorRepositoryAccessor, blobName);
    }

    private static String determineVectorDataType(VectorDataType dataType, Map<String, Object> parameters) {
        if (dataType == VectorDataType.FLOAT && FaissHNSWMethod.isFloat16Index(dataType, parameters)) {
            return FLOAT16_VECTOR_TYPE_STRING;
        }
        return dataType.getValue();
    }

    static RemoteBuildRequest buildRemoteBuildRequest(IndexSettings indexSettings, BuildIndexParams indexInfo, RepositoryMetadata repositoryMetadata, String fullPath, Map<String, Object> parameters) throws IOException {
        String repositoryType;
        String containerName = switch (repositoryType = repositoryMetadata.type()) {
            case "s3" -> repositoryMetadata.settings().get("bucket");
            default -> throw new IllegalArgumentException("Repository type " + repositoryType + " is not supported by the remote build service");
        };
        String vectorDataType = RemoteIndexBuildStrategy.determineVectorDataType(indexInfo.getVectorDataType(), parameters);
        KNNVectorValues<?> vectorValues = RemoteIndexBuildStrategy.decorateVectorValuesSupplier(indexInfo).get();
        KNNCodecUtil.initializeVectorValues(vectorValues);
        assert (vectorValues.dimension() > 0);
        return RemoteBuildRequest.builder().repositoryType(repositoryType).containerName(containerName).vectorPath(fullPath + ".knnvec").docIdPath(fullPath + ".knndid").tenantId(indexSettings.getSettings().get(ClusterName.CLUSTER_NAME_SETTING.getKey())).dimension(vectorValues.dimension()).docCount(indexInfo.getTotalLiveDocs()).vectorDataType(vectorDataType).engine(indexInfo.getKnnEngine().getName()).indexParameters(indexInfo.getKnnEngine().createRemoteIndexingParameters(parameters)).build();
    }

    private record RepositoryContext(BlobStoreRepository blobStoreRepository, BlobPath blobPath, VectorRepositoryAccessor vectorRepositoryAccessor, String blobName) {
    }
}

