/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.dataframe;

import java.util.Objects;
import lombok.Generated;
import org.opensearch.ml.common.dataframe.BooleanValue;
import org.opensearch.ml.common.dataframe.ColumnValue;
import org.opensearch.ml.common.dataframe.DoubleValue;
import org.opensearch.ml.common.dataframe.FloatValue;
import org.opensearch.ml.common.dataframe.IntValue;
import org.opensearch.ml.common.dataframe.LongValue;
import org.opensearch.ml.common.dataframe.NullValue;
import org.opensearch.ml.common.dataframe.ShortValue;
import org.opensearch.ml.common.dataframe.StringValue;

public final class ColumnValueBuilder {
    public static ColumnValue build(Object object) {
        if (Objects.isNull(object)) {
            return new NullValue();
        }
        if (object instanceof Short) {
            return new ShortValue((Short)object);
        }
        if (object instanceof Integer) {
            return new IntValue((Integer)object);
        }
        if (object instanceof Long) {
            return new LongValue((Long)object);
        }
        if (object instanceof String) {
            return new StringValue((String)object);
        }
        if (object instanceof Double) {
            return new DoubleValue((Double)object);
        }
        if (object instanceof Boolean) {
            return new BooleanValue((Boolean)object);
        }
        if (object instanceof Float) {
            return new FloatValue(((Float)object).floatValue());
        }
        throw new IllegalArgumentException("unsupported type:" + object.getClass().getName());
    }

    @Generated
    private ColumnValueBuilder() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

