/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.mapper;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.apache.lucene.document.FeatureField;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.opensearch.common.ValidationException;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.neuralsearch.sparse.algorithm.SparseAlgoType;
import org.opensearch.neuralsearch.sparse.mapper.SparseMethodContext;
import org.opensearch.neuralsearch.sparse.mapper.SparseVectorField;
import org.opensearch.neuralsearch.sparse.mapper.SparseVectorFieldType;

public class SparseVectorFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "sparse_vector";
    public static final String METHOD = "method";
    @NonNull
    private final SparseMethodContext sparseMethodContext;
    private FieldType tokenFieldType;

    private SparseVectorFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, SparseMethodContext sparseMethodContext) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.sparseMethodContext = sparseMethodContext;
        this.fieldType = new FieldType((IndexableFieldType)Defaults.FIELD_TYPE);
        this.fieldType.setDocValuesType(DocValuesType.BINARY);
        this.setFieldTypeAttributes(this.fieldType, sparseMethodContext);
        this.fieldType.freeze();
        this.tokenFieldType = new FieldType((IndexableFieldType)Defaults.TOKEN_FIELD_TYPE);
        this.setFieldTypeAttributes(this.tokenFieldType, sparseMethodContext);
        this.tokenFieldType.freeze();
    }

    private static SparseVectorFieldType ft(FieldMapper in) {
        return ((SparseVectorFieldMapper)in).fieldType();
    }

    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName()).init((FieldMapper)this);
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    protected SparseVectorFieldMapper clone() {
        return (SparseVectorFieldMapper)super.clone();
    }

    public SparseVectorFieldType fieldType() {
        return (SparseVectorFieldType)super.fieldType();
    }

    protected void parseCreateField(ParseContext context) throws IOException {
        if (context.externalValueSet()) {
            throw new IllegalArgumentException("[sparse_vector] fields can't be used in multi-fields");
        }
        if (context.parser().currentToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("[sparse_vector] fields must be json objects, expected a START_OBJECT but got: " + String.valueOf(context.parser().currentToken()));
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             DataOutputStream dos = new DataOutputStream(baos);){
            String feature = "";
            XContentParser.Token token = context.parser().nextToken();
            while (token != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    feature = context.parser().currentName();
                } else if (token != XContentParser.Token.VALUE_NULL) {
                    if (token == XContentParser.Token.VALUE_NUMBER || token == XContentParser.Token.VALUE_STRING) {
                        String key = this.name() + "." + feature;
                        float value = context.parser().floatValue(true);
                        if (context.doc().getByKey((Object)key) != null) {
                            throw new IllegalArgumentException("[sparse_vector] fields do not support indexing multiple values for the same key [" + key + "] in the same document");
                        }
                        FeatureField featureField = new FeatureField(this.name(), feature, value);
                        context.doc().addWithKey((Object)key, (IndexableField)featureField);
                        try {
                            int tokenIndex = Integer.parseInt(feature);
                            if (tokenIndex < 0) {
                                throw new IllegalArgumentException("[sparse_vector] fields should be text of non-negative integer");
                            }
                            dos.writeInt(tokenIndex);
                            dos.writeFloat(value);
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("[sparse_vector] fields should be valid integer");
                        }
                    } else {
                        throw new IllegalArgumentException("[sparse_vector] fields take hashes that map a feature to a strictly positive float, but got unexpected token " + String.valueOf(token));
                    }
                }
                token = context.parser().nextToken();
            }
            dos.flush();
            context.doc().add((IndexableField)new SparseVectorField(this.name(), baos.toByteArray(), (IndexableFieldType)this.fieldType));
        }
    }

    private void setFieldTypeAttributes(FieldType fieldType, SparseMethodContext sparseMethodContext) {
        if (sparseMethodContext.getName().equals("seismic")) {
            Integer nPostings = (Integer)sparseMethodContext.getMethodComponentContext().getParameter("n_postings", -1);
            Float clusterRatio = sparseMethodContext.getMethodComponentContext().getFloatParameter("cluster_ratio", Float.valueOf(0.1f));
            Float summaryPruneRatio = sparseMethodContext.getMethodComponentContext().getFloatParameter("summary_prune_ratio", Float.valueOf(0.4f));
            Integer algoTriggerThreshold = (Integer)sparseMethodContext.getMethodComponentContext().getParameter("approximate_threshold", 1000000);
            Float quantizationCeilIngest = sparseMethodContext.getMethodComponentContext().getFloatParameter("quantization_ceiling_ingest", Float.valueOf(3.0f));
            Float quantizationCeilSearch = sparseMethodContext.getMethodComponentContext().getFloatParameter("quantization_ceiling_search", Float.valueOf(16.0f));
            fieldType.putAttribute("n_postings", String.valueOf(nPostings));
            fieldType.putAttribute("summary_prune_ratio", String.valueOf(summaryPruneRatio));
            fieldType.putAttribute("cluster_ratio", String.valueOf(clusterRatio));
            fieldType.putAttribute("approximate_threshold", String.valueOf(algoTriggerThreshold));
            fieldType.putAttribute("quantization_ceiling_ingest", String.valueOf(quantizationCeilIngest));
            fieldType.putAttribute("quantization_ceiling_search", String.valueOf(quantizationCeilSearch));
        }
    }

    @NonNull
    @Generated
    public SparseMethodContext getSparseMethodContext() {
        return this.sparseMethodContext;
    }

    @Generated
    public FieldType getTokenFieldType() {
        return this.tokenFieldType;
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();
        public static final FieldType TOKEN_FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.putAttribute("sparse_vector_field", "true");
            FIELD_TYPE.freeze();
            TOKEN_FIELD_TYPE.setTokenized(false);
            TOKEN_FIELD_TYPE.setOmitNorms(true);
            TOKEN_FIELD_TYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS);
            TOKEN_FIELD_TYPE.putAttribute("sparse_vector_field", "true");
            TOKEN_FIELD_TYPE.freeze();
        }
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        protected final ParametrizedFieldMapper.Parameter<SparseMethodContext> sparseMethodContext = new ParametrizedFieldMapper.Parameter("method", false, () -> null, (n, c, o) -> SparseMethodContext.parse(o), m -> SparseVectorFieldMapper.ft(m).getSparseMethodContext()).setSerializer((b, n, v) -> {
            b.startObject(n);
            v.toXContent(b, ToXContent.EMPTY_PARAMS);
            b.endObject();
        }, m -> m.getName());

        protected Builder(String name) {
            super(name);
            this.builder = this;
        }

        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return List.of(this.sparseMethodContext);
        }

        public ParametrizedFieldMapper build(Mapper.BuilderContext context) {
            return new SparseVectorFieldMapper(this.name, new SparseVectorFieldType(this.buildFullName(context), (SparseMethodContext)this.sparseMethodContext.getValue()), this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.copyTo.build(), (SparseMethodContext)this.sparseMethodContext.getValue());
        }
    }

    public static class SparseTypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            builder.parse(name, parserContext, node);
            SparseMethodContext context = (SparseMethodContext)builder.sparseMethodContext.getValue();
            if (context == null) {
                throw new MapperParsingException("[sparse_vector] requires [method] parameter");
            }
            if (!SparseAlgoType.SEISMIC.getName().equals(context.getName())) {
                throw new MapperParsingException("[method.name]: " + context.getName() + " is not supported");
            }
            ValidationException exception = SparseAlgoType.SEISMIC.validateMethod(context);
            if (exception != null) {
                throw new MapperParsingException(exception.getMessage());
            }
            return builder;
        }
    }
}

