/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.quantization;

public final class ByteQuantizer {
    private final float ceilValue;

    public ByteQuantizer(float ceilValue) {
        if (ceilValue <= 0.0f) {
            throw new IllegalArgumentException("Ceiling value must be positive for byte quantizer");
        }
        this.ceilValue = ceilValue;
    }

    public byte quantize(float value) {
        value = Math.max(0.0f, Math.min(this.ceilValue, value));
        value = value * 255.0f / this.ceilValue;
        return (byte)Math.round(value);
    }
}

