/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.json.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import org.opensearch.client.json.jackson.JacksonJsonpGenerator;
import org.opensearch.client.json.jackson.JacksonJsonpParser;
import org.opensearch.client.json.jackson.JacksonUtils;

public class JacksonJsonProvider
extends JsonProvider {
    private final JsonFactory jsonFactory;
    private final ParserFactory defaultParserFactory = new ParserFactory(null);
    private final JsonGeneratorFactory defaultGeneratorFactory = new GeneratorFactory(null);

    public JacksonJsonProvider(JsonFactory jsonFactory) {
        this.jsonFactory = jsonFactory;
    }

    public JacksonJsonProvider() {
        this(new JsonFactory());
    }

    public JsonFactory jacksonJsonFactory() {
        return this.jsonFactory;
    }

    public JsonParserFactory createParserFactory(Map<String, ?> config) {
        if (config == null || config.isEmpty()) {
            return this.defaultParserFactory;
        }
        return this.defaultParserFactory;
    }

    public JsonParser createParser(Reader reader) {
        return this.defaultParserFactory.createParser(reader);
    }

    public JsonParser createParser(InputStream in) {
        return this.defaultParserFactory.createParser(in);
    }

    public JsonGeneratorFactory createGeneratorFactory(Map<String, ?> config) {
        if (config == null || config.isEmpty()) {
            return this.defaultGeneratorFactory;
        }
        return this.defaultGeneratorFactory;
    }

    public JsonGenerator createGenerator(Writer writer) {
        return this.defaultGeneratorFactory.createGenerator(writer);
    }

    public JsonGenerator createGenerator(OutputStream out) {
        return this.defaultGeneratorFactory.createGenerator(out);
    }

    public JsonReader createReader(Reader reader) {
        throw new UnsupportedOperationException();
    }

    public JsonReader createReader(InputStream in) {
        throw new UnsupportedOperationException();
    }

    public JsonWriter createWriter(Writer writer) {
        throw new UnsupportedOperationException();
    }

    public JsonWriter createWriter(OutputStream out) {
        throw new UnsupportedOperationException();
    }

    public JsonWriterFactory createWriterFactory(Map<String, ?> config) {
        throw new UnsupportedOperationException();
    }

    public JsonReaderFactory createReaderFactory(Map<String, ?> config) {
        throw new UnsupportedOperationException();
    }

    public JsonObjectBuilder createObjectBuilder() {
        throw new UnsupportedOperationException();
    }

    public JsonArrayBuilder createArrayBuilder() {
        throw new UnsupportedOperationException();
    }

    public JsonBuilderFactory createBuilderFactory(Map<String, ?> config) {
        throw new UnsupportedOperationException();
    }

    private class ParserFactory
    implements JsonParserFactory {
        private final Map<String, ?> config;

        ParserFactory(Map<String, ?> config) {
            this.config = config == null ? Collections.emptyMap() : config;
        }

        public JsonParser createParser(Reader reader) {
            try {
                return new JacksonJsonpParser(JacksonJsonProvider.this.jsonFactory.createParser(reader));
            }
            catch (IOException ioe) {
                throw JacksonUtils.convertException(ioe);
            }
        }

        public JsonParser createParser(InputStream in) {
            try {
                return new JacksonJsonpParser(JacksonJsonProvider.this.jsonFactory.createParser(in));
            }
            catch (IOException ioe) {
                throw JacksonUtils.convertException(ioe);
            }
        }

        public JsonParser createParser(InputStream in, Charset charset) {
            try {
                return new JacksonJsonpParser(JacksonJsonProvider.this.jsonFactory.createParser((Reader)new InputStreamReader(in, charset)));
            }
            catch (IOException ioe) {
                throw JacksonUtils.convertException(ioe);
            }
        }

        public JsonParser createParser(JsonObject obj) {
            return JsonProvider.provider().createParserFactory(null).createParser(obj);
        }

        public JsonParser createParser(JsonArray array) {
            return JsonProvider.provider().createParserFactory(null).createParser(array);
        }

        public Map<String, ?> getConfigInUse() {
            return this.config;
        }
    }

    private class GeneratorFactory
    implements JsonGeneratorFactory {
        private final Map<String, ?> config;

        GeneratorFactory(Map<String, ?> config) {
            this.config = config == null ? Collections.emptyMap() : config;
        }

        public JsonGenerator createGenerator(Writer writer) {
            try {
                return new JacksonJsonpGenerator(JacksonJsonProvider.this.jsonFactory.createGenerator(writer));
            }
            catch (IOException ioe) {
                throw JacksonUtils.convertException(ioe);
            }
        }

        public JsonGenerator createGenerator(OutputStream out) {
            try {
                return new JacksonJsonpGenerator(JacksonJsonProvider.this.jsonFactory.createGenerator(out));
            }
            catch (IOException ioe) {
                throw JacksonUtils.convertException(ioe);
            }
        }

        public JsonGenerator createGenerator(OutputStream out, Charset charset) {
            try {
                return new JacksonJsonpGenerator(JacksonJsonProvider.this.jsonFactory.createGenerator((Writer)new OutputStreamWriter(out, charset)));
            }
            catch (IOException ioe) {
                throw JacksonUtils.convertException(ioe);
            }
        }

        public Map<String, ?> getConfigInUse() {
            return this.config;
        }
    }
}

