/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.AcknowledgedResponseBase;
import org.opensearch.client.opensearch.cluster.reroute.RerouteExplanation;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RerouteResponse
extends AcknowledgedResponseBase
implements ToCopyableBuilder<Builder, RerouteResponse> {
    @Nonnull
    private final List<RerouteExplanation> explanations;
    @Nullable
    private final JsonData state;
    public static final JsonpDeserializer<RerouteResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RerouteResponse::setupRerouteResponseDeserializer);

    private RerouteResponse(Builder builder) {
        super(builder);
        this.explanations = ApiTypeHelper.unmodifiable(builder.explanations);
        this.state = builder.state;
    }

    public static RerouteResponse of(Function<Builder, ObjectBuilder<RerouteResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<RerouteExplanation> explanations() {
        return this.explanations;
    }

    @Nullable
    public final JsonData state() {
        return this.state;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.explanations)) {
            generator.writeKey("explanations");
            generator.writeStartArray();
            for (RerouteExplanation item0 : this.explanations) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.state != null) {
            generator.writeKey("state");
            this.state.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRerouteResponseDeserializer(ObjectDeserializer<Builder> op) {
        RerouteResponse.setupAcknowledgedResponseBaseDeserializer(op);
        op.add(Builder::explanations, JsonpDeserializer.arrayDeserializer(RerouteExplanation._DESERIALIZER), "explanations");
        op.add(Builder::state, JsonData._DESERIALIZER, "state");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.explanations);
        result = 31 * result + Objects.hashCode(this.state);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RerouteResponse other = (RerouteResponse)o;
        return Objects.equals(this.explanations, other.explanations) && Objects.equals(this.state, other.state);
    }

    public static class Builder
    extends AcknowledgedResponseBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, RerouteResponse> {
        @Nullable
        private List<RerouteExplanation> explanations;
        @Nullable
        private JsonData state;

        public Builder() {
        }

        private Builder(RerouteResponse o) {
            super(o);
            this.explanations = Builder._listCopy(o.explanations);
            this.state = o.state;
        }

        private Builder(Builder o) {
            super(o);
            this.explanations = Builder._listCopy(o.explanations);
            this.state = o.state;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder explanations(List<RerouteExplanation> list) {
            this.explanations = Builder._listAddAll(this.explanations, list);
            return this;
        }

        @Nonnull
        public final Builder explanations(RerouteExplanation value, RerouteExplanation ... values) {
            this.explanations = Builder._listAdd(this.explanations, value, values);
            return this;
        }

        @Nonnull
        public final Builder explanations(Function<RerouteExplanation.Builder, ObjectBuilder<RerouteExplanation>> fn) {
            return this.explanations(fn.apply(new RerouteExplanation.Builder()).build(), new RerouteExplanation[0]);
        }

        @Nonnull
        public final Builder state(@Nullable JsonData value) {
            this.state = value;
            return this;
        }

        @Override
        @Nonnull
        public RerouteResponse build() {
            this._checkSingleUse();
            return new RerouteResponse(this);
        }
    }
}

