/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.json.UnionDeserializer;
import org.opensearch.client.opensearch.core.search.SourceFilter;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class SourceConfig
implements TaggedUnion<Kind, Object>,
PlainJsonSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<SourceConfig> _DESERIALIZER = JsonpDeserializer.lazy(SourceConfig::buildSourceConfigDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private SourceConfig(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private SourceConfig(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static SourceConfig of(Function<Builder, ObjectBuilder<SourceConfig>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isFetch() {
        return this._kind == Kind.Fetch;
    }

    public Boolean fetch() {
        return (Boolean)TaggedUnionUtils.get(this, Kind.Fetch);
    }

    public boolean isFilter() {
        return this._kind == Kind.Filter;
    }

    public SourceFilter filter() {
        return (SourceFilter)TaggedUnionUtils.get(this, Kind.Filter);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind.ordinal()) {
                case 0: {
                    generator.write(((Boolean)this._value).booleanValue());
                }
            }
        }
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    private static JsonpDeserializer<SourceConfig> buildSourceConfigDeserializer() {
        return new UnionDeserializer.Builder<SourceConfig, Kind, Object>(SourceConfig::new, false).addMember(Kind.Fetch, JsonpDeserializer.booleanDeserializer()).addMember(Kind.Filter, SourceFilter._DESERIALIZER).build();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode((Object)this._kind);
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceConfig other = (SourceConfig)o;
        return Objects.equals((Object)this._kind, (Object)other._kind) && Objects.equals(this._value, other._value);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<SourceConfig> {
        private Kind _kind;
        private Object _value;

        public Builder() {
        }

        private Builder(SourceConfig o) {
            this._kind = o._kind;
            this._value = o._value;
        }

        public ObjectBuilder<SourceConfig> fetch(Boolean v) {
            this._kind = Kind.Fetch;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SourceConfig> filter(SourceFilter v) {
            this._kind = Kind.Filter;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SourceConfig> filter(Function<SourceFilter.Builder, ObjectBuilder<SourceFilter>> fn) {
            return this.filter(fn.apply(new SourceFilter.Builder()).build());
        }

        @Override
        public SourceConfig build() {
            this._checkSingleUse();
            return new SourceConfig(this);
        }
    }

    public static enum Kind {
        Fetch,
        Filter;

    }
}

