/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.opensearch.ingest.ProcessorBase;
import org.opensearch.client.opensearch.ingest.ProcessorVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class DateProcessor
extends ProcessorBase
implements ProcessorVariant,
ToCopyableBuilder<Builder, DateProcessor> {
    @Nonnull
    private final String field;
    @Nonnull
    private final List<String> formats;
    @Nullable
    private final String locale;
    @Nullable
    private final String targetField;
    @Nullable
    private final String timezone;
    public static final JsonpDeserializer<DateProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DateProcessor::setupDateProcessorDeserializer);

    private DateProcessor(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.formats = ApiTypeHelper.unmodifiableRequired(builder.formats, (Object)this, "formats");
        this.locale = builder.locale;
        this.targetField = builder.targetField;
        this.timezone = builder.timezone;
    }

    public static DateProcessor of(Function<Builder, ObjectBuilder<DateProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Date;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nonnull
    public final List<String> formats() {
        return this.formats;
    }

    @Nullable
    public final String locale() {
        return this.locale;
    }

    @Nullable
    public final String targetField() {
        return this.targetField;
    }

    @Nullable
    public final String timezone() {
        return this.timezone;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("formats");
        generator.writeStartArray();
        for (String item0 : this.formats) {
            generator.write(item0);
        }
        generator.writeEnd();
        if (this.locale != null) {
            generator.writeKey("locale");
            generator.write(this.locale);
        }
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
        if (this.timezone != null) {
            generator.writeKey("timezone");
            generator.write(this.timezone);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupDateProcessorDeserializer(ObjectDeserializer<Builder> op) {
        DateProcessor.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::formats, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "formats");
        op.add(Builder::locale, JsonpDeserializer.stringDeserializer(), "locale");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
        op.add(Builder::timezone, JsonpDeserializer.stringDeserializer(), "timezone");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + this.formats.hashCode();
        result = 31 * result + Objects.hashCode(this.locale);
        result = 31 * result + Objects.hashCode(this.targetField);
        result = 31 * result + Objects.hashCode(this.timezone);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateProcessor other = (DateProcessor)o;
        return this.field.equals(other.field) && this.formats.equals(other.formats) && Objects.equals(this.locale, other.locale) && Objects.equals(this.targetField, other.targetField) && Objects.equals(this.timezone, other.timezone);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, DateProcessor> {
        private String field;
        private List<String> formats;
        @Nullable
        private String locale;
        @Nullable
        private String targetField;
        @Nullable
        private String timezone;

        public Builder() {
        }

        private Builder(DateProcessor o) {
            super(o);
            this.field = o.field;
            this.formats = Builder._listCopy(o.formats);
            this.locale = o.locale;
            this.targetField = o.targetField;
            this.timezone = o.timezone;
        }

        private Builder(Builder o) {
            super(o);
            this.field = o.field;
            this.formats = Builder._listCopy(o.formats);
            this.locale = o.locale;
            this.targetField = o.targetField;
            this.timezone = o.timezone;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder formats(List<String> list) {
            this.formats = Builder._listAddAll(this.formats, list);
            return this;
        }

        @Nonnull
        public final Builder formats(String value, String ... values) {
            this.formats = Builder._listAdd(this.formats, value, values);
            return this;
        }

        @Nonnull
        public final Builder locale(@Nullable String value) {
            this.locale = value;
            return this;
        }

        @Nonnull
        public final Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        @Nonnull
        public final Builder timezone(@Nullable String value) {
            this.timezone = value;
            return this;
        }

        @Override
        @Nonnull
        public DateProcessor build() {
            this._checkSingleUse();
            return new DateProcessor(this);
        }
    }
}

