/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.security;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.security.GetDistinguishedNameResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class GetDistinguishedNameRequest
extends RequestBase
implements ToCopyableBuilder<Builder, GetDistinguishedNameRequest> {
    @Nonnull
    private final String clusterName;
    @Nullable
    private final Boolean showAll;
    public static final Endpoint<GetDistinguishedNameRequest, GetDistinguishedNameResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetDistinguishedNameRequest, GetDistinguishedNameResponse>(request -> "GET", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_plugins/_security/api/nodesdn/");
        SimpleEndpoint.pathEncode(request.clusterName, buf);
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetDistinguishedNameResponse._DESERIALIZER);

    private GetDistinguishedNameRequest(Builder builder) {
        super(builder);
        this.clusterName = ApiTypeHelper.requireNonNull(builder.clusterName, this, "clusterName");
        this.showAll = builder.showAll;
    }

    public static GetDistinguishedNameRequest of(Function<Builder, ObjectBuilder<GetDistinguishedNameRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String clusterName() {
        return this.clusterName;
    }

    @Nullable
    public final Boolean showAll() {
        return this.showAll;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.showAll != null) {
            params.put("show_all", String.valueOf(this.showAll));
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.clusterName.hashCode();
        result = 31 * result + Objects.hashCode(this.showAll);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetDistinguishedNameRequest other = (GetDistinguishedNameRequest)o;
        return this.clusterName.equals(other.clusterName) && Objects.equals(this.showAll, other.showAll);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, GetDistinguishedNameRequest> {
        private String clusterName;
        @Nullable
        private Boolean showAll;

        public Builder() {
        }

        private Builder(GetDistinguishedNameRequest o) {
            super(o);
            this.clusterName = o.clusterName;
            this.showAll = o.showAll;
        }

        private Builder(Builder o) {
            super(o);
            this.clusterName = o.clusterName;
            this.showAll = o.showAll;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder clusterName(String value) {
            this.clusterName = value;
            return this;
        }

        @Nonnull
        public final Builder showAll(@Nullable Boolean value) {
            this.showAll = value;
            return this;
        }

        @Override
        @Nonnull
        public GetDistinguishedNameRequest build() {
            this._checkSingleUse();
            return new GetDistinguishedNameRequest(this);
        }
    }
}

