/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.util;

public enum SignatureVersion {
    SHA1("1", "SHA1withRSA"),
    SHA256("2", "SHA256withRSA");

    private final String value;
    private final String algorithm;

    private SignatureVersion(String value, String algorithm) {
        this.value = value;
        this.algorithm = algorithm;
    }

    public static SignatureVersion fromValue(String value) {
        for (SignatureVersion signatureVersion : SignatureVersion.values()) {
            if (!signatureVersion.value.equals(value)) continue;
            return signatureVersion;
        }
        throw new RuntimeException("Invalid SignatureVersion value");
    }

    public String getValue() {
        return this.value;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }
}

