/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.services.dynamodb.model.ParameterizedStatement;
import software.amazon.awssdk.services.dynamodb.model.ParameterizedStatementsCopier;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecuteTransactionRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, ExecuteTransactionRequest> {
    private static final SdkField<List<ParameterizedStatement>> TRANSACT_STATEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TransactStatements").getter(ExecuteTransactionRequest.getter(ExecuteTransactionRequest::transactStatements)).setter(ExecuteTransactionRequest.setter(Builder::transactStatements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactStatements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParameterizedStatement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(ExecuteTransactionRequest.getter(ExecuteTransactionRequest::clientRequestToken)).setter(ExecuteTransactionRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> RETURN_CONSUMED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReturnConsumedCapacity").getter(ExecuteTransactionRequest.getter(ExecuteTransactionRequest::returnConsumedCapacityAsString)).setter(ExecuteTransactionRequest.setter(Builder::returnConsumedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnConsumedCapacity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSACT_STATEMENTS_FIELD, CLIENT_REQUEST_TOKEN_FIELD, RETURN_CONSUMED_CAPACITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExecuteTransactionRequest.memberNameToFieldInitializer();
    private final List<ParameterizedStatement> transactStatements;
    private final String clientRequestToken;
    private final String returnConsumedCapacity;

    private ExecuteTransactionRequest(BuilderImpl builder) {
        super(builder);
        this.transactStatements = builder.transactStatements;
        this.clientRequestToken = builder.clientRequestToken;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
    }

    public final boolean hasTransactStatements() {
        return this.transactStatements != null && !(this.transactStatements instanceof SdkAutoConstructList);
    }

    public final List<ParameterizedStatement> transactStatements() {
        return this.transactStatements;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue(this.returnConsumedCapacity);
    }

    public final String returnConsumedCapacityAsString() {
        return this.returnConsumedCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransactStatements() ? this.transactStatements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnConsumedCapacityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteTransactionRequest)) {
            return false;
        }
        ExecuteTransactionRequest other = (ExecuteTransactionRequest)((Object)obj);
        return this.hasTransactStatements() == other.hasTransactStatements() && Objects.equals(this.transactStatements(), other.transactStatements()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.returnConsumedCapacityAsString(), other.returnConsumedCapacityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ExecuteTransactionRequest").add("TransactStatements", this.hasTransactStatements() ? this.transactStatements() : null).add("ClientRequestToken", (Object)this.clientRequestToken()).add("ReturnConsumedCapacity", (Object)this.returnConsumedCapacityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransactStatements": {
                return Optional.ofNullable(clazz.cast(this.transactStatements()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "ReturnConsumedCapacity": {
                return Optional.ofNullable(clazz.cast(this.returnConsumedCapacityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TransactStatements", TRANSACT_STATEMENTS_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("ReturnConsumedCapacity", RETURN_CONSUMED_CAPACITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecuteTransactionRequest, T> g) {
        return obj -> g.apply((ExecuteTransactionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private List<ParameterizedStatement> transactStatements = DefaultSdkAutoConstructList.getInstance();
        private String clientRequestToken;
        private String returnConsumedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteTransactionRequest model) {
            super(model);
            this.transactStatements(model.transactStatements);
            this.clientRequestToken(model.clientRequestToken);
            this.returnConsumedCapacity(model.returnConsumedCapacity);
        }

        public final List<ParameterizedStatement.Builder> getTransactStatements() {
            List<ParameterizedStatement.Builder> result = ParameterizedStatementsCopier.copyToBuilder(this.transactStatements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransactStatements(Collection<ParameterizedStatement.BuilderImpl> transactStatements) {
            this.transactStatements = ParameterizedStatementsCopier.copyFromBuilder(transactStatements);
        }

        @Override
        public final Builder transactStatements(Collection<ParameterizedStatement> transactStatements) {
            this.transactStatements = ParameterizedStatementsCopier.copy(transactStatements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transactStatements(ParameterizedStatement ... transactStatements) {
            this.transactStatements(Arrays.asList(transactStatements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transactStatements(Consumer<ParameterizedStatement.Builder> ... transactStatements) {
            this.transactStatements(Stream.of(transactStatements).map(c -> (ParameterizedStatement)((ParameterizedStatement.Builder)ParameterizedStatement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getReturnConsumedCapacity() {
            return this.returnConsumedCapacity;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity == null ? null : returnConsumedCapacity.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteTransactionRequest build() {
            return new ExecuteTransactionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DynamoDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExecuteTransactionRequest> {
        public Builder transactStatements(Collection<ParameterizedStatement> var1);

        public Builder transactStatements(ParameterizedStatement ... var1);

        public Builder transactStatements(Consumer<ParameterizedStatement.Builder> ... var1);

        public Builder clientRequestToken(String var1);

        public Builder returnConsumedCapacity(String var1);

        public Builder returnConsumedCapacity(ReturnConsumedCapacity var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

