/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.s3.async;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.Future;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.repositories.s3.SocketAccess;

public class AsyncTransferEventLoopGroup
implements Closeable {
    private static final String THREAD_PREFIX = "s3-async-transfer-worker";
    private final Logger logger = LogManager.getLogger(AsyncTransferEventLoopGroup.class);
    private final EventLoopGroup eventLoopGroup = (EventLoopGroup)SocketAccess.doPrivileged(() -> Epoll.isAvailable() ? new EpollEventLoopGroup(eventLoopThreads, OpenSearchExecutors.daemonThreadFactory((String)THREAD_PREFIX)) : new NioEventLoopGroup(eventLoopThreads, OpenSearchExecutors.daemonThreadFactory((String)THREAD_PREFIX)));

    public AsyncTransferEventLoopGroup(int eventLoopThreads) {
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    @Override
    public void close() {
        Future shutdownFuture = this.eventLoopGroup.shutdownGracefully(0L, 5L, TimeUnit.SECONDS);
        shutdownFuture.awaitUninterruptibly();
        if (!shutdownFuture.isSuccess()) {
            this.logger.warn((Message)new ParameterizedMessage("Error closing {} netty event loop group", (Object)THREAD_PREFIX), shutdownFuture.cause());
        }
    }
}

