/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.signer.model.SignerRequest;
import software.amazon.awssdk.services.signer.model.SigningStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSigningJobsRequest
extends SignerRequest
implements ToCopyableBuilder<Builder, ListSigningJobsRequest> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ListSigningJobsRequest.getter(ListSigningJobsRequest::statusAsString)).setter(ListSigningJobsRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()}).build();
    private static final SdkField<String> PLATFORM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platformId").getter(ListSigningJobsRequest.getter(ListSigningJobsRequest::platformId)).setter(ListSigningJobsRequest.setter(Builder::platformId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("platformId").build()}).build();
    private static final SdkField<String> REQUESTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestedBy").getter(ListSigningJobsRequest.getter(ListSigningJobsRequest::requestedBy)).setter(ListSigningJobsRequest.setter(Builder::requestedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("requestedBy").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListSigningJobsRequest.getter(ListSigningJobsRequest::maxResults)).setter(ListSigningJobsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSigningJobsRequest.getter(ListSigningJobsRequest::nextToken)).setter(ListSigningJobsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Boolean> IS_REVOKED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isRevoked").getter(ListSigningJobsRequest.getter(ListSigningJobsRequest::isRevoked)).setter(ListSigningJobsRequest.setter(Builder::isRevoked)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("isRevoked").build()}).build();
    private static final SdkField<Instant> SIGNATURE_EXPIRES_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("signatureExpiresBefore").getter(ListSigningJobsRequest.getter(ListSigningJobsRequest::signatureExpiresBefore)).setter(ListSigningJobsRequest.setter(Builder::signatureExpiresBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("signatureExpiresBefore").build()}).build();
    private static final SdkField<Instant> SIGNATURE_EXPIRES_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("signatureExpiresAfter").getter(ListSigningJobsRequest.getter(ListSigningJobsRequest::signatureExpiresAfter)).setter(ListSigningJobsRequest.setter(Builder::signatureExpiresAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("signatureExpiresAfter").build()}).build();
    private static final SdkField<String> JOB_INVOKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobInvoker").getter(ListSigningJobsRequest.getter(ListSigningJobsRequest::jobInvoker)).setter(ListSigningJobsRequest.setter(Builder::jobInvoker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("jobInvoker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, PLATFORM_ID_FIELD, REQUESTED_BY_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, IS_REVOKED_FIELD, SIGNATURE_EXPIRES_BEFORE_FIELD, SIGNATURE_EXPIRES_AFTER_FIELD, JOB_INVOKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSigningJobsRequest.memberNameToFieldInitializer();
    private final String status;
    private final String platformId;
    private final String requestedBy;
    private final Integer maxResults;
    private final String nextToken;
    private final Boolean isRevoked;
    private final Instant signatureExpiresBefore;
    private final Instant signatureExpiresAfter;
    private final String jobInvoker;

    private ListSigningJobsRequest(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.platformId = builder.platformId;
        this.requestedBy = builder.requestedBy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.isRevoked = builder.isRevoked;
        this.signatureExpiresBefore = builder.signatureExpiresBefore;
        this.signatureExpiresAfter = builder.signatureExpiresAfter;
        this.jobInvoker = builder.jobInvoker;
    }

    public final SigningStatus status() {
        return SigningStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String platformId() {
        return this.platformId;
    }

    public final String requestedBy() {
        return this.requestedBy;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Boolean isRevoked() {
        return this.isRevoked;
    }

    public final Instant signatureExpiresBefore() {
        return this.signatureExpiresBefore;
    }

    public final Instant signatureExpiresAfter() {
        return this.signatureExpiresAfter;
    }

    public final String jobInvoker() {
        return this.jobInvoker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.isRevoked());
        hashCode = 31 * hashCode + Objects.hashCode(this.signatureExpiresBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.signatureExpiresAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobInvoker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSigningJobsRequest)) {
            return false;
        }
        ListSigningJobsRequest other = (ListSigningJobsRequest)((Object)obj);
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.platformId(), other.platformId()) && Objects.equals(this.requestedBy(), other.requestedBy()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.isRevoked(), other.isRevoked()) && Objects.equals(this.signatureExpiresBefore(), other.signatureExpiresBefore()) && Objects.equals(this.signatureExpiresAfter(), other.signatureExpiresAfter()) && Objects.equals(this.jobInvoker(), other.jobInvoker());
    }

    public final String toString() {
        return ToString.builder((String)"ListSigningJobsRequest").add("Status", (Object)this.statusAsString()).add("PlatformId", (Object)this.platformId()).add("RequestedBy", (Object)this.requestedBy()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("IsRevoked", (Object)this.isRevoked()).add("SignatureExpiresBefore", (Object)this.signatureExpiresBefore()).add("SignatureExpiresAfter", (Object)this.signatureExpiresAfter()).add("JobInvoker", (Object)this.jobInvoker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "platformId": {
                return Optional.ofNullable(clazz.cast(this.platformId()));
            }
            case "requestedBy": {
                return Optional.ofNullable(clazz.cast(this.requestedBy()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "isRevoked": {
                return Optional.ofNullable(clazz.cast(this.isRevoked()));
            }
            case "signatureExpiresBefore": {
                return Optional.ofNullable(clazz.cast(this.signatureExpiresBefore()));
            }
            case "signatureExpiresAfter": {
                return Optional.ofNullable(clazz.cast(this.signatureExpiresAfter()));
            }
            case "jobInvoker": {
                return Optional.ofNullable(clazz.cast(this.jobInvoker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", STATUS_FIELD);
        map.put("platformId", PLATFORM_ID_FIELD);
        map.put("requestedBy", REQUESTED_BY_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("isRevoked", IS_REVOKED_FIELD);
        map.put("signatureExpiresBefore", SIGNATURE_EXPIRES_BEFORE_FIELD);
        map.put("signatureExpiresAfter", SIGNATURE_EXPIRES_AFTER_FIELD);
        map.put("jobInvoker", JOB_INVOKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSigningJobsRequest, T> g) {
        return obj -> g.apply((ListSigningJobsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SignerRequest.BuilderImpl
    implements Builder {
        private String status;
        private String platformId;
        private String requestedBy;
        private Integer maxResults;
        private String nextToken;
        private Boolean isRevoked;
        private Instant signatureExpiresBefore;
        private Instant signatureExpiresAfter;
        private String jobInvoker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSigningJobsRequest model) {
            super(model);
            this.status(model.status);
            this.platformId(model.platformId);
            this.requestedBy(model.requestedBy);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.isRevoked(model.isRevoked);
            this.signatureExpiresBefore(model.signatureExpiresBefore);
            this.signatureExpiresAfter(model.signatureExpiresAfter);
            this.jobInvoker(model.jobInvoker);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SigningStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getPlatformId() {
            return this.platformId;
        }

        public final void setPlatformId(String platformId) {
            this.platformId = platformId;
        }

        @Override
        public final Builder platformId(String platformId) {
            this.platformId = platformId;
            return this;
        }

        public final String getRequestedBy() {
            return this.requestedBy;
        }

        public final void setRequestedBy(String requestedBy) {
            this.requestedBy = requestedBy;
        }

        @Override
        public final Builder requestedBy(String requestedBy) {
            this.requestedBy = requestedBy;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Boolean getIsRevoked() {
            return this.isRevoked;
        }

        public final void setIsRevoked(Boolean isRevoked) {
            this.isRevoked = isRevoked;
        }

        @Override
        public final Builder isRevoked(Boolean isRevoked) {
            this.isRevoked = isRevoked;
            return this;
        }

        public final Instant getSignatureExpiresBefore() {
            return this.signatureExpiresBefore;
        }

        public final void setSignatureExpiresBefore(Instant signatureExpiresBefore) {
            this.signatureExpiresBefore = signatureExpiresBefore;
        }

        @Override
        public final Builder signatureExpiresBefore(Instant signatureExpiresBefore) {
            this.signatureExpiresBefore = signatureExpiresBefore;
            return this;
        }

        public final Instant getSignatureExpiresAfter() {
            return this.signatureExpiresAfter;
        }

        public final void setSignatureExpiresAfter(Instant signatureExpiresAfter) {
            this.signatureExpiresAfter = signatureExpiresAfter;
        }

        @Override
        public final Builder signatureExpiresAfter(Instant signatureExpiresAfter) {
            this.signatureExpiresAfter = signatureExpiresAfter;
            return this;
        }

        public final String getJobInvoker() {
            return this.jobInvoker;
        }

        public final void setJobInvoker(String jobInvoker) {
            this.jobInvoker = jobInvoker;
        }

        @Override
        public final Builder jobInvoker(String jobInvoker) {
            this.jobInvoker = jobInvoker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSigningJobsRequest build() {
            return new ListSigningJobsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SignerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSigningJobsRequest> {
        public Builder status(String var1);

        public Builder status(SigningStatus var1);

        public Builder platformId(String var1);

        public Builder requestedBy(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder isRevoked(Boolean var1);

        public Builder signatureExpiresBefore(Instant var1);

        public Builder signatureExpiresAfter(Instant var1);

        public Builder jobInvoker(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

