/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges.dlsfls;

import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.privileges.PrivilegesEvaluationContext;
import org.opensearch.security.privileges.PrivilegesEvaluator;
import org.opensearch.security.support.HeaderHelper;
import org.opensearch.security.user.User;

public class DlsFlsBaseContext {
    private final PrivilegesEvaluator privilegesEvaluator;
    private final ThreadContext threadContext;
    private final AdminDNs adminDNs;

    public DlsFlsBaseContext(PrivilegesEvaluator privilegesEvaluator, ThreadContext threadContext, AdminDNs adminDNs) {
        this.privilegesEvaluator = privilegesEvaluator;
        this.threadContext = threadContext;
        this.adminDNs = adminDNs;
    }

    public PrivilegesEvaluationContext getPrivilegesEvaluationContext() {
        User user = (User)this.threadContext.getTransient("_opendistro_security_user");
        if (HeaderHelper.isInternalOrPluginRequest(this.threadContext) || this.adminDNs.isAdmin(user)) {
            return null;
        }
        return this.privilegesEvaluator.createContext(user, null);
    }

    public boolean isDlsDoneOnFilterLevel() {
        return this.threadContext.getHeader("_opendistro_security_filter_level_dls_done") != null;
    }

    public boolean isPrivilegedConfigRequest() {
        return "true".equals(HeaderHelper.getSafeFromHeader(this.threadContext, "_opendistro_security_conf_request"));
    }
}

