/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.resources;

import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.action.ActionListener;
import org.opensearch.security.resources.ResourceAccessHandler;
import org.opensearch.security.spi.resources.client.ResourceSharingClient;
import org.opensearch.security.spi.resources.sharing.ResourceSharing;
import org.opensearch.security.spi.resources.sharing.ShareWith;

public final class ResourceAccessControlClient
implements ResourceSharingClient {
    private static final Logger LOGGER = LogManager.getLogger(ResourceAccessControlClient.class);
    private final ResourceAccessHandler resourceAccessHandler;
    private final Set<String> resourceIndices;

    public ResourceAccessControlClient(ResourceAccessHandler resourceAccessHandler, Set<String> resourceIndices) {
        this.resourceAccessHandler = resourceAccessHandler;
        this.resourceIndices = resourceIndices;
    }

    public void verifyAccess(String resourceId, String resourceIndex, String action, ActionListener<Boolean> listener) {
        if (!this.resourceIndices.contains(resourceIndex)) {
            LOGGER.warn("Resource '{}' is onboarded to sharing framework but is not marked as protected. Action {} is allowed.", (Object)resourceId, (Object)action);
            listener.onResponse((Object)true);
            return;
        }
        this.resourceAccessHandler.hasPermission(resourceId, resourceIndex, action, null, listener);
    }

    public void share(String resourceId, String resourceIndex, ShareWith target, ActionListener<ResourceSharing> listener) {
        this.resourceAccessHandler.share(resourceId, resourceIndex, target, listener);
    }

    public void revoke(String resourceId, String resourceIndex, ShareWith target, ActionListener<ResourceSharing> listener) {
        this.resourceAccessHandler.revoke(resourceId, resourceIndex, target, listener);
    }

    public void getAccessibleResourceIds(String resourceIndex, ActionListener<Set<String>> listener) {
        this.resourceAccessHandler.getOwnAndSharedResourceIdsForCurrentUser(resourceIndex, listener);
    }
}

