/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.encoder.servlet;

import jakarta.servlet.http.HttpServletResponse;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.NonnullSupplier;
import org.opensaml.messaging.encoder.AbstractMessageEncoder;
import org.opensaml.messaging.encoder.servlet.HttpServletResponseMessageEncoder;

public abstract class AbstractHttpServletResponseMessageEncoder
extends AbstractMessageEncoder
implements HttpServletResponseMessageEncoder {
    @Nullable
    private NonnullSupplier<HttpServletResponse> httpServletResponseSupplier;

    @Override
    @NonnullAfterInit
    public HttpServletResponse getHttpServletResponse() {
        if (this.httpServletResponseSupplier != null) {
            return this.httpServletResponseSupplier.get();
        }
        return null;
    }

    @Override
    public synchronized void setHttpServletResponseSupplier(@Nullable NonnullSupplier<HttpServletResponse> supplier) {
        this.checkSetterPreconditions();
        this.httpServletResponseSupplier = supplier;
    }

    @NonnullAfterInit
    public NonnullSupplier<HttpServletResponse> getHttpServletResponseSupplier() {
        return this.httpServletResponseSupplier;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getHttpServletResponse() == null) {
            throw new ComponentInitializationException("HTTP servlet response cannot be null");
        }
    }
}

