/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.LazyList;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.xml.DOMTypeSupport;
import org.opensaml.core.xml.AbstractXSAnyAdapter;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.Organization;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.xmlsec.signature.Signature;

public class RoleDescriptorXSAnyAdapter
extends AbstractXSAnyAdapter
implements RoleDescriptor {
    private static final Set<QName> KNOWN_CHILD_ELEMENTS = CollectionSupport.setOf(Signature.DEFAULT_ELEMENT_NAME, Extensions.DEFAULT_ELEMENT_NAME, KeyDescriptor.DEFAULT_ELEMENT_NAME, Organization.DEFAULT_ELEMENT_NAME, ContactPerson.DEFAULT_ELEMENT_NAME);
    @Nullable
    private Signature signature;
    @Nullable
    private Extensions extensions;
    @Nullable
    private Organization organization;
    @Nonnull
    private MutableChildrenList<KeyDescriptor> keyDescriptors = new MutableChildrenList(new ArrayList());
    @Nonnull
    private MutableChildrenList<ContactPerson> contactPersons = new MutableChildrenList(new ArrayList());

    public RoleDescriptorXSAnyAdapter(@Nonnull XSAny xsAny) {
        super(xsAny);
        this.getAdapted().getUnknownAttributes().registerID(new QName("ID"));
        this.signature = this.getAdapted().getUnknownXMLObjects().stream().filter(Signature.class::isInstance).map(Signature.class::cast).findFirst().orElse(null);
        this.extensions = this.getAdapted().getUnknownXMLObjects().stream().filter(Extensions.class::isInstance).map(Extensions.class::cast).findFirst().orElse(null);
        this.organization = this.getAdapted().getUnknownXMLObjects().stream().filter(Organization.class::isInstance).map(Organization.class::cast).findFirst().orElse(null);
        this.keyDescriptors.addAllNoSync(this.getAdapted().getUnknownXMLObjects().stream().filter(KeyDescriptor.class::isInstance).map(KeyDescriptor.class::cast).toList());
        this.contactPersons.addAllNoSync(this.getAdapted().getUnknownXMLObjects().stream().filter(ContactPerson.class::isInstance).map(ContactPerson.class::cast).toList());
    }

    @Override
    @Nullable
    public String getSignatureReferenceID() {
        return this.getID();
    }

    @Override
    public boolean isSigned() {
        return this.getSignature() != null;
    }

    @Override
    @Nullable
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public void setSignature(@Nullable Signature newSignature) {
        if (this.signature != newSignature) {
            this.signature = newSignature;
            this.syncChildren();
        }
    }

    @Override
    public boolean isValid() {
        Instant validUntil = this.getValidUntil();
        if (null == validUntil) {
            return true;
        }
        return Instant.now().isBefore(validUntil);
    }

    @Override
    public Instant getValidUntil() {
        String attr = this.getAdapted().getUnknownAttributes().get(RoleDescriptor.VALID_UNTIL_ATTRIB_QNAME);
        return attr != null ? DOMTypeSupport.stringToInstant(attr) : null;
    }

    @Override
    public void setValidUntil(@Nullable Instant validUntil) {
        if (validUntil != null) {
            this.getAdapted().getUnknownAttributes().put(RoleDescriptor.VALID_UNTIL_ATTRIB_QNAME, DOMTypeSupport.instantToString(validUntil));
        } else {
            this.getAdapted().getUnknownAttributes().remove(RoleDescriptor.VALID_UNTIL_ATTRIB_QNAME);
        }
    }

    @Override
    public Duration getCacheDuration() {
        String attr = this.getAdapted().getUnknownAttributes().get(RoleDescriptor.CACHE_DURATION_ATTRIB_QNAME);
        return attr != null ? DOMTypeSupport.stringToDuration(attr) : null;
    }

    @Override
    public void setCacheDuration(@Nullable Duration duration) {
        if (duration != null) {
            this.getAdapted().getUnknownAttributes().put(RoleDescriptor.CACHE_DURATION_ATTRIB_QNAME, DOMTypeSupport.durationToString(duration));
        } else {
            this.getAdapted().getUnknownAttributes().remove(RoleDescriptor.CACHE_DURATION_ATTRIB_QNAME);
        }
    }

    @Override
    @Nonnull
    public AttributeMap getUnknownAttributes() {
        return this.getAdapted().getUnknownAttributes();
    }

    @Override
    @Nullable
    public String getID() {
        return this.getAdapted().getUnknownAttributes().get(new QName("ID"));
    }

    @Override
    public void setID(@Nullable String newID) {
        this.getAdapted().getUnknownAttributes().put(new QName("ID"), newID);
    }

    @Nonnull
    private List<String> fetchSupportedProtocols() {
        String rawValue = StringSupport.trimOrNull(this.getAdapted().getUnknownAttributes().get(new QName("protocolSupportEnumeration")));
        if (rawValue == null) {
            return new LazyList<String>();
        }
        return StringSupport.stringToList(rawValue, " ");
    }

    private void storeSupportedProtocols(@Nonnull List<String> protocols) {
        if (protocols.isEmpty()) {
            this.getAdapted().getUnknownAttributes().remove(new QName("protocolSupportEnumeration"));
        } else {
            this.getAdapted().getUnknownAttributes().put(new QName("protocolSupportEnumeration"), StringSupport.listToStringValue(protocols, " "));
        }
    }

    @Override
    @Nonnull
    @Unmodifiable
    @NotLive
    public List<String> getSupportedProtocols() {
        return CollectionSupport.copyToList(this.fetchSupportedProtocols());
    }

    @Override
    public boolean isSupportedProtocol(@Nonnull String protocol) {
        return this.fetchSupportedProtocols().contains(protocol);
    }

    @Override
    public void addSupportedProtocol(@Nonnull String protocol) {
        List<String> protocols = this.fetchSupportedProtocols();
        protocols.add(protocol);
        this.storeSupportedProtocols(protocols);
    }

    @Override
    public void removeSupportedProtocol(@Nonnull String protocol) {
        List<String> protocols = this.fetchSupportedProtocols();
        protocols.remove(protocol);
        this.storeSupportedProtocols(protocols);
    }

    @Override
    public void removeSupportedProtocols(@Nonnull Collection<String> protocolsToRemove) {
        List<String> protocols = this.fetchSupportedProtocols();
        protocols.removeAll(protocolsToRemove);
        this.storeSupportedProtocols(protocols);
    }

    @Override
    public void removeAllSupportedProtocols() {
        this.storeSupportedProtocols(CollectionSupport.emptyList());
    }

    @Override
    @Nullable
    public String getErrorURL() {
        return this.getAdapted().getUnknownAttributes().get(new QName("errorURL"));
    }

    @Override
    public void setErrorURL(@Nullable String errorURL) {
        this.getAdapted().getUnknownAttributes().put(new QName("errorURL"), errorURL);
    }

    @Override
    @Nullable
    public Extensions getExtensions() {
        return this.extensions;
    }

    @Override
    public void setExtensions(@Nullable Extensions newExtensions) {
        if (this.extensions != newExtensions) {
            this.extensions = newExtensions;
            this.syncChildren();
        }
    }

    @Override
    @Nullable
    public Organization getOrganization() {
        return this.organization;
    }

    @Override
    public void setOrganization(@Nullable Organization newOrganization) {
        if (this.organization != newOrganization) {
            this.organization = newOrganization;
            this.syncChildren();
        }
    }

    @Override
    @Nonnull
    @Live
    public List<KeyDescriptor> getKeyDescriptors() {
        return this.keyDescriptors;
    }

    @Override
    @Nonnull
    @Live
    public List<ContactPerson> getContactPersons() {
        return this.contactPersons;
    }

    @Override
    @Nonnull
    @NotLive
    @Unmodifiable
    public List<Endpoint> getEndpoints() {
        return this.getAdapted().getUnknownXMLObjects().stream().filter(Endpoint.class::isInstance).map(Endpoint.class::cast).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList())).get();
    }

    @Override
    @Nonnull
    @NotLive
    @Unmodifiable
    public List<Endpoint> getEndpoints(@Nonnull QName type) {
        return this.getEndpoints().stream().filter(t -> type.equals(t.getElementQName()) || type.equals(t.getSchemaType())).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList())).get();
    }

    private void syncChildren() {
        LinkedList<XMLObject> children = new LinkedList<XMLObject>();
        if (this.getSignature() != null) {
            children.add(this.getSignature());
        }
        if (this.getExtensions() != null) {
            children.add(this.getExtensions());
        }
        if (!this.getKeyDescriptors().isEmpty()) {
            children.addAll(this.getKeyDescriptors());
        }
        if (this.getOrganization() != null) {
            children.add(this.getOrganization());
        }
        if (!this.getContactPersons().isEmpty()) {
            children.addAll(this.getContactPersons());
        }
        children.addAll(this.getAdapted().getUnknownXMLObjects().stream().filter(Objects::nonNull).filter(t -> !KNOWN_CHILD_ELEMENTS.contains(t.getElementQName())).toList());
        this.getAdapted().getUnknownXMLObjects().clear();
        this.getAdapted().getUnknownXMLObjects().addAll(children);
    }

    private class MutableChildrenList<T extends XMLObject>
    implements List<T> {
        @Nonnull
        private List<T> storage;

        public MutableChildrenList(List<T> list) {
            this.storage = list;
        }

        @Override
        public T set(int index, T element) {
            XMLObject result = (XMLObject)this.storage.set(index, element);
            RoleDescriptorXSAnyAdapter.this.syncChildren();
            return (T)result;
        }

        @Override
        public boolean add(T e) {
            boolean result = this.storage.add(e);
            RoleDescriptorXSAnyAdapter.this.syncChildren();
            return result;
        }

        @Override
        public void add(int index, T element) {
            this.storage.add(index, element);
            RoleDescriptorXSAnyAdapter.this.syncChildren();
        }

        @Override
        public T remove(int index) {
            XMLObject result = (XMLObject)this.storage.remove(index);
            RoleDescriptorXSAnyAdapter.this.syncChildren();
            return (T)result;
        }

        @Override
        public boolean remove(Object o) {
            boolean result = this.storage.remove(o);
            RoleDescriptorXSAnyAdapter.this.syncChildren();
            return result;
        }

        @Override
        public void clear() {
            this.storage.clear();
            RoleDescriptorXSAnyAdapter.this.syncChildren();
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            boolean result = this.storage.addAll(c);
            RoleDescriptorXSAnyAdapter.this.syncChildren();
            return result;
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            boolean result = this.storage.addAll(index, c);
            RoleDescriptorXSAnyAdapter.this.syncChildren();
            return result;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean result = this.storage.removeAll(c);
            RoleDescriptorXSAnyAdapter.this.syncChildren();
            return result;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            boolean result = this.storage.retainAll(c);
            RoleDescriptorXSAnyAdapter.this.syncChildren();
            return result;
        }

        @Override
        public boolean removeIf(Predicate<? super T> filter) {
            boolean result = this.storage.removeIf(filter);
            RoleDescriptorXSAnyAdapter.this.syncChildren();
            return result;
        }

        @Override
        public void replaceAll(UnaryOperator<T> operator) {
            this.storage.replaceAll(operator);
            RoleDescriptorXSAnyAdapter.this.syncChildren();
        }

        @Override
        public int size() {
            return this.storage.size();
        }

        @Override
        public boolean isEmpty() {
            return this.storage.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.storage.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.storage.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.storage.toArray(a);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.storage.containsAll(c);
        }

        @Override
        public T get(int index) {
            return (T)((XMLObject)this.storage.get(index));
        }

        @Override
        public int indexOf(Object o) {
            return this.storage.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.storage.lastIndexOf(o);
        }

        @Override
        public Iterator<T> iterator() {
            return new MutableChildrenIterator<T>(this.storage.iterator());
        }

        @Override
        public ListIterator<T> listIterator() {
            return new MutableChildrenListIterator<T>(this.storage.listIterator());
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            return new MutableChildrenListIterator<T>(this.storage.listIterator(index));
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            return new MutableChildrenList<T>(this.storage.subList(fromIndex, toIndex));
        }

        private boolean addAllNoSync(Collection<? extends T> c) {
            return this.storage.addAll(c);
        }

        private class MutableChildrenIterator<E>
        implements Iterator<E> {
            @Nonnull
            private Iterator<E> wrapped;

            public MutableChildrenIterator(Iterator<E> iter) {
                this.wrapped = iter;
            }

            @Override
            public boolean hasNext() {
                return this.wrapped.hasNext();
            }

            @Override
            public E next() {
                return this.wrapped.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }

            @Override
            public void forEachRemaining(Consumer<? super E> action) {
                throw new UnsupportedOperationException("forEachRemaining");
            }
        }

        private class MutableChildrenListIterator<E>
        implements ListIterator<E> {
            @Nonnull
            private ListIterator<E> wrapped;

            public MutableChildrenListIterator(ListIterator<E> iter) {
                this.wrapped = iter;
            }

            @Override
            public boolean hasNext() {
                return this.wrapped.hasNext();
            }

            @Override
            public E next() {
                return this.wrapped.next();
            }

            @Override
            public boolean hasPrevious() {
                return this.wrapped.hasPrevious();
            }

            @Override
            public E previous() {
                return this.wrapped.previous();
            }

            @Override
            public int nextIndex() {
                return this.wrapped.nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.wrapped.previousIndex();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }

            @Override
            public void set(E e) {
                throw new UnsupportedOperationException("set");
            }

            @Override
            public void add(E e) {
                throw new UnsupportedOperationException("add");
            }
        }
    }
}

