/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.security.impl;

import java.security.Key;
import java.security.PublicKey;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NullableElements;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.metadata.EncryptionMethod;
import org.opensaml.saml.security.SAMLMetadataKeyAgreementEncryptionConfiguration;
import org.opensaml.saml.security.impl.MetadataCredentialResolver;
import org.opensaml.saml.security.impl.SAMLMDCredentialContext;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialContextSet;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.EncryptionParameters;
import org.opensaml.xmlsec.KeyTransportAlgorithmPredicate;
import org.opensaml.xmlsec.agreement.KeyAgreementSupport;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.criterion.EncryptionConfigurationCriterion;
import org.opensaml.xmlsec.encryption.KeySize;
import org.opensaml.xmlsec.encryption.MGF;
import org.opensaml.xmlsec.encryption.OAEPparams;
import org.opensaml.xmlsec.encryption.support.KeyAgreementEncryptionConfiguration;
import org.opensaml.xmlsec.encryption.support.RSAOAEPParameters;
import org.opensaml.xmlsec.impl.BasicEncryptionParametersResolver;
import org.opensaml.xmlsec.signature.DigestMethod;
import org.slf4j.Logger;

public class SAMLMetadataEncryptionParametersResolver
extends BasicEncryptionParametersResolver {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SAMLMetadataEncryptionParametersResolver.class);
    @Nonnull
    private MetadataCredentialResolver credentialResolver;
    private boolean mergeMetadataRSAOAEPParametersWithConfig;
    @Nonnull
    private SAMLMetadataKeyAgreementEncryptionConfiguration.KeyWrap defaultKeyAgreementUseKeyWrap = SAMLMetadataKeyAgreementEncryptionConfiguration.KeyWrap.Default;

    public SAMLMetadataEncryptionParametersResolver(@Nonnull @ParameterName(name="resolver") MetadataCredentialResolver resolver) {
        this.credentialResolver = Constraint.isNotNull(resolver, "MetadataCredentialResoler may not be null");
    }

    public boolean isMergeMetadataRSAOAEPParametersWithConfig() {
        return this.mergeMetadataRSAOAEPParametersWithConfig;
    }

    public void setMergeMetadataRSAOAEPParametersWithConfig(boolean flag) {
        this.mergeMetadataRSAOAEPParametersWithConfig = flag;
    }

    @Nonnull
    public SAMLMetadataKeyAgreementEncryptionConfiguration.KeyWrap getDefaultKeyAgreemenUseKeyWrap() {
        return this.defaultKeyAgreementUseKeyWrap;
    }

    public void setDefaultKeyAgreementUseKeyWrap(@Nullable SAMLMetadataKeyAgreementEncryptionConfiguration.KeyWrap keyWrap) {
        this.defaultKeyAgreementUseKeyWrap = keyWrap == null ? SAMLMetadataKeyAgreementEncryptionConfiguration.KeyWrap.Default : keyWrap;
    }

    @Nonnull
    protected MetadataCredentialResolver getMetadataCredentialResolver() {
        return this.credentialResolver;
    }

    @Override
    protected void resolveAndPopulateCredentialsAndAlgorithms(@Nonnull EncryptionParameters params, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> includeExcludePredicate) {
        CriteriaSet mdCredResolverCriteria = new CriteriaSet();
        mdCredResolverCriteria.addAll(criteria);
        mdCredResolverCriteria.add(new UsageCriterion(UsageType.ENCRYPTION), true);
        try {
            for (Credential credential : this.getMetadataCredentialResolver().resolve(mdCredResolverCriteria)) {
                assert (credential != null);
                if (this.log.isTraceEnabled()) {
                    Key key = CredentialSupport.extractEncryptionKey(credential);
                    this.log.trace("Evaluating candidate encryption credential from SAML metadata of type: {}", (Object)(key != null ? key.getAlgorithm() : "n/a"));
                }
                if (this.checkAndProcessKeyAgreement(params, criteria, includeExcludePredicate, credential)) {
                    return;
                }
                CredentialContextSet credContextSet = credential.getCredentialContextSet();
                SAMLMDCredentialContext metadataCredContext = credContextSet != null ? credContextSet.get(SAMLMDCredentialContext.class) : null;
                Pair<String, EncryptionMethod> dataEncryptionAlgorithmAndMethod = this.resolveDataEncryptionAlgorithm(criteria, includeExcludePredicate, metadataCredContext);
                Pair<String, EncryptionMethod> keyTransportAlgorithmAndMethod = this.resolveKeyTransportAlgorithm(credential, criteria, includeExcludePredicate, dataEncryptionAlgorithmAndMethod.getFirst(), metadataCredContext);
                if (keyTransportAlgorithmAndMethod.getFirst() == null) {
                    if (!this.log.isDebugEnabled()) continue;
                    Key key = CredentialSupport.extractEncryptionKey(credential);
                    this.log.debug("Unable to resolve key transport algorithm for credential with key type '{}', considering other credentials", (Object)(key != null ? key.getAlgorithm() : "n/a"));
                    continue;
                }
                params.setKeyTransportEncryptionCredential(credential);
                params.setKeyTransportEncryptionAlgorithm(keyTransportAlgorithmAndMethod.getFirst());
                params.setDataEncryptionAlgorithm(dataEncryptionAlgorithmAndMethod.getFirst());
                this.resolveAndPopulateRSAOAEPParams(params, criteria, includeExcludePredicate, keyTransportAlgorithmAndMethod.getSecond());
                this.processDataEncryptionCredentialAutoGeneration(params);
                return;
            }
        }
        catch (ResolverException e) {
            this.log.warn("Problem resolving credentials from metadata, falling back to local configuration", (Throwable)e);
        }
        this.log.debug("Could not resolve encryption parameters based on SAML metadata, falling back to locally configured credentials and algorithms");
        super.resolveAndPopulateCredentialsAndAlgorithms(params, criteria, includeExcludePredicate);
    }

    protected boolean checkAndProcessKeyAgreement(@Nonnull EncryptionParameters params, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> includeExcludePredicate, @Nonnull Credential credential) {
        List<EncryptionMethod> methods;
        if (!KeyAgreementSupport.supportsKeyAgreement(credential)) {
            this.log.trace("Specified Credential does not support key agreement");
            return false;
        }
        SAMLMetadataKeyAgreementEncryptionConfiguration config = this.getEffectiveKeyAgreementConfiguration(criteria, credential);
        if (config == null) {
            PublicKey pkey = credential.getPublicKey();
            this.log.warn("Unable to get effective KeyAgreementEncryptionConfiguration for credential with key type: {}", (Object)(pkey != null ? pkey.getAlgorithm() : "n/a"));
            return false;
        }
        List<String> criteriaKeyTransportAlgorithms = this.getEffectiveKeyTransportAlgorithms(criteria, includeExcludePredicate);
        List<String> criteriaDataEncryptionAlgorithms = this.getEffectiveDataEncryptionAlgorithms(criteria, includeExcludePredicate);
        CredentialContextSet credContextSet = credential.getCredentialContextSet();
        SAMLMDCredentialContext metadataCredContext = credContextSet != null ? credContextSet.get(SAMLMDCredentialContext.class) : null;
        List metadataKeyWrapAlgorithms = CollectionSupport.emptyList();
        List metadataDataEncryptionAlgorithms = CollectionSupport.emptyList();
        if (metadataCredContext != null && (methods = metadataCredContext.getEncryptionMethods()) != null) {
            List metadataAlgorithms = methods.stream().map(org.opensaml.xmlsec.encryption.EncryptionMethod::getAlgorithm).filter(Objects::nonNull).filter(PredicateSupport.and(this.getAlgorithmRuntimeSupportedPredicate(), includeExcludePredicate)).collect(Collectors.toList());
            metadataKeyWrapAlgorithms = metadataAlgorithms.stream().filter(AlgorithmSupport::isSymmetricKeyWrap).collect(Collectors.toList());
            metadataDataEncryptionAlgorithms = metadataAlgorithms.stream().filter(AlgorithmSupport::isBlockEncryption).collect(Collectors.toList());
        }
        this.log.debug("Evaling useKeyWrap: # key wrap algos '{}', # direct data algos '{}', config '{}'", new Object[]{metadataKeyWrapAlgorithms.size(), metadataDataEncryptionAlgorithms.size(), config.getMetadataUseKeyWrap()});
        boolean useKeyWrap = false;
        useKeyWrap = SAMLMetadataKeyAgreementEncryptionConfiguration.KeyWrap.Never == config.getMetadataUseKeyWrap() ? false : (SAMLMetadataKeyAgreementEncryptionConfiguration.KeyWrap.Always == config.getMetadataUseKeyWrap() || !metadataKeyWrapAlgorithms.isEmpty() ? true : metadataDataEncryptionAlgorithms.isEmpty() && SAMLMetadataKeyAgreementEncryptionConfiguration.KeyWrap.IfNotIndicated == config.getMetadataUseKeyWrap());
        return this.checkAndProcessKeyAgreement(params, criteria, credential, this.concatLists(metadataDataEncryptionAlgorithms, criteriaDataEncryptionAlgorithms), useKeyWrap ? this.concatLists(metadataKeyWrapAlgorithms, criteriaKeyTransportAlgorithms) : CollectionSupport.emptyList());
    }

    @Override
    @Nullable
    protected SAMLMetadataKeyAgreementEncryptionConfiguration getEffectiveKeyAgreementConfiguration(@Nonnull CriteriaSet criteria, @Nonnull Credential credential) {
        KeyAgreementEncryptionConfiguration baseConfig = super.getEffectiveKeyAgreementConfiguration(criteria, credential);
        if (baseConfig == null) {
            return null;
        }
        SAMLMetadataKeyAgreementEncryptionConfiguration config = new SAMLMetadataKeyAgreementEncryptionConfiguration();
        config.setAlgorithm(baseConfig.getAlgorithm());
        config.setParameters(baseConfig.getParameters());
        PublicKey pkey = credential.getPublicKey();
        if (pkey == null) {
            this.log.warn("Key agreement public key was null");
            return null;
        }
        String keyType = pkey.getAlgorithm();
        EncryptionConfigurationCriterion encryptionConfigCriterion = criteria.get(EncryptionConfigurationCriterion.class);
        if (encryptionConfigCriterion == null) {
            this.log.warn("EncryptionConfigurationCriterion was absent");
            return null;
        }
        List<EncryptionConfiguration> encConfigs = encryptionConfigCriterion.getConfigurations();
        config.setMetadataUseKeyWrap(encConfigs.stream().map(c -> c.getKeyAgreementConfigurations().get(keyType)).filter(Objects::nonNull).filter(SAMLMetadataKeyAgreementEncryptionConfiguration.class::isInstance).map(SAMLMetadataKeyAgreementEncryptionConfiguration.class::cast).map(SAMLMetadataKeyAgreementEncryptionConfiguration::getMetadataUseKeyWrap).filter(Objects::nonNull).findFirst().orElse(this.getDefaultKeyAgreemenUseKeyWrap()));
        return config;
    }

    @SafeVarargs
    @Nonnull
    private List<String> concatLists(List<String> ... lists) {
        return Stream.of(lists).filter(Objects::nonNull).flatMap(x -> x.stream()).collect(CollectionSupport.nonnullCollector(Collectors.toList())).get();
    }

    protected void resolveAndPopulateRSAOAEPParams(@Nonnull EncryptionParameters params, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> includeExcludePredicate, @Nullable EncryptionMethod encryptionMethod) {
        String alg = params.getKeyTransportEncryptionAlgorithm();
        if (alg == null || !AlgorithmSupport.isRSAOAEP(alg)) {
            return;
        }
        if (encryptionMethod == null) {
            super.resolveAndPopulateRSAOAEPParams(params, criteria, includeExcludePredicate);
            return;
        }
        RSAOAEPParameters oaepParams = params.getRSAOAEPParameters();
        if (oaepParams == null) {
            oaepParams = new RSAOAEPParameters();
            params.setRSAOAEPParameters(oaepParams);
        }
        this.populateRSAOAEPParamsFromEncryptionMethod(oaepParams, encryptionMethod, includeExcludePredicate);
        if (oaepParams.isComplete()) {
            return;
        }
        if (oaepParams.isEmpty()) {
            super.resolveAndPopulateRSAOAEPParams(params, criteria, includeExcludePredicate);
        } else if (this.isMergeMetadataRSAOAEPParametersWithConfig()) {
            super.resolveAndPopulateRSAOAEPParams(params, criteria, includeExcludePredicate);
        }
    }

    protected void populateRSAOAEPParamsFromEncryptionMethod(@Nonnull RSAOAEPParameters params, @Nonnull EncryptionMethod encryptionMethod, @Nonnull Predicate<String> includeExcludePredicate) {
        String value;
        OAEPparams oaepParams;
        MGF mgf;
        String mgfAlgorithm;
        List<XMLObject> mgfs;
        DigestMethod digestMethod;
        String digestAlgorithm;
        Predicate<String> algoSupportPredicate = this.getAlgorithmRuntimeSupportedPredicate();
        List<XMLObject> digestMethods = encryptionMethod.getUnknownXMLObjects(DigestMethod.DEFAULT_ELEMENT_NAME);
        if (digestMethods.size() > 0 && (digestAlgorithm = StringSupport.trimOrNull((digestMethod = (DigestMethod)digestMethods.get(0)).getAlgorithm())) != null && includeExcludePredicate.test(digestAlgorithm) && algoSupportPredicate.test(digestAlgorithm)) {
            params.setDigestMethod(digestAlgorithm);
        }
        if ("http://www.w3.org/2009/xmlenc11#rsa-oaep".equals(encryptionMethod.getAlgorithm()) && (mgfs = encryptionMethod.getUnknownXMLObjects(MGF.DEFAULT_ELEMENT_NAME)).size() > 0 && (mgfAlgorithm = StringSupport.trimOrNull((mgf = (MGF)mgfs.get(0)).getAlgorithm())) != null && includeExcludePredicate.test(mgfAlgorithm)) {
            params.setMaskGenerationFunction(mgfAlgorithm);
        }
        if ((oaepParams = encryptionMethod.getOAEPparams()) != null && (value = StringSupport.trimOrNull(oaepParams.getValue())) != null) {
            params.setOAEPparams(value);
        }
    }

    @Nonnull
    @NullableElements
    protected Pair<String, EncryptionMethod> resolveKeyTransportAlgorithm(@Nonnull Credential keyTransportCredential, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> includeExcludePredicate, @Nullable String dataEncryptionAlgorithm, @Nullable SAMLMDCredentialContext metadataCredContext) {
        if (metadataCredContext != null) {
            KeyTransportAlgorithmPredicate keyTransportPredicate = this.resolveKeyTransportAlgorithmPredicate(criteria);
            List<EncryptionMethod> methods = metadataCredContext.getEncryptionMethods();
            if (methods != null) {
                for (EncryptionMethod encryptionMethod : methods) {
                    String algorithm = encryptionMethod.getAlgorithm();
                    this.log.trace("Evaluating SAML metadata EncryptionMethod algorithm for key transport: {}", (Object)algorithm);
                    if (algorithm == null || !this.isKeyTransportAlgorithm(algorithm) || !includeExcludePredicate.test(algorithm) || !this.getAlgorithmRuntimeSupportedPredicate().test(algorithm) || !this.credentialSupportsEncryptionMethod(keyTransportCredential, encryptionMethod) || !this.evaluateEncryptionMethodChildren(encryptionMethod, criteria, includeExcludePredicate)) continue;
                    boolean accepted = true;
                    if (keyTransportPredicate != null) {
                        accepted = keyTransportPredicate.test(new KeyTransportAlgorithmPredicate.SelectionInput(algorithm, dataEncryptionAlgorithm, keyTransportCredential));
                    }
                    if (!accepted) continue;
                    this.log.debug("Resolved key transport algorithm URI from SAML metadata EncryptionMethod: {}", (Object)algorithm);
                    return new Pair<String, EncryptionMethod>(algorithm, encryptionMethod);
                }
            }
        }
        this.log.debug("Could not resolve key transport algorithm based on SAML metadata, falling back to locally configured algorithms");
        return new Pair<String, Object>(super.resolveKeyTransportAlgorithm(keyTransportCredential, criteria, includeExcludePredicate, dataEncryptionAlgorithm), null);
    }

    @Nonnull
    @NullableElements
    protected Pair<String, EncryptionMethod> resolveDataEncryptionAlgorithm(@Nonnull CriteriaSet criteria, @Nonnull Predicate<String> includeExcludePredicate, @Nullable SAMLMDCredentialContext metadataCredContext) {
        List<EncryptionMethod> methods;
        if (metadataCredContext != null && (methods = metadataCredContext.getEncryptionMethods()) != null) {
            for (EncryptionMethod encryptionMethod : methods) {
                String algorithm = encryptionMethod.getAlgorithm();
                this.log.trace("Evaluating SAML metadata EncryptionMethod algorithm for data encryption: {}", (Object)algorithm);
                if (!this.isDataEncryptionAlgorithm(algorithm) || !includeExcludePredicate.test(algorithm) || !this.getAlgorithmRuntimeSupportedPredicate().test(algorithm) || !this.evaluateEncryptionMethodChildren(encryptionMethod, criteria, includeExcludePredicate)) continue;
                this.log.debug("Resolved data encryption algorithm URI from SAML metadata EncryptionMethod: {}", (Object)algorithm);
                return new Pair<String, EncryptionMethod>(algorithm, encryptionMethod);
            }
        }
        this.log.debug("Could not resolve data encryption algorithm based on SAML metadata, falling back to locally configured algorithms");
        return new Pair<String, Object>(super.resolveDataEncryptionAlgorithm(null, criteria, includeExcludePredicate), null);
    }

    protected boolean evaluateEncryptionMethodChildren(@Nonnull EncryptionMethod encryptionMethod, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> includeExcludePredicate) {
        String alg = encryptionMethod.getAlgorithm();
        if (alg == null) {
            return false;
        }
        switch (alg) {
            case "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p": 
            case "http://www.w3.org/2009/xmlenc11#rsa-oaep": {
                return this.evaluateRSAOAEPChildren(encryptionMethod, criteria, includeExcludePredicate);
            }
        }
        return true;
    }

    protected boolean evaluateRSAOAEPChildren(@Nonnull EncryptionMethod encryptionMethod, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> includeExcludePredicate) {
        MGF mgf;
        String mgfAlgorithm;
        List<XMLObject> mgfs;
        DigestMethod digestMethod;
        String digestAlgorithm;
        Predicate<String> algoSupportPredicate = this.getAlgorithmRuntimeSupportedPredicate();
        List<XMLObject> digestMethods = encryptionMethod.getUnknownXMLObjects(DigestMethod.DEFAULT_ELEMENT_NAME);
        if (!(digestMethods.size() <= 0 || (digestAlgorithm = StringSupport.trimOrNull((digestMethod = (DigestMethod)digestMethods.get(0)).getAlgorithm())) == null || includeExcludePredicate.test(digestAlgorithm) && algoSupportPredicate.test(digestAlgorithm))) {
            this.log.debug("Rejecting RSA OAEP EncryptionMethod due to unsupported or disallowed DigestMethod: {}", (Object)digestAlgorithm);
            return false;
        }
        if ("http://www.w3.org/2009/xmlenc11#rsa-oaep".equals(encryptionMethod.getAlgorithm()) && (mgfs = encryptionMethod.getUnknownXMLObjects(MGF.DEFAULT_ELEMENT_NAME)).size() > 0 && (mgfAlgorithm = StringSupport.trimOrNull((mgf = (MGF)mgfs.get(0)).getAlgorithm())) != null && !includeExcludePredicate.test(mgfAlgorithm)) {
            this.log.debug("Rejecting RSA OAEP EncryptionMethod due to disallowed MGF: {}", (Object)mgfAlgorithm);
            return false;
        }
        return true;
    }

    protected boolean credentialSupportsEncryptionMethod(@Nonnull Credential credential, @Nonnull EncryptionMethod encryptionMethod) {
        String alg = encryptionMethod.getAlgorithm();
        if (alg == null || !this.credentialSupportsAlgorithm(credential, alg)) {
            return false;
        }
        KeySize keySize = encryptionMethod.getKeySize();
        if (keySize != null && keySize.getValue() != null) {
            Key encryptionKey = CredentialSupport.extractEncryptionKey(credential);
            if (encryptionKey == null) {
                this.log.warn("Could not extract encryption key from credential. Failing evaluation");
                return false;
            }
            Integer keyLength = KeySupport.getKeyLength(encryptionKey);
            if (keyLength == null) {
                this.log.warn("Could not determine key length of candidate encryption credential. Failing evaluation");
                return false;
            }
            if (!keyLength.equals(keySize.getValue())) {
                return false;
            }
        }
        return true;
    }
}

