/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.referral;

import org.ldaptive.Connection;
import org.ldaptive.LdapURL;
import org.ldaptive.ModifyDnOperation;
import org.ldaptive.ModifyDnRequest;
import org.ldaptive.Operation;
import org.ldaptive.referral.AbstractReferralHandler;
import org.ldaptive.referral.ReferralConnectionFactory;

public class ModifyDnReferralHandler
extends AbstractReferralHandler<ModifyDnRequest, Void> {
    public ModifyDnReferralHandler() {
        this(10, 0, DEFAULT_CONNECTION_FACTORY);
    }

    public ModifyDnReferralHandler(ReferralConnectionFactory factory) {
        this(10, 0, factory);
    }

    public ModifyDnReferralHandler(int limit) {
        this(limit, 0, DEFAULT_CONNECTION_FACTORY);
    }

    public ModifyDnReferralHandler(int limit, ReferralConnectionFactory factory) {
        this(limit, 0, factory);
    }

    private ModifyDnReferralHandler(int limit, int depth, ReferralConnectionFactory factory) {
        super(limit, depth, factory);
    }

    @Override
    protected ModifyDnRequest createReferralRequest(ModifyDnRequest request, LdapURL url) {
        ModifyDnRequest referralRequest = new ModifyDnRequest();
        referralRequest.setControls(request.getControls());
        referralRequest.setIntermediateResponseHandlers(request.getIntermediateResponseHandlers());
        referralRequest.setReferralHandler(new ModifyDnReferralHandler(this.getReferralLimit(), this.getReferralDepth() + 1, this.getReferralConnectionFactory()));
        if (!url.getEntry().isDefaultBaseDn()) {
            referralRequest.setDn(url.getEntry().getBaseDn());
        } else {
            referralRequest.setDn(request.getDn());
        }
        referralRequest.setDeleteOldRDn(request.getDeleteOldRDn());
        referralRequest.setNewDn(request.getNewDn());
        return referralRequest;
    }

    @Override
    protected Operation<ModifyDnRequest, Void> createReferralOperation(Connection conn) {
        return new ModifyDnOperation(conn);
    }
}

