/*
 * Decompiled with CFR 0.152.
 */
package com.plantuml.ubrex;

import com.plantuml.ubrex.Capture;
import com.plantuml.ubrex.Challenge;
import com.plantuml.ubrex.ChallengeResult;
import com.plantuml.ubrex.TextNavigator;

public class ChallengeLazzyOneOrMore
implements Challenge {
    private final Challenge origin;
    private final Challenge end;

    public ChallengeLazzyOneOrMore(Challenge origin, Challenge end) {
        this.origin = origin;
        this.end = end;
    }

    @Override
    public ChallengeResult runChallenge(TextNavigator string, int position) {
        ChallengeResult match1;
        ChallengeResult match2;
        Capture capture = Capture.EMPTY;
        int currentPos = position;
        do {
            if ((match1 = this.origin.runChallenge(string, currentPos)).getFullCaptureLength() < 0) {
                return new ChallengeResult(Integer.MIN_VALUE);
            }
            if (match1.getFullCaptureLength() == 0) {
                throw new IllegalStateException("infinite loop");
            }
            capture = capture.merge(match1.getCapture());
        } while ((match2 = this.end.runChallenge(string, currentPos += match1.getFullCaptureLength())).getFullCaptureLength() < 0);
        int result = currentPos + match2.getFullCaptureLength() - position;
        int nameLength = currentPos - position;
        return new ChallengeResult(result, capture).withNameLength(nameLength, match2.getCapture());
    }
}

