/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.Arrays;
import java.util.Objects;
import net.sourceforge.plantuml.sequencediagram.graphic.Frontier;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantRange;

class FrontierComplex
implements Frontier {
    private final double[] freeY;

    public static FrontierComplex create(double freeY, int rangeEnd) {
        FrontierComplex result = new FrontierComplex(new double[rangeEnd + 1]);
        for (int i = 0; i <= rangeEnd; ++i) {
            result.freeY[i] = freeY;
        }
        return result;
    }

    private FrontierComplex(double[] freeY) {
        this.freeY = freeY;
    }

    @Override
    public double getFreeY(ParticipantRange range) {
        Objects.requireNonNull(range);
        double result = this.freeY[range.start()];
        for (int i = range.start(); i <= range.end(); ++i) {
            if (!(this.freeY[i] > result)) continue;
            result = this.freeY[i];
        }
        return result;
    }

    public String toString() {
        return Arrays.toString(this.freeY);
    }

    @Override
    public FrontierComplex add(double delta, ParticipantRange range) {
        Objects.requireNonNull(range);
        FrontierComplex result = new FrontierComplex((double[])this.freeY.clone());
        double newV = result.getFreeY(range) + delta;
        for (int i = range.start(); i <= range.end(); ++i) {
            result.freeY[i] = newV;
        }
        return result;
    }

    FrontierComplex copy() {
        return new FrontierComplex((double[])this.freeY.clone());
    }

    FrontierComplex mergeMax(FrontierComplex other) {
        if (this.freeY.length != other.freeY.length) {
            throw new IllegalArgumentException();
        }
        FrontierComplex result = new FrontierComplex(new double[this.freeY.length]);
        for (int i = 0; i < this.freeY.length; ++i) {
            result.freeY[i] = Math.max(this.freeY[i], other.freeY[i]);
        }
        return result;
    }
}

