/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree.p1treeify;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.elk.alg.mrtree.TreeLayoutPhases;
import org.eclipse.elk.alg.mrtree.graph.TEdge;
import org.eclipse.elk.alg.mrtree.graph.TGraph;
import org.eclipse.elk.alg.mrtree.graph.TNode;
import org.eclipse.elk.alg.mrtree.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.mrtree.options.InternalProperties;
import org.eclipse.elk.alg.mrtree.options.MrTreeOptions;
import org.eclipse.elk.alg.mrtree.options.TreeifyingOrder;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class DFSTreeifyer
implements ILayoutPhase<TreeLayoutPhases, TGraph> {
    private static final LayoutProcessorConfiguration<TreeLayoutPhases, TGraph> INTERMEDIATE_PROCESSING_CONFIG = LayoutProcessorConfiguration.create().addAfter(TreeLayoutPhases.P3_NODE_PLACEMENT, IntermediateProcessorStrategy.DETREEIFYING_PROC);
    private int[] visited;
    private List<TEdge> eliminated;

    @Override
    public void process(TGraph tGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("DFS Treeifying phase", 1.0f);
        this.init(tGraph);
        this.collectEdges(tGraph);
        this.eliminated = null;
        this.visited = null;
        progressMonitor.done();
    }

    @Override
    public LayoutProcessorConfiguration<TreeLayoutPhases, TGraph> getLayoutProcessorConfiguration(TGraph graph) {
        return INTERMEDIATE_PROCESSING_CONFIG;
    }

    private void init(TGraph tGraph) {
        int size = tGraph.getNodes().size();
        this.eliminated = new LinkedList<TEdge>();
        this.visited = new int[size];
        int id = 0;
        for (TNode node : tGraph.getNodes()) {
            node.id = id++;
        }
    }

    private void collectEdges(TGraph tGraph) {
        TreeifyingOrder treeifyingOrder = tGraph.getProperty(MrTreeOptions.SEARCH_ORDER);
        for (TNode tNode : tGraph.getNodes()) {
            if (this.visited[tNode.id] != 0) continue;
            switch (treeifyingOrder) {
                case DFS: {
                    this.dfs(tNode);
                    break;
                }
                case BFS: {
                    this.bfs(tNode);
                }
            }
            this.visited[tNode.id] = 2;
        }
        for (TEdge tEdge : this.eliminated) {
            tEdge.getSource().getOutgoingEdges().remove(tEdge);
            tEdge.getTarget().getIncomingEdges().remove(tEdge);
        }
        tGraph.setProperty(InternalProperties.REMOVABLE_EDGES, this.eliminated);
    }

    private void dfs(TNode tNode) {
        this.visited[tNode.id] = 1;
        for (TEdge tEdge : tNode.getOutgoingEdges()) {
            TNode target = tEdge.getTarget();
            if (this.visited[target.id] == 1) {
                this.eliminated.add(tEdge);
                continue;
            }
            if (this.visited[target.id] == 2) {
                this.visited[target.id] = 1;
                continue;
            }
            this.dfs(target);
        }
    }

    private void bfs(TNode startNode) {
        LinkedList<TNode> nodeQueue = new LinkedList<TNode>();
        nodeQueue.add(startNode);
        do {
            TNode node = (TNode)nodeQueue.removeFirst();
            this.visited[node.id] = 1;
            for (TEdge tEdge : node.getOutgoingEdges()) {
                TNode target = tEdge.getTarget();
                if (this.visited[target.id] == 1) {
                    this.eliminated.add(tEdge);
                    continue;
                }
                if (this.visited[target.id] == 2) {
                    this.visited[target.id] = 1;
                    continue;
                }
                nodeQueue.addLast(target);
            }
        } while (!nodeQueue.isEmpty());
    }
}

