# Validator\[T: T\]
<span class="source-link">[[Source]](src/constrained_types/constrained.md#L-0-28)</span>

Interface validators must implement.

We strongly suggest you use a `primitive` for your `Validator` as validators
are required to be stateless.


```pony
interface val Validator[T: T]
```

## Constructors

### create
<span class="source-link">[[Source]](src/constrained_types/constrained.md#L-0-35)</span>


```pony
new val create()
: Validator[T] val^
```

#### Returns

* [Validator](constrained_types-Validator.md)\[T\] val^

---

## Public Functions

### apply
<span class="source-link">[[Source]](src/constrained_types/constrained.md#L-0-36)</span>


Takes an instance and returns either `ValidationSuccess` if it meets the
constraint criteria or `ValidationFailure` if it doesn't.


```pony
fun box apply(
  i: T)
: (ValidationSuccess val | ValidationFailure val)
```
#### Parameters

*   i: T

#### Returns

* ([ValidationSuccess](constrained_types-ValidationSuccess.md) val | [ValidationFailure](constrained_types-ValidationFailure.md) val)

---

