// Copyright (C) 2025 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
// Qt-Security score:significant reason:default

#ifndef QQSTYLEKITFONT_H
#define QQSTYLEKITFONT_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists purely as an
// implementation detail.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include <QtQml/QtQml>
#include <QtQuickTemplates2/private/qquicktheme_p.h>
#include <QtGui/qfont.h>

QT_BEGIN_NAMESPACE

class QQStyleKitFont : public QObject
{
    Q_OBJECT
    Q_PROPERTY(QFont system READ system WRITE setSystem NOTIFY systemChanged FINAL)
    Q_PROPERTY(QFont button READ button WRITE setButton NOTIFY buttonChanged FINAL)
    Q_PROPERTY(QFont checkBox READ checkBox WRITE setCheckBox NOTIFY checkBoxChanged FINAL)
    Q_PROPERTY(QFont comboBox READ comboBox WRITE setComboBox NOTIFY comboBoxChanged FINAL)
    Q_PROPERTY(QFont groupBox READ groupBox WRITE setGroupBox NOTIFY groupBoxChanged FINAL)
    Q_PROPERTY(QFont itemView READ itemView WRITE setItemView NOTIFY itemViewChanged FINAL)
    Q_PROPERTY(QFont label READ label WRITE setLabel NOTIFY labelChanged FINAL)
    Q_PROPERTY(QFont listView READ listView WRITE setListView NOTIFY listViewChanged FINAL)
    Q_PROPERTY(QFont menu READ menu WRITE setMenu NOTIFY menuChanged FINAL)
    Q_PROPERTY(QFont menuBar READ menuBar WRITE setMenuBar NOTIFY menuBarChanged FINAL)
    Q_PROPERTY(QFont radioButton READ radioButton WRITE setRadioButton NOTIFY radioButtonChanged FINAL)
    Q_PROPERTY(QFont spinBox READ spinBox WRITE setSpinBox NOTIFY spinBoxChanged FINAL)
    Q_PROPERTY(QFont switchControl READ switchControl WRITE setSwitchControl NOTIFY switchControlChanged FINAL)
    Q_PROPERTY(QFont tabBar READ tabBar WRITE setTabBar NOTIFY tabBarChanged FINAL)
    Q_PROPERTY(QFont textArea READ textArea WRITE setTextArea NOTIFY textAreaChanged FINAL)
    Q_PROPERTY(QFont textField READ textField WRITE setTextField NOTIFY textFieldChanged FINAL)
    Q_PROPERTY(QFont toolBar READ toolBar WRITE setToolBar NOTIFY toolBarChanged FINAL)
    Q_PROPERTY(QFont toolTip READ toolTip WRITE setToolTip NOTIFY toolTipChanged FINAL)
    Q_PROPERTY(QFont tumbler READ tumbler WRITE setTumbler NOTIFY tumblerChanged FINAL)

    QML_NAMED_ELEMENT(StyleKitFont)

public:
    QQStyleKitFont(QObject *parent = nullptr);
    QFont system() const;
    void setSystem(const QFont &font);

    QFont button() const;
    void setButton(const QFont &font);

    QFont checkBox() const;
    void setCheckBox(const QFont &font);

    QFont comboBox() const;
    void setComboBox(const QFont &font);

    QFont groupBox() const;
    void setGroupBox(const QFont &font);

    QFont itemView() const;
    void setItemView(const QFont &font);

    QFont label() const;
    void setLabel(const QFont &font);

    QFont listView() const;
    void setListView(const QFont &font);

    QFont menu() const;
    void setMenu(const QFont &font);

    QFont menuBar() const;
    void setMenuBar(const QFont &font);

    QFont radioButton() const;
    void setRadioButton(const QFont &font);

    QFont spinBox() const;
    void setSpinBox(const QFont &font);

    QFont switchControl() const;
    void setSwitchControl(const QFont &font);

    QFont tabBar() const;
    void setTabBar(const QFont &font);

    QFont textArea() const;
    void setTextArea(const QFont &font);

    QFont textField() const;
    void setTextField(const QFont &font);

    QFont toolBar() const;
    void setToolBar(const QFont &font);

    QFont toolTip() const;
    void setToolTip(const QFont &font);

    QFont tumbler() const;
    void setTumbler(const QFont &font);

    QQStyleKitFont *fallbackFont() const;
    void setFallbackFont(QQStyleKitFont *fallback);

    QFont fontForScope(QQuickTheme::Scope scope) const;

signals:
    void systemChanged();
    void buttonChanged();
    void checkBoxChanged();
    void comboBoxChanged();
    void groupBoxChanged();
    void itemViewChanged();
    void labelChanged();
    void listViewChanged();
    void menuChanged();
    void menuBarChanged();
    void radioButtonChanged();
    void spinBoxChanged();
    void switchControlChanged();
    void tabBarChanged();
    void textAreaChanged();
    void textFieldChanged();
    void toolBarChanged();
    void toolTipChanged();
    void tumblerChanged();
    void fallbackFontChanged();

private:
    Q_DISABLE_COPY(QQStyleKitFont)

    void ensureEffectiveUpToDate() const;
    void markEffectiveDirty() { m_effectiveDirty = true; }

    void setFontForScope(QQuickTheme::Scope scope, const QFont &font, void (QQStyleKitFont::*signal)());

    bool isSet(QQuickTheme::Scope scope) const { return (m_setMask & (1u << int(scope))) != 0; }
    void markSet(QQuickTheme::Scope scope) { m_setMask |= (1u << int(scope)); }

    static const int NScopes = QQuickTheme::Tumbler + 1;
    QFont m_local[NScopes];
    mutable QFont m_effective[NScopes];
    quint32 m_setMask = 0;
    mutable bool m_effectiveDirty = false;

    QQStyleKitFont *m_fallback = nullptr;
};

QT_END_NAMESPACE

#endif // QQSTYLEKITFONT_H
