\name{Atan2ImageFilter}
\alias{Atan2ImageFilter}
\title{Atan2ImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Computes two argument inverse tangent.
Atan2ImageFilter}
\details{
The first argument to the atan function is provided by a pixel in the
first input image (SetInput1() ) and the corresponding pixel in the
second input image (SetInput2() ) is used as the second argument.
This class is templated over the types of the two input images and the
type of the output image. Numeric conversions (castings) are done by
the C++ defaults.
Both pixel input types are cast to double in order to be used as
parameters of std::atan2() . The resulting double value is cast to the
output pixel type.
See:
Atan2 for the procedural interface
itk::Atan2ImageFilter for the Doxygen on the original ITK class.
Atan2ImageFilter}
%C++ includes: sitkAtan2ImageFilter.h
\section{Methods}{
\describe{
\item{ Atan2ImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1, const Image &image2):}{}
\item{Image Execute(const Image &image1, double constant):}{
Execute the filter with an image and a constant
}
\item{Image Execute(double constant, const Image &image2):}{}
\item{Image Execute(Image &&image1, const Image &image2):}{
Execute the filter on the input images
}
\item{Image Execute(Image &&image1, double constant):}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~Atan2ImageFilter():}{
Destructor
}
}
}
