\name{ClosingByReconstructionImageFilter}
\alias{ClosingByReconstructionImageFilter}
\title{ClosingByReconstructionImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Closing by reconstruction of an image.
ClosingByReconstructionImageFilter}
\details{
This filter is similar to the morphological closing, but contrary to
the morphological closing, the closing by reconstruction preserves the
shape of the components. The closing by reconstruction of an image
"f" is defined as:
ClosingByReconstruction(f) = ErosionByReconstruction(f, Dilation(f)).
Closing by reconstruction not only preserves structures preserved by
the dilation, but also levels raises the contrast of the darkest
regions. If PreserveIntensities is on, a subsequent reconstruction by
dilation using a marker image that is the original image for all
unaffected pixels.
Closing by reconstruction is described in Chapter 6.3.9 of Pierre
Soille's book "Morphological Image Analysis: Principles and
Applications", Second Edition, Springer, 2003.
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
See:
GrayscaleMorphologicalClosingImageFilter
ClosingByReconstruction for the procedural interface
itk::ClosingByReconstructionImageFilter for the Doxygen on the original ITK class.
ClosingByReconstructionImageFilter}
%C++ includes: sitkClosingByReconstructionImageFilter.h
\section{Methods}{
\describe{
\item{ ClosingByReconstructionImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{Self FullyConnectedOff():}{}
\item{Self FullyConnectedOn():}{
Set the value of FullyConnected to true or false respectfully.
}
\item{bool GetFullyConnected() const:}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{std::vector< unsigned int > GetKernelRadius() const:}{
Get the radius of the kernel structuring element.
}
\item{KernelEnum GetKernelType() const:}{
Get the kernel or structuring element used for the morphology.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetPreserveIntensities() const:}{
Set/Get whether the original intensities of the image retained for
those pixels unaffected by the opening by reconstruction. If Off, the
output pixel contrast will be reduced.
}
\item{Self PreserveIntensitiesOff():}{}
\item{Self PreserveIntensitiesOn():}{
Set the value of PreserveIntensities to true or false respectfully.
}
\item{Self SetFullyConnected(bool FullyConnected):}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{Self SetKernelRadius(std::vector< unsigned int > KernelRadius):}{
Set the radius of the kernel structuring element.
}
\item{Self SetKernelRadius(unsigned int value):}{
Set the values of the KernelRadius vector all to value
}
\item{Self SetKernelType(KernelEnum KernelType):}{
Set the kernel or structuring element used for the morphology.
}
\item{Self SetPreserveIntensities(bool PreserveIntensities):}{
Set/Get whether the original intensities of the image retained for
those pixels unaffected by the opening by reconstruction. If Off, the
output pixel contrast will be reduced.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~ClosingByReconstructionImageFilter():}{
Destructor
}
}
}
