
# 11 "plugins/ltac/g_auto.mlg"
 

open Pp
open Stdarg
open Procq.Prim
open Procq.Constr
open Pltac
open Hints


# 14 "plugins/ltac/g_auto.ml"

let _ = Mltop.add_known_module "rocq-runtime.plugins.ltac"
let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "eassumption" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("eassumption", Tacentries.TyNil), 
           (fun ist -> 
# 28 "plugins/ltac/g_auto.mlg"
                         Eauto.e_assumption 
# 22 "plugins/ltac/g_auto.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "eexact" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("eexact", Tacentries.TyArg (
                                                          Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                          Tacentries.TyNil)), 
           (fun c ist -> 
# 32 "plugins/ltac/g_auto.mlg"
                              Eauto.e_give_exact c 
# 32 "plugins/ltac/g_auto.ml"
)))]


# 35 "plugins/ltac/g_auto.mlg"
 

let pr_hintbases _prc _prlc _prt = Pptactic.pr_hintbases


# 42 "plugins/ltac/g_auto.ml"

let (wit_hintbases, hintbases) = Tacentries.argument_extend ~plugin:"rocq-runtime.plugins.ltac" ~name:"hintbases" 
                                 {
                                 Tacentries.arg_parsing = Vernacextend.Arg_rules
                                                          ([(Procq.Production.make
                                                             (Procq.Rule.stop)
                                                             (fun loc -> 
# 46 "plugins/ltac/g_auto.mlg"
           Some [] 
# 52 "plugins/ltac/g_auto.ml"
));
                                                           (Procq.Production.make
                                                            (Procq.Rule.next
                                                             (Procq.Rule.next
                                                              (Procq.Rule.stop)
                                                              ((Procq.Symbol.token (Procq.terminal "with"))))
                                                             ((Procq.Symbol.list1 ((Procq.Symbol.nterm preident)))))
                                                            (fun l _ loc -> 
# 45 "plugins/ltac/g_auto.mlg"
                                      Some l 
# 63 "plugins/ltac/g_auto.ml"
));
                                                           (Procq.Production.make
                                                            (Procq.Rule.next
                                                             (Procq.Rule.next
                                                              (Procq.Rule.stop)
                                                              ((Procq.Symbol.token (Procq.terminal "with"))))
                                                             ((Procq.Symbol.token (Procq.terminal "*"))))
                                                            (fun _ _ loc -> 
# 44 "plugins/ltac/g_auto.mlg"
                      None 
# 74 "plugins/ltac/g_auto.ml"
))]);
                                 Tacentries.arg_tag = Some
                                                      (Geninterp.Val.Opt 
                                                      (Geninterp.Val.List 
                                                      (Geninterp.val_tag (Genarg.topwit wit_preident))));
                                 Tacentries.arg_intern = Tacentries.ArgInternWit (Genarg.OptArg 
                                                         (Genarg.ListArg 
                                                         (wit_preident)));
                                 Tacentries.arg_subst = Tacentries.ArgSubstWit (Genarg.OptArg 
                                                        (Genarg.ListArg 
                                                        (wit_preident)));
                                 Tacentries.arg_interp = Tacentries.ArgInterpWit (Genarg.OptArg 
                                                         (Genarg.ListArg 
                                                         (wit_preident)));
                                 Tacentries.arg_printer = ((fun env sigma -> 
                                                          
# 43 "plugins/ltac/g_auto.mlg"
               pr_hintbases 
# 93 "plugins/ltac/g_auto.ml"
), (fun env sigma -> 
                                                          
# 43 "plugins/ltac/g_auto.mlg"
               pr_hintbases 
# 98 "plugins/ltac/g_auto.ml"
), (fun env sigma -> 
                                                          
# 43 "plugins/ltac/g_auto.mlg"
               pr_hintbases 
# 103 "plugins/ltac/g_auto.ml"
));
                                 }
let _ = (wit_hintbases, hintbases)


# 49 "plugins/ltac/g_auto.mlg"
 

let eval_uconstrs ist cs =
  let flags = Pretyping.{
    use_coercions = true;
    use_typeclasses = NoUseTC;
    solve_unification_constraints = true;
    fail_evar = false;
    expand_evars = true;
    program_mode = false;
    polymorphic = false;
    undeclared_evars_patvars = false;
    patvars_abstract = false;
    unconstrained_sorts = false;
  } in
  let map c env sigma = c env sigma in
  List.map (fun c -> map (Tacinterp.type_uconstr ~flags ist c)) cs

let pr_auto_using_raw env sigma _ _ _  = Pptactic.pr_auto_using @@ Ppconstr.pr_constr_expr env sigma
let pr_auto_using_glob env sigma _ _ _ = Pptactic.pr_auto_using (fun (c,_) ->
    Printer.pr_glob_constr_env env sigma c)
let pr_auto_using env sigma _ _ _ = Pptactic.pr_auto_using @@
     Printer.pr_closed_glob_env env sigma


# 135 "plugins/ltac/g_auto.ml"

let (wit_auto_using, auto_using) = Tacentries.argument_extend ~plugin:"rocq-runtime.plugins.ltac" ~name:"auto_using" 
                                   {
                                   Tacentries.arg_parsing = Vernacextend.Arg_rules
                                                            ([(Procq.Production.make
                                                               (Procq.Rule.stop)
                                                               (fun loc -> 
# 81 "plugins/ltac/g_auto.mlg"
           [] 
# 145 "plugins/ltac/g_auto.ml"
));
                                                             (Procq.Production.make
                                                              (Procq.Rule.next
                                                               (Procq.Rule.next
                                                                (Procq.Rule.stop)
                                                                ((Procq.Symbol.token (Procq.terminal "using"))))
                                                               ((Procq.Symbol.list1sep ((Procq.Symbol.nterm uconstr)) ((Procq.Symbol.rules 
                                                               [Procq.Rules.make 
                                                               (Procq.Rule.next_norec
                                                                (Procq.Rule.stop)
                                                                ((Procq.Symbol.token (Procq.terminal ","))))
                                                               (fun _ loc ->
                                                               ())])) false)))
                                                              (fun l _ loc ->
                                                              
# 80 "plugins/ltac/g_auto.mlg"
                                               l 
# 163 "plugins/ltac/g_auto.ml"
))]);
                                   Tacentries.arg_tag = Some
                                                        (Geninterp.Val.List 
                                                        (Geninterp.val_tag (Genarg.topwit wit_uconstr)));
                                   Tacentries.arg_intern = Tacentries.ArgInternWit (Genarg.ListArg 
                                                           (wit_uconstr));
                                   Tacentries.arg_subst = Tacentries.ArgSubstWit (Genarg.ListArg 
                                                          (wit_uconstr));
                                   Tacentries.arg_interp = Tacentries.ArgInterpWit (Genarg.ListArg 
                                                           (wit_uconstr));
                                   Tacentries.arg_printer = ((fun env sigma -> 
                                                            
# 78 "plugins/ltac/g_auto.mlg"
                   pr_auto_using_raw env sigma 
# 178 "plugins/ltac/g_auto.ml"
), (fun env sigma -> 
                                                            
# 79 "plugins/ltac/g_auto.mlg"
                    pr_auto_using_glob env sigma 
# 183 "plugins/ltac/g_auto.ml"
), (fun env sigma -> 
                                                            
# 77 "plugins/ltac/g_auto.mlg"
               pr_auto_using env sigma 
# 188 "plugins/ltac/g_auto.ml"
));
                                   }
let _ = (wit_auto_using, auto_using)

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "trivial" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("trivial", Tacentries.TyArg (
                                                           Extend.TUentry (Genarg.get_arg_tag wit_auto_using), 
                                                           Tacentries.TyArg (
                                                           Extend.TUentry (Genarg.get_arg_tag wit_hintbases), 
                                                           Tacentries.TyNil))), 
           (fun lems db ist -> 
# 88 "plugins/ltac/g_auto.mlg"
      Auto.gen_trivial (eval_uconstrs ist lems) db 
# 202 "plugins/ltac/g_auto.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "info_trivial" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("info_trivial", Tacentries.TyArg (
                                                                Extend.TUentry (Genarg.get_arg_tag wit_auto_using), 
                                                                Tacentries.TyArg (
                                                                Extend.TUentry (Genarg.get_arg_tag wit_hintbases), 
                                                                Tacentries.TyNil))), 
           (fun lems db ist -> 
# 93 "plugins/ltac/g_auto.mlg"
      Auto.gen_trivial ~debug:Info (eval_uconstrs ist lems) db 
# 214 "plugins/ltac/g_auto.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "debug_trivial" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("debug", Tacentries.TyIdent ("trivial", 
                                                         Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_auto_using), 
                                                         Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_hintbases), 
                                                         Tacentries.TyNil)))), 
           (fun lems db ist -> 
# 98 "plugins/ltac/g_auto.mlg"
      Auto.gen_trivial ~debug:Debug (eval_uconstrs ist lems) db 
# 227 "plugins/ltac/g_auto.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "auto" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("auto", Tacentries.TyArg (
                                                        Extend.TUopt (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_nat_or_var)), 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_auto_using), 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_hintbases), 
                                                        Tacentries.TyNil)))), 
           (fun n lems db ist -> 
# 103 "plugins/ltac/g_auto.mlg"
      Auto.gen_auto n (eval_uconstrs ist lems) db 
# 242 "plugins/ltac/g_auto.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "info_auto" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("info_auto", Tacentries.TyArg (
                                                             Extend.TUopt (
                                                             Extend.TUentry (Genarg.get_arg_tag wit_nat_or_var)), 
                                                             Tacentries.TyArg (
                                                             Extend.TUentry (Genarg.get_arg_tag wit_auto_using), 
                                                             Tacentries.TyArg (
                                                             Extend.TUentry (Genarg.get_arg_tag wit_hintbases), 
                                                             Tacentries.TyNil)))), 
           (fun n lems db ist -> 
# 108 "plugins/ltac/g_auto.mlg"
      Auto.gen_auto ~debug:Info n (eval_uconstrs ist lems) db 
# 257 "plugins/ltac/g_auto.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "debug_auto" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("debug", Tacentries.TyIdent ("auto", 
                                                         Tacentries.TyArg (
                                                         Extend.TUopt (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_nat_or_var)), 
                                                         Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_auto_using), 
                                                         Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_hintbases), 
                                                         Tacentries.TyNil))))), 
           (fun n lems db ist -> 
# 113 "plugins/ltac/g_auto.mlg"
      Auto.gen_auto ~debug:Debug n (eval_uconstrs ist lems) db 
# 273 "plugins/ltac/g_auto.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "eauto" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("eauto", Tacentries.TyArg (
                                                         Extend.TUopt (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_nat_or_var)), 
                                                         Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_auto_using), 
                                                         Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_hintbases), 
                                                         Tacentries.TyNil)))), 
           (fun depth lems db ist -> 
# 120 "plugins/ltac/g_auto.mlg"
    Eauto.gen_eauto ?depth (eval_uconstrs ist lems) db 
# 288 "plugins/ltac/g_auto.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "debug_eauto" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("debug", Tacentries.TyIdent ("eauto", 
                                                         Tacentries.TyArg (
                                                         Extend.TUopt (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_nat_or_var)), 
                                                         Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_auto_using), 
                                                         Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_hintbases), 
                                                         Tacentries.TyNil))))), 
           (fun depth lems db ist -> 
# 125 "plugins/ltac/g_auto.mlg"
    Eauto.gen_eauto ~debug:Debug ?depth (eval_uconstrs ist lems) db 
# 304 "plugins/ltac/g_auto.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "info_eauto" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("info_eauto", Tacentries.TyArg (
                                                              Extend.TUopt (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_nat_or_var)), 
                                                              Tacentries.TyArg (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_auto_using), 
                                                              Tacentries.TyArg (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_hintbases), 
                                                              Tacentries.TyNil)))), 
           (fun depth lems db ist -> 
# 130 "plugins/ltac/g_auto.mlg"
    Eauto.gen_eauto ~debug:Info ?depth (eval_uconstrs ist lems) db 
# 319 "plugins/ltac/g_auto.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "autounfold" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("autounfold", Tacentries.TyArg (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_hintbases), 
                                                              Tacentries.TyArg (
                                                              Extend.TUentry (Genarg.get_arg_tag wit_clause_dft_concl), 
                                                              Tacentries.TyNil))), 
           (fun db cl ist -> 
# 134 "plugins/ltac/g_auto.mlg"
                                                           Eauto.autounfold_tac db cl 
# 331 "plugins/ltac/g_auto.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "autounfold_one" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("autounfold_one", Tacentries.TyArg (
                                                                  Extend.TUentry (Genarg.get_arg_tag wit_hintbases), 
                                                                  Tacentries.TyIdent ("in", 
                                                                  Tacentries.TyArg (
                                                                  Extend.TUentry (Genarg.get_arg_tag wit_hyp), 
                                                                  Tacentries.TyNil)))), 
           (fun db id ist -> 
# 139 "plugins/ltac/g_auto.mlg"
      Eauto.autounfold_one (match db with None -> ["core"] | Some x -> "core"::x) (Some (id, Locus.InHyp)) 
# 344 "plugins/ltac/g_auto.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("autounfold_one", Tacentries.TyArg (
                                                                 Extend.TUentry (Genarg.get_arg_tag wit_hintbases), 
                                                                 Tacentries.TyNil)), 
          (fun db ist -> 
# 141 "plugins/ltac/g_auto.mlg"
      Eauto.autounfold_one (match db with None -> ["core"] | Some x -> "core"::x) None 
# 352 "plugins/ltac/g_auto.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "unify" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("unify", Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                         Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                         Tacentries.TyNil))), 
           (fun x y ist -> 
# 145 "plugins/ltac/g_auto.mlg"
                                      Tactics.unify x y 
# 364 "plugins/ltac/g_auto.ml"
)));
         (Tacentries.TyML (Tacentries.TyIdent ("unify", Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                        Tacentries.TyIdent ("with", 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_preident), 
                                                        Tacentries.TyNil))))), 
          (fun x y base ist -> 
# 146 "plugins/ltac/g_auto.mlg"
                                                            
    let table = try Some (Hints.searchtable_map base) with Not_found -> None in
    match table with
    | None ->
      let msg = str "Hint table " ++ str base ++ str " not found" in
      Tacticals.tclZEROMSG msg
    | Some t ->
      let state = Hints.Hint_db.transparent_state t in
      Tactics.unify ~state x y
  
# 386 "plugins/ltac/g_auto.ml"
)))]

let () = Tacentries.tactic_extend "rocq-runtime.plugins.ltac" "convert" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("convert", Tacentries.TyArg (
                                                           Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                           Tacentries.TyArg (
                                                           Extend.TUentry (Genarg.get_arg_tag wit_constr), 
                                                           Tacentries.TyNil))), 
           (fun x y ist -> 
# 159 "plugins/ltac/g_auto.mlg"
                                        Tactics.convert x y 
# 398 "plugins/ltac/g_auto.ml"
)))]


# 162 "plugins/ltac/g_auto.mlg"
 

let pr_pre_hints_path c = Hints.pp_hints_path_gen Libnames.pr_qualid c


# 408 "plugins/ltac/g_auto.ml"

let (wit_hints_path, hints_path) =
  Vernacextend.vernac_argument_extend ~plugin:(Some "rocq-runtime.plugins.ltac") ~name:"hints_path" 
  {
    Vernacextend.arg_parsing =
    Vernacextend.Arg_rules
    ([(Procq.Production.make
       (Procq.Rule.next
        (Procq.Rule.next (Procq.Rule.stop) (Procq.Symbol.self))
        (Procq.Symbol.self))
       (fun q p loc -> 
# 178 "plugins/ltac/g_auto.mlg"
                                       Hints.PathSeq (p, q) 
# 422 "plugins/ltac/g_auto.ml"
));
     (Procq.Production.make
      (Procq.Rule.next (Procq.Rule.stop)
       ((Procq.Symbol.token (Procq.terminal "_"))))
      (fun _ loc -> 
# 177 "plugins/ltac/g_auto.mlg"
               Hints.PathAtom Hints.PathAny 
# 430 "plugins/ltac/g_auto.ml"
));
     (Procq.Production.make
      (Procq.Rule.next (Procq.Rule.stop)
       ((Procq.Symbol.list1 ((Procq.Symbol.nterm global)))))
      (fun g loc -> 
# 176 "plugins/ltac/g_auto.mlg"
                             Hints.PathAtom (Hints.PathHints g) 
# 438 "plugins/ltac/g_auto.ml"
));
     (Procq.Production.make
      (Procq.Rule.next
       (Procq.Rule.next
        (Procq.Rule.next (Procq.Rule.stop) (Procq.Symbol.self))
        ((Procq.Symbol.token (Procq.terminal "|"))))
       (Procq.Symbol.self))
      (fun q _ p loc -> 
# 175 "plugins/ltac/g_auto.mlg"
                                           Hints.PathOr (p, q) 
# 449 "plugins/ltac/g_auto.ml"
));
     (Procq.Production.make
      (Procq.Rule.next (Procq.Rule.stop)
       ((Procq.Symbol.token (Procq.terminal "eps"))))
      (fun _ loc -> 
# 174 "plugins/ltac/g_auto.mlg"
                 Hints.PathEpsilon 
# 457 "plugins/ltac/g_auto.ml"
));
     (Procq.Production.make
      (Procq.Rule.next (Procq.Rule.stop)
       ((Procq.Symbol.token (Procq.terminal "emp"))))
      (fun _ loc -> 
# 173 "plugins/ltac/g_auto.mlg"
                 Hints.PathEmpty 
# 465 "plugins/ltac/g_auto.ml"
));
     (Procq.Production.make
      (Procq.Rule.next
       (Procq.Rule.next (Procq.Rule.stop) (Procq.Symbol.self))
       ((Procq.Symbol.token (Procq.terminal "*"))))
      (fun _ p loc -> 
# 172 "plugins/ltac/g_auto.mlg"
                             Hints.PathStar p 
# 474 "plugins/ltac/g_auto.ml"
));
     (Procq.Production.make
      (Procq.Rule.next
       (Procq.Rule.next
        (Procq.Rule.next (Procq.Rule.stop)
         ((Procq.Symbol.token (Procq.terminal "("))))
        (Procq.Symbol.self))
       ((Procq.Symbol.token (Procq.terminal ")"))))
      (fun _ p _ loc -> 
# 171 "plugins/ltac/g_auto.mlg"
                                  p 
# 486 "plugins/ltac/g_auto.ml"
))]);
    Vernacextend.arg_printer = fun env sigma -> 
# 169 "plugins/ltac/g_auto.mlg"
             pr_pre_hints_path 
# 491 "plugins/ltac/g_auto.ml"
;
    }
let _ = (wit_hints_path, hints_path)

let (wit_opthints, opthints) = Tacentries.argument_extend ~plugin:"rocq-runtime.plugins.ltac" ~name:"opthints" 
                               {
                               Tacentries.arg_parsing = Vernacextend.Arg_rules
                                                        ([(Procq.Production.make
                                                           (Procq.Rule.stop)
                                                           (fun loc -> 
# 185 "plugins/ltac/g_auto.mlg"
           None 
# 504 "plugins/ltac/g_auto.ml"
));
                                                         (Procq.Production.make
                                                          (Procq.Rule.next
                                                           (Procq.Rule.next
                                                            (Procq.Rule.stop)
                                                            ((Procq.Symbol.token (Procq.terminal ":"))))
                                                           ((Procq.Symbol.list1 ((Procq.Symbol.nterm preident)))))
                                                          (fun l _ loc -> 
# 184 "plugins/ltac/g_auto.mlg"
                                   Some l 
# 515 "plugins/ltac/g_auto.ml"
))]);
                               Tacentries.arg_tag = Some
                                                    (Geninterp.Val.Opt 
                                                    (Geninterp.Val.List 
                                                    (Geninterp.val_tag (Genarg.topwit wit_preident))));
                               Tacentries.arg_intern = Tacentries.ArgInternWit (Genarg.OptArg 
                                                       (Genarg.ListArg 
                                                       (wit_preident)));
                               Tacentries.arg_subst = Tacentries.ArgSubstWit (Genarg.OptArg 
                                                      (Genarg.ListArg 
                                                      (wit_preident)));
                               Tacentries.arg_interp = Tacentries.ArgInterpWit (Genarg.OptArg 
                                                       (Genarg.ListArg 
                                                       (wit_preident)));
                               Tacentries.arg_printer = ((fun env sigma -> 
                                                        
# 183 "plugins/ltac/g_auto.mlg"
               pr_hintbases 
# 534 "plugins/ltac/g_auto.ml"
), (fun env sigma -> 
                                                        
# 183 "plugins/ltac/g_auto.mlg"
               pr_hintbases 
# 539 "plugins/ltac/g_auto.ml"
), (fun env sigma -> 
                                                        
# 183 "plugins/ltac/g_auto.mlg"
               pr_hintbases 
# 544 "plugins/ltac/g_auto.ml"
));
                               }
let _ = (wit_opthints, opthints)

let () = Vernacextend.static_vernac_extend ~plugin:(Some "rocq-runtime.plugins.ltac") ~command:"HintCut" ~classifier:(fun ~atts:_ _ -> Vernacextend.classify_as_sideeff) ?entry:None 
         [(Vernacextend.TyML
         (false,
          Vernacextend.TyTerminal
          ("Hint",
           Vernacextend.TyTerminal
           ("Cut",
            Vernacextend.TyTerminal
            ("[",
             Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_hints_path),
             Vernacextend.TyTerminal
             ("]",
              Vernacextend.TyNonTerminal (Extend.TUentry (Genarg.get_arg_tag wit_opthints),
              Vernacextend.TyNil)))))),
          (let coqpp_body p dbnames locality =
            Vernactypes.vtdefault (fun () -> 
# 189 "plugins/ltac/g_auto.mlg"
                                                                                                         
  let entry = Hints.HintsCutEntry (Hints.glob_hints_path p) in
  Hints.add_hints ~locality
    (match dbnames with None -> ["core"] | Some l -> l) entry;
 
# 571 "plugins/ltac/g_auto.ml"
) in
            fun p dbnames ?loc ~atts () ->
            coqpp_body p dbnames (Attributes.parse 
# 189 "plugins/ltac/g_auto.mlg"
                 Attributes.hint_locality
# 577 "plugins/ltac/g_auto.ml"
 atts)),
          None))]

